package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Mail;
import org.jbpm.gd.jpdl.model.Subject;

public class MailConfigurationComposite implements SelectionListener, FocusListener {
	
	public static MailConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		MailConfigurationComposite result = new MailConfigurationComposite();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.create();
		return result;
	}
	
	private TabbedPropertySheetWidgetFactory widgetFactory;
	private Composite parent;
	
	private Group mailInfoGroup;
	private Label nameLabel;
	private Text nameText;
	private Label templateLabel;
	private Text templateText;
	private Button asyncButton;
	private Button toButton;
	private Text toText;
	private Button actorsButton;
	private Text actorsText;
	private Label subjectLabel;
	private Text subjectText;
	private Label bodyLabel;
	private Text bodyText;
	
	private Mail mail;
	
	private MailConfigurationComposite() {}
	
	public void setMail(Mail mail) {
		if (this.mail == mail) return;
		unhookListeners();
		this.mail = mail;
		if (mail == null) {
			clearControls();
		} else {
			updateControls();
			hookListeners();
		}
	}
	
	public Mail getMail() {
		return mail;
	}
	
	private void hookListeners() {
		nameText.addSelectionListener(this);
		nameText.addFocusListener(this);
		templateText.addSelectionListener(this);
		templateText.addFocusListener(this);
		asyncButton.addSelectionListener(this);
		toButton.addSelectionListener(this);
		toText.addSelectionListener(this);
		toText.addFocusListener(this);
		actorsButton.addSelectionListener(this);
		actorsText.addSelectionListener(this);
		actorsText.addFocusListener(this);
		subjectText.addSelectionListener(this);
		subjectText.addFocusListener(this);
		bodyText.addSelectionListener(this);
		bodyText.addFocusListener(this);
	}
	
	private void unhookListeners() {
		nameText.removeSelectionListener(this);
		nameText.removeFocusListener(this);
		templateText.removeSelectionListener(this);
		templateText.removeFocusListener(this);
		asyncButton.removeSelectionListener(this);
		toButton.removeSelectionListener(this);
		toText.removeSelectionListener(this);
		toText.removeFocusListener(this);
		actorsButton.removeSelectionListener(this);
		actorsText.removeSelectionListener(this);
		actorsText.removeFocusListener(this);
		subjectText.removeSelectionListener(this);
		subjectText.removeFocusListener(this);
		bodyText.removeSelectionListener(this);
		bodyText.removeFocusListener(this);
	}
	
	private void clearControls() {
		nameText.setText("");
		templateText.setText("");
		asyncButton.setSelection(false);
		toButton.setSelection(true);
		toText.setText("");
		toText.setEnabled(true);
		actorsButton.setSelection(false);
		actorsText.setText("");
		actorsText.setEnabled(false);
		subjectText.setText("");
		bodyText.setText("");
	}
	
	private void updateControls() {
		nameText.setText(mail.getName() == null ? "" : mail.getName());
		templateText.setText(mail.getTemplate() == null ? "" : mail.getTemplate());
		asyncButton.setSelection("true".equals(mail.getAsync()));
		if (mail.getActors() != null) {
			toButton.setSelection(false);
			actorsButton.setSelection(true);
			toText.setText("");
			toText.setEnabled(false);
			actorsText.setText(mail.getActors());
			actorsText.setEnabled(true);
		} else {
			toButton.setSelection(true);
			actorsButton.setSelection(false);
			actorsText.setText("");
			actorsText.setEnabled(false);
			toText.setText(mail.getTo() == null ? "" : mail.getTo());
			toText.setEnabled(true);
		}
		subjectText.setText(getSubjectText());
		bodyText.setText(getBodyText());
	}
	
	private String getSubjectText() {
		String result = "";
		Subject subject = mail.getSubject();
		if (subject != null) {
			result = subject.getSubject() == null ? "" : subject.getSubject();
		}
		return result;
	}
	
	private String getBodyText() {
		String result = "";
		if (mail.getText() != null) {
			result = mail.getText().getText() == null ? "" : mail.getText().getText();
		}
		return result;
	}
	
	private void create() {
		mailInfoGroup = widgetFactory.createGroup(parent, "Mail Info");
		mailInfoGroup.setLayout(new FormLayout());
		mailInfoGroup.setLayoutData(createMailInfoGroupLayoutData());
		nameLabel = widgetFactory.createLabel(mailInfoGroup, "Name");
		nameText = widgetFactory.createText(mailInfoGroup, "");
		templateLabel = widgetFactory.createLabel(mailInfoGroup, "Template");
		templateText = widgetFactory.createText(mailInfoGroup, "");
		asyncButton = widgetFactory.createButton(mailInfoGroup, "Async", SWT.CHECK);
		toButton = widgetFactory.createButton(mailInfoGroup, "To", SWT.RADIO);
		toButton.setSelection(true);
		toText = widgetFactory.createText(mailInfoGroup, "");
		actorsButton = widgetFactory.createButton(mailInfoGroup, "Actors", SWT.RADIO);
		actorsText = widgetFactory.createText(mailInfoGroup, "");
		actorsText.setEnabled(false);
		subjectLabel = widgetFactory.createLabel(mailInfoGroup, "Subject");
		subjectText = widgetFactory.createText(mailInfoGroup, "");
		bodyLabel = widgetFactory.createLabel(mailInfoGroup, "Body");
		bodyText = widgetFactory.createText(mailInfoGroup, "", SWT.MULTI | SWT.V_SCROLL);
		nameLabel.setLayoutData(createNameLabelLayoutData());
		nameText.setLayoutData(createNameTextLayoutData());
		templateLabel.setLayoutData(createTemplateLabelLayoutData());
		templateText.setLayoutData(createTemplateTextLayoutData());
		asyncButton.setLayoutData(createAsyncButtonLayoutData());
		toButton.setLayoutData(createToButtonLayoutData());
		toText.setLayoutData(createToTextLayoutData());
		actorsButton.setLayoutData(createActorsButtonLayoutData());
		actorsText.setLayoutData(createActorsTextLayoutData());
		subjectLabel.setLayoutData(createSubjectLabelLayoutData());
		subjectText.setLayoutData(createSubjectTextLayoutData());
		bodyLabel.setLayoutData(createBodyLabelLayoutData());
		bodyText.setLayoutData(createBodyTextLayoutData());
	}
	
	private FormData createAsyncButtonLayoutData() {
		FormData data = new FormData();
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createToButtonLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(nameText, 5);
		return data;
	}
	
	private FormData createToTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(subjectText, 0);
		data.left.alignment = SWT.LEFT;
		data.top = new FormAttachment(nameText, 5);
		data.right = new FormAttachment(50, 0);
		return data;
	}
	
	private FormData createActorsButtonLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(toText, 5);
		data.top = new FormAttachment(nameText, 5);
		return data;
	}
	
	private FormData createActorsTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(actorsButton, 5);
		data.top = new FormAttachment(nameText, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createSubjectLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(toText, 5);
		return data;
	}
	
	private FormData createSubjectTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(subjectLabel, 5);
		data.top = new FormAttachment(toText, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createBodyLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(subjectText, 5);
		return data;
	}
	
	private FormData createBodyTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(subjectText, 0);
		data.left.alignment = SWT.LEFT;
		data.top = new FormAttachment(subjectText, 5);
		data.right = new FormAttachment(100, -5);
		data.bottom = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createTemplateTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(actorsText, 0);
		data.left.alignment = SWT.LEFT;
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(asyncButton, -5);
		data.right.alignment = SWT.LEFT;
		return data;
	}
	
	private FormData createTemplateLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(nameText, 5);
		data.top = new FormAttachment(0, 5);
		return data;
	}
	
	private FormData createNameLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		return data;
	}
	
	private FormData createNameTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(subjectText, 0);
		data.left.alignment = SWT.LEFT;
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(50, 0);
		return data;
	}
	
	private FormData createMailInfoGroupLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		data.bottom = new FormAttachment(100, -5);
		return data;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		if (e.widget == nameText) {
			mail.setName(nameText.getText());
		} else if (e.widget == templateText) {
			mail.setTemplate(getTemplateText());
		} else if (e.widget == toText) {
			mail.setTo(toText.getText());
		} else if (e.widget == actorsText) {
			mail.setActors(actorsText.getText());
		} else if (e.widget == subjectText) {
			handleSubjectTextChange();
		} else if (e.widget == bodyText) {
			handleBodyTextChange();
		}
	}
	
	private void handleSubjectTextChange() {
		Subject subject = mail.getSubject();
		if (subject == null) {
			subject = (Subject)JpdlElementFactory.INSTANCE.createById("org.jbpm.gd.jpdl.core.subject");
			mail.setSubject(subject);
		}
		subject.setSubject(subjectText.getText());
	}

	private void handleBodyTextChange() {
		org.jbpm.gd.jpdl.model.Text text = mail.getText();
		if (text == null) {
			text = (org.jbpm.gd.jpdl.model.Text)JpdlElementFactory.INSTANCE.createById("org.jbpm.gd.jpdl.core.text");
			mail.setText(text);
		}
		text.setText(bodyText.getText());
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == asyncButton) {
			mail.setAsync(asyncButton.getSelection() ? "true" : "false");
		} else if (e.widget == toButton) {
			handleToButtonSelection();
		}
	}
	
	private void handleToButtonSelection() {
		if (toButton.getSelection()) {
			mail.setTo(toText.getText());
			mail.setActors(null);
			actorsText.setEnabled(false);
			toText.setEnabled(true);
		} else {
			mail.setActors(actorsText.getText());
			mail.setTo(null);
			toText.setEnabled(false);
			actorsText.setEnabled(true);
		}
	}

	public void focusGained(FocusEvent e) {
	}

	public void focusLost(FocusEvent e) {
		if (e.widget == nameText) {
			mail.setName(nameText.getText());
		} else if (e.widget == templateText) {
			mail.setTemplate(getTemplateText());
		} else if (e.widget == toText) {
			mail.setTo(toText.getText());
		} else if (e.widget == actorsText) {
			mail.setActors(actorsText.getText());
		} else if (e.widget == subjectText) {
			handleSubjectTextChange();
		} else if (e.widget == bodyText) {
			handleBodyTextChange();
		}
	}
	
	private String getTemplateText()  {
		return "".equals(templateText.getText()) ? null : templateText.getText();
	}
	
}
