package org.jbpm.gd.jpdl.ui.util;

import org.eclipse.gef.EditPart;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Transition;

public class AttributeTester {
	

	public static boolean testAttribute(Object target, String name, String value) {
		if ("canAddActions".equals(name) && "true".equals(value)) {
			return "true".equals(value) ? canAddActions(target) : false;
		} else if ("canAddProcessEvents".equals(name)) {
			return "true".equals(value) ? canAddProcessEvents(target) : false;
		} else if ("canAddNodeEvents".equals(name)) {
			return "true".equals(value) ? canAddNodeEvents(target) : false;
		} else if ("canAddTasks".equals(name)) {
			return "true".equals(value) ? canAddTasks(target) : false;
		} else if ("nodeIdEqualsTo".equals(name)) {
			return nodeTagEqualsTo(target, value); 
		} else if ("nodeIdDifferentFrom".equals(name)) {
			return !nodeTagEqualsTo(target, value);
		}
		return false;
	}
	
	private static AbstractJpdlElement getSemanticElement(Object target) {
		if (!(target instanceof EditPart)) return null;
		Object model = ((EditPart)target).getModel();
		if (model instanceof AbstractNotationElement) {
			model = ((AbstractNotationElement)model).getSemanticElement();
		} 
		if (model instanceof AbstractJpdlElement) {
			return (AbstractJpdlElement)model;
		} else {
			return null;
		}
	}
	
	private static boolean canAddActions(Object target) {
		AbstractJpdlElement jpdlElement = getSemanticElement(target);
		return (jpdlElement instanceof Event || jpdlElement instanceof Transition);
	}
	
	private static boolean canAddProcessEvents(Object target) {
		AbstractJpdlElement jpdlElement = getSemanticElement(target);
		return (jpdlElement instanceof ProcessDefinition);
	}
	
	private static boolean canAddNodeEvents(Object target) {
		AbstractJpdlElement jpdlElement = getSemanticElement(target);
		return (jpdlElement instanceof AbstractNode || jpdlElement instanceof ProcessDefinition);
	}
	
	private static boolean canAddTasks(Object target) {
		AbstractJpdlElement jpdlElement = getSemanticElement(target);
		return (jpdlElement instanceof StartState) ? ((StartState)jpdlElement).getTask() == null :  false;
	}
	
	private static boolean nodeTagEqualsTo(Object target, String value) {
		AbstractJpdlElement jpdlElement = getSemanticElement(target);
		return jpdlElement == null ? false : jpdlElement.getElementId().equals(value);
	}
	
}
