/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.swt.events.TypedEvent;
import org.jboss.tools.common.model.ui.editors.dnd.context.DropContext;
import org.jboss.tools.common.model.ui.editors.dnd.context.IDNDTextEditor;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VpeDndUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNSDocument;
import org.mozilla.interfaces.nsIDragService;
import org.mozilla.interfaces.nsIDragSession;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsISupportsString;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.Node;

public class DndUtil {
    public static final String kTextMime = "text/plain";
    public static final String kUnicodeMime = "text/unicode";
    public static final String kHTMLMime = "text/html";
    public static final String kAOLMailMime = "AOLMAIL";
    public static final String kPNGImageMime = "image/png";
    public static final String kJPEGImageMime = "image/jpg";
    public static final String kGIFImageMime = "image/gif";
    public static final String kFileMime = "application/x-moz-file";
    public static final String kURLMime = "text/x-moz-url";
    public static final String kURLDataMime = "text/x-moz-url-data";
    public static final String kURLDescriptionMime = "text/x-moz-url-desc";
    public static final String kNativeImageMime = "application/x-moz-nativeimage";
    public static final String kNativeHTMLMime = "application/x-moz-nativehtml";
    public static final String kFilePromiseURLMime = "application/x-moz-file-promise-url";
    public static final String kFilePromiseMime = "application/x-moz-file-promise";
    public static final String kFilePromiseDirectoryMime = "application/x-moz-file-promise-dir";
    public static final String VPE_XPATH_FLAVOR = "vpe/xpath";

    private DndUtil() {
    }

    public static void fireDnDEvent(DropContext dropContext, IDNDTextEditor textEditor, TypedEvent event) {
        dropContext.runDropCommand(textEditor, event);
    }

    public static DragTransferData getDragTransferData(String ... flavors) {
        nsIDragSession dragSession = DndUtil.getCurrentDragSession();
        String[] supportedFlavors = DndUtil.getSupportedDataFlavors(dragSession, flavors);
        if (supportedFlavors.length > 0) {
            nsITransferable iTransferable = DndUtil.createTransferable(supportedFlavors);
            String[] aFlavor = new String[1];
            nsISupports[] aValue = new nsISupports[1];
            long[] aDataLen = new long[1];
            dragSession.getData(iTransferable, 0L);
            iTransferable.getAnyTransferData(aFlavor, aValue, aDataLen);
            return new DragTransferData(aFlavor[0], aValue[0], aDataLen[0]);
        }
        return null;
    }

    public static String getDragTransferDataAsString(String ... flavors) {
        DragTransferData transferData = DndUtil.getDragTransferData(flavors);
        if (transferData == null || transferData.getValue() == null) {
            return null;
        }
        nsISupports value = transferData.getValue();
        if (VpeDndUtil.isNsIStringInstance(value)) {
            return ((nsISupportsString)XPCOM.queryInterface((nsISupports)value, nsISupportsString.class)).getData();
        }
        return null;
    }

    public static nsITransferable createTransferable(String ... flavors) {
        nsIComponentManager componentManager = Mozilla.getInstance().getComponentManager();
        nsITransferable iTransferable = (nsITransferable)componentManager.createInstanceByContractID("@mozilla.org/widget/transferable;1", null, "{8b5314bc-db01-11d2-96ce-0060b0fb9956}");
        String[] stringArray = flavors;
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            String flavor = stringArray[n2];
            iTransferable.addDataFlavor(flavor);
            ++n2;
        }
        return iTransferable;
    }

    public static String[] getSupportedDataFlavors(nsIDragSession dragSession, String ... flavors) {
        ArrayList<String> supportedDataFlavors = new ArrayList<String>();
        String[] stringArray = flavors;
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            String flavor = stringArray[n2];
            if (dragSession.isDataFlavorSupported(flavor)) {
                supportedDataFlavors.add(flavor);
            }
            ++n2;
        }
        return supportedDataFlavors.toArray(new String[supportedDataFlavors.size()]);
    }

    public static nsIDragSession getCurrentDragSession() {
        nsIServiceManager serviceManager = Mozilla.getInstance().getServiceManager();
        nsIDragService dragService = (nsIDragService)serviceManager.getServiceByContractID("@mozilla.org/widget/dragservice;1", "{82b58ada-f490-4c3d-b737-1057c4f1d052}");
        nsIDragSession dragSession = dragService.getCurrentSession();
        return dragSession;
    }

    public static void setTemporaryDndElement(nsIDOMElement element, boolean temporary) {
        if (temporary) {
            element.setAttribute("vpeTemporaryDndElement", Boolean.TRUE.toString());
        } else {
            element.removeAttribute("vpeTemporaryDndElement");
        }
    }

    public static boolean isTemporaryDndElement(nsIDOMElement element) {
        String attribute = element.getAttribute("vpeTemporaryDndElement");
        return Boolean.TRUE.toString().equals(attribute);
    }

    public static nsIDOMElement getElementFromPoint(nsIDOMDocument document, int clientX, int clientY) {
        nsIDOMNSDocument nsDocument = (nsIDOMNSDocument)XPCOM.queryInterface((nsISupports)document, nsIDOMNSDocument.class);
        nsIDOMElement element = nsDocument.elementFromPoint(clientX, clientY);
        Stack<nsIDOMElement> hiddenElements = new Stack<nsIDOMElement>();
        Stack<String> hiddenElementsStyles = new Stack<String>();
        while (element != null && DndUtil.isTemporaryDndElement(element)) {
            hiddenElements.push(element);
            hiddenElementsStyles.push(element.getAttribute("style"));
            element.setAttribute("style", "display:none !important;");
            element = nsDocument.elementFromPoint(clientX, clientY);
        }
        while (!hiddenElements.empty()) {
            nsIDOMElement element2 = (nsIDOMElement)hiddenElements.pop();
            String style = (String)hiddenElementsStyles.pop();
            if (style == null) {
                element2.removeAttribute("style");
                continue;
            }
            element2.setAttribute("style", style);
        }
        return element;
    }

    public static Node getNodeFromDragSession(VpePageContext pageContext) {
        String xPath = DndUtil.getDragTransferDataAsString(VPE_XPATH_FLAVOR);
        if (xPath != null) {
            return SourceDomUtil.getNodeByXPath(pageContext.getSourceBuilder().getSourceDocument(), xPath);
        }
        return null;
    }

    public static class DragTransferData {
        private final String flavor;
        private final long dataLen;
        private final nsISupports value;

        public DragTransferData(String flavor, nsISupports value, long dataLen) {
            this.flavor = flavor;
            this.value = value;
            this.dataLen = dataLen;
        }

        public String getFlavor() {
            return this.flavor;
        }

        public nsISupports getValue() {
            return this.value;
        }

        public long getDataLen() {
            return this.dataLen;
        }
    }
}

