/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeVisualCaretInfo;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.template.VpePseudoContentCreator;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNSUIEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeSelectionBuilder {
    private static int HUGE_DISTANCE = 999999;
    private VpeDomMapping domMapping;
    private VpeSourceDomBuilder sourceBuilder;
    private VpeVisualDomBuilder visualBuilder;
    private VpeSelectionController visualSelectionController;

    VpeSelectionBuilder(VpeDomMapping domMapping, VpeSourceDomBuilder sourceBuilder, VpeVisualDomBuilder visualBuilder, VpeSelectionController visualSelectionController) {
        this.domMapping = domMapping;
        this.sourceBuilder = sourceBuilder;
        this.visualBuilder = visualBuilder;
        this.visualSelectionController = visualSelectionController;
        visualSelectionController.setSelectionFlags((short)7);
    }

    void setVisualSelection(Node sourceNode, int caretPosition) {
        this.setSelection(sourceNode, caretPosition, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSelection(nsISelection selection) {
        if (selection.getIsCollapsed()) {
            VisualSelectionInfo info = this.getVisualFocusSelectedInfo(selection);
            if (info == null) return;
            nsIDOMNode visualNode = info.node;
            Node node = this.domMapping.getSourceNode(visualNode);
            Node sourceNode = node == null ? this.domMapping.getNearSourceNode(visualNode) : node;
            nsIDOMNode visualSelectedNode = this.domMapping.getVisualNode(sourceNode);
            if (visualSelectedNode == null) {
                visualSelectedNode = visualNode;
            }
            if (VpeDebug.PRINT_VISUAL_SELECTION_EVENT) {
                System.out.println("      visualNode: " + visualSelectedNode.getNodeName() + "(" + visualSelectedNode + ")  sourceNode: " + (sourceNode == null ? null : sourceNode.getNodeName()) + "  node: " + node);
            }
            if (sourceNode == null) return;
            switch (visualSelectedNode.getNodeType()) {
                case 3: {
                    nsIDOMElement visualParentElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualSelectedNode.getParentNode(), nsIDOMElement.class);
                    this.visualBuilder.setSelectionRectangle((nsIDOMNode)visualParentElement, false);
                    int pos = selection.getFocusOffset();
                    try {
                        IndexedRegion region = (IndexedRegion)sourceNode;
                        String text = this.sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
                        pos = TextUtil.sourcePosition(text, visualSelectedNode.getNodeValue(), selection.getFocusOffset());
                    }
                    catch (BadLocationException ex) {
                        VpePlugin.reportProblem((Exception)((Object)ex));
                    }
                    this.sourceBuilder.setSelection(sourceNode, pos, 0);
                    return;
                }
                case 1: {
                    int offset;
                    VpeElementMapping element;
                    if (VpeVisualDomBuilder.isIncludeElement((nsIDOMElement)XPCOM.queryInterface((nsISupports)visualSelectedNode, nsIDOMElement.class))) {
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualSelectedNode, nsIDOMElement.class), false);
                        this.visualSelectionController.setCaretEnabled(false);
                        this.sourceBuilder.setSelection(sourceNode, 0, 0);
                        return;
                    }
                    if (sourceNode.getNodeType() == 8) {
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualSelectedNode, nsIDOMElement.class), false);
                        int pos = selection.getFocusOffset();
                        try {
                            IndexedRegion region = (IndexedRegion)sourceNode;
                            String text = this.sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
                            pos = TextUtil.sourcePosition(text, visualSelectedNode.getNodeValue(), selection.getFocusOffset());
                        }
                        catch (BadLocationException ex) {
                            VpePlugin.reportProblem((Exception)((Object)ex));
                        }
                        this.sourceBuilder.setSelection(sourceNode, pos, 0);
                        return;
                    }
                    if (this.visualBuilder.isContentArea(visualSelectedNode) && this.visualBuilder.isEmptyDocument()) {
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualSelectedNode, nsIDOMElement.class), false);
                        this.sourceBuilder.setSelectionAtDocumentEnd();
                        return;
                    }
                    nsIDOMNode containerForPseudoContent = VpePseudoContentCreator.getContainerForPseudoContent(visualNode);
                    if (containerForPseudoContent != null) {
                        sourceNode = this.domMapping.getNearSourceNode(containerForPseudoContent);
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)containerForPseudoContent, nsIDOMElement.class), false);
                        this.sourceBuilder.setSelection(sourceNode, 0, 0, true);
                        this.visualSelectionController.setCaretEnabled(false);
                        return;
                    }
                    boolean border = false;
                    if (this.domMapping.getNodeMapping(visualSelectedNode) instanceof VpeElementMapping && (element = (VpeElementMapping)this.domMapping.getNodeMapping(visualSelectedNode)).isBorder(visualNode)) {
                        info.startFlag = true;
                        border = true;
                    }
                    if (!border && visualNode.getNodeType() == 3 && node == null) {
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualSelectedNode, nsIDOMElement.class), false);
                        this.sourceBuilder.setAttributeSelection(visualNode, selection.getFocusOffset(), 0);
                        if (VpeVisualDomBuilder.isTextEditable(visualNode)) return;
                        this.visualSelectionController.setCaretEnabled(false);
                        return;
                    }
                    if (info.startFlag) {
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualSelectedNode, nsIDOMElement.class), false);
                    } else {
                        nsIDOMElement visualParentElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualSelectedNode.getParentNode(), nsIDOMElement.class);
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)visualParentElement, false);
                    }
                    int n = offset = info.startFlag ? 0 : ((IndexedRegion)sourceNode).getEndOffset() - ((IndexedRegion)sourceNode).getStartOffset();
                    if (info.startFlag && info.isPseudoElement()) {
                        this.sourceBuilder.setSelection(sourceNode, 0, 0, true);
                        return;
                    }
                    this.sourceBuilder.setSelection(sourceNode, offset, 0);
                }
                default: {
                    return;
                }
            }
        }
        nsIDOMRange range = selection.getRangeAt(0);
        nsIDOMNode visualAncestor = range.getCommonAncestorContainer();
        Node sourceAncestor = this.domMapping.getNearSourceNode(visualAncestor);
        nsIDOMNode visualSelectedAncestor = this.domMapping.getVisualNode(sourceAncestor);
        if (visualSelectedAncestor == null) {
            visualSelectedAncestor = visualAncestor;
        }
        boolean border = false;
        VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(visualSelectedAncestor);
        if (visualSelectedAncestor.getNodeType() == 1 && nodeMapping != null && nodeMapping instanceof VpeElementMapping && ((VpeElementMapping)nodeMapping).isBorder(visualAncestor)) {
            visualSelectedAncestor = ((VpeElementMapping)nodeMapping).getBorder();
            border = true;
        }
        if (sourceAncestor == null) return;
        switch (visualSelectedAncestor.getNodeType()) {
            case 3: {
                nsIDOMElement visualParentElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualSelectedAncestor.getParentNode(), nsIDOMElement.class);
                this.visualBuilder.setSelectionRectangle((nsIDOMNode)visualParentElement, false);
                int start = selection.getAnchorOffset();
                int end = selection.getFocusOffset();
                try {
                    IndexedRegion region = (IndexedRegion)sourceAncestor;
                    String text = this.sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
                    start = TextUtil.sourcePosition(text, visualSelectedAncestor.getNodeValue(), selection.getAnchorOffset());
                    end = TextUtil.sourcePosition(text, visualSelectedAncestor.getNodeValue(), selection.getFocusOffset());
                }
                catch (BadLocationException ex) {
                    VpePlugin.reportProblem((Exception)((Object)ex));
                }
                this.sourceBuilder.setSelection(sourceAncestor, start, end - start);
                return;
            }
            case 1: {
                if (sourceAncestor.getNodeType() == 8) {
                    this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualSelectedAncestor, nsIDOMElement.class), false);
                    int start = selection.getAnchorOffset();
                    int end = selection.getFocusOffset();
                    try {
                        IndexedRegion region = (IndexedRegion)sourceAncestor;
                        String text = this.sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
                        start = TextUtil.sourcePosition(text, sourceAncestor.getNodeValue(), selection.getAnchorOffset());
                        end = TextUtil.sourcePosition(text, sourceAncestor.getNodeValue(), selection.getFocusOffset());
                    }
                    catch (BadLocationException ex) {
                        VpePlugin.reportProblem((Exception)((Object)ex));
                    }
                    this.sourceBuilder.setSelection(sourceAncestor, start, end - start);
                    return;
                }
                nsIDOMNode visualAnchorNode = selection.getAnchorNode();
                int visualAnchorOffset = selection.getAnchorOffset();
                nsIDOMNode visualFocusNode = selection.getFocusNode();
                int visualFocusOffset = selection.getFocusOffset();
                if (visualFocusNode.equals(visualAnchorNode) && visualFocusOffset - visualAnchorOffset == 1 && visualFocusNode.getNodeType() == 1) {
                    VisualSelectionInfo info = this.getVisualSelectedInfo(visualAnchorNode, visualAnchorOffset);
                    if (info == null) return;
                    nsIDOMNode visualNode = info.node;
                    this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class), false);
                    Node sourceNode = this.domMapping.getNearSourceNode(visualNode);
                    int sourceStartOffset = ((IndexedRegion)sourceNode).getStartOffset();
                    int sourceEndOffset = ((IndexedRegion)sourceNode).getEndOffset();
                    this.sourceBuilder.setSelection(sourceNode, 0, sourceEndOffset - sourceStartOffset);
                    return;
                }
                this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualSelectedAncestor, nsIDOMElement.class), false);
                if (!border && visualAncestor.getNodeType() == 3) {
                    this.sourceBuilder.setAttributeSelection(visualAncestor, visualAnchorOffset, visualFocusOffset - visualAnchorOffset);
                    return;
                }
                int sourceAncestorOffset = ((IndexedRegion)sourceAncestor).getStartOffset();
                int sourceAnchorOffset = this.getSourceOffset(visualAnchorNode, visualAnchorOffset);
                int sourceFocusOffset = this.getSourceOffset(visualFocusNode, visualFocusOffset);
                this.sourceBuilder.setSelection(sourceAncestor, sourceAnchorOffset - sourceAncestorOffset, sourceFocusOffset - sourceAnchorOffset);
            }
        }
    }

    private int getSourceOffset(nsIDOMNode visualPrmNode, int visualPrmOffset) {
        nsIDOMNode visualNode;
        Node sourceNode;
        VisualSelectionInfo info = this.getVisualSelectedInfo(visualPrmNode, visualPrmOffset);
        if (info != null && (sourceNode = this.domMapping.getNearSourceNode(visualNode = info.node)) != null) {
            switch (sourceNode.getNodeType()) {
                case 3: {
                    try {
                        IndexedRegion region = (IndexedRegion)sourceNode;
                        int start = region.getStartOffset();
                        String sourceText = this.sourceBuilder.getStructuredTextViewer().getDocument().get(start, region.getEndOffset() - start);
                        if (visualPrmNode.getNodeType() == 3) {
                            return start + TextUtil.sourcePosition(sourceText, visualNode.getNodeValue(), visualPrmOffset);
                        }
                        if (info.startFlag) {
                            return start;
                        }
                        String visualValue = visualNode.getNodeValue();
                        return start + TextUtil.sourcePosition(sourceText, visualValue, visualValue.length());
                    }
                    catch (BadLocationException ex) {
                        VpePlugin.reportProblem((Exception)((Object)ex));
                        return 0;
                    }
                }
                case 1: {
                    return info.startFlag ? ((IndexedRegion)sourceNode).getStartOffset() : ((IndexedRegion)sourceNode).getEndOffset();
                }
                case 8: {
                    return ((IndexedRegion)sourceNode).getStartOffset() + visualPrmOffset + 4;
                }
            }
        }
        return 0;
    }

    void setClickSelection(nsIDOMNode visualNode) {
        Node sourceNode = this.domMapping.getNearSourceNode(visualNode);
        nsIDOMNode visualSelectedNode = this.domMapping.getVisualNode(sourceNode);
        if (visualSelectedNode == null) {
            visualSelectedNode = visualNode;
        }
        this.setVisualSelectionAtVisualNode(visualSelectedNode, 0);
        this.sourceBuilder.setSelection(sourceNode, 0, 0);
    }

    void _setClickContentAreaSelection() {
        Node sourceNode = this.sourceBuilder.getSelectedNode();
        if (sourceNode != null) {
            int caretPosition = this.sourceBuilder.getCaretPosition();
            this.setSelection(sourceNode, caretPosition, true);
        }
    }

    void setClickContentAreaSelection() {
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        this.setSelection(selection);
    }

    void setClickContentAreaSelection(nsIDOMMouseEvent mouseEvent) {
    }

    Node setContextMenuSelection(nsIDOMNode visualNode) {
        Node selectedText;
        if (VpeDebug.PRINT_VISUAL_CONTEXTMENU_EVENT) {
            System.out.println(">>>>>>>>>>>>>> onShowContextMenu  visualNode: " + visualNode.getNodeName() + "(" + visualNode + ")");
        }
        this.visualSelectionController.setCaretEnabled(false);
        nsIDOMNode visualParentNode = visualNode.getParentNode();
        if (visualParentNode.getNodeType() == 9) {
            visualNode = this.visualBuilder.getContentArea();
        }
        if ((selectedText = this.getSelectedTextOnly(visualNode)) != null) {
            return selectedText;
        }
        return this.setContextMenuElementSelection(visualNode);
    }

    private Node setContextMenuElementSelection(nsIDOMNode visualNode) {
        Node sourceNode = this.domMapping.getNearSourceNode(visualNode);
        nsIDOMNode visualSelectedNode = this.domMapping.getVisualNode(sourceNode);
        if (visualSelectedNode == null) {
            visualSelectedNode = visualNode;
        }
        this.setVisualSelectionAtVisualNode(visualSelectedNode, 0);
        if (sourceNode.getNodeType() != 3) {
            this.sourceBuilder.setSelection(sourceNode, 0, 0);
        } else if (sourceNode.getNodeType() == 3) {
            IndexedRegion region = (IndexedRegion)sourceNode;
            this.sourceBuilder.setSelection(sourceNode, 0, region.getLength());
        }
        return sourceNode;
    }

    private Node getSelectedTextOnly(nsIDOMNode element) {
        Node selectedText = null;
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        if (!selection.getIsCollapsed()) {
            nsIDOMNode anchorParent;
            nsIDOMNode anchorNode = selection.getAnchorNode();
            nsIDOMNode focusNode = selection.getFocusNode();
            if (anchorNode != null && anchorNode.getNodeType() == 3 && anchorNode.equals(focusNode) && (anchorParent = anchorNode.getParentNode()) != null && anchorParent.equals(element)) {
                selectedText = this.domMapping.getSourceNode(anchorNode);
            }
        }
        return selectedText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setVisualSelectionAtVisualNode(nsIDOMNode visualNode, int offset) {
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        if (visualNode != null) {
            switch (visualNode.getNodeType()) {
                case 3: {
                    if (offset > visualNode.getNodeValue().length()) {
                        offset = visualNode.getNodeValue().length();
                    }
                    selection.collapse(visualNode, offset);
                    nsIDOMElement visualParentElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode.getParentNode(), nsIDOMElement.class);
                    this.visualBuilder.setSelectionRectangle((nsIDOMNode)visualParentElement);
                    return;
                }
                case 1: {
                    Node node = this.domMapping.getSourceNode(visualNode);
                    if (node != null && node.getNodeType() == 8) {
                        nsIDOMNodeList visualNodes = visualNode.getChildNodes();
                        long len = visualNodes.getLength();
                        if (len <= 0L) return;
                        nsIDOMNode visualText = visualNodes.item(0L);
                        String text = visualText.getNodeValue();
                        if (offset > text.length()) {
                            offset = text.length();
                        }
                        selection.collapse(visualText, offset);
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class));
                        return;
                    }
                    if (offset == 0) {
                        offset = (int)VisualDomUtil.getOffset(visualNode);
                        nsIDOMNode visualParentNode = visualNode.getParentNode();
                        if (visualParentNode != null && visualParentNode.getNodeType() == 1) {
                            selection.collapse(visualParentNode, offset);
                            this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class));
                            return;
                        }
                        selection.removeAllRanges();
                        this.visualBuilder.setSelectionRectangle(null);
                        return;
                    }
                    if (offset == 1) {
                        nsIDOMNode appreciableVisualChild = VpeVisualDomBuilder.getLastAppreciableVisualChild(visualNode);
                        if (appreciableVisualChild != null) {
                            if (appreciableVisualChild.getNodeType() == 3) {
                                offset = appreciableVisualChild.getNodeValue().length();
                                selection.collapse(appreciableVisualChild, offset);
                                this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class));
                                return;
                            }
                            offset = (int)VisualDomUtil.getOffset(appreciableVisualChild) + 1;
                            selection.collapse(visualNode, offset);
                            this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class));
                            return;
                        }
                        offset = 0;
                        selection.collapse(visualNode, offset);
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class));
                        return;
                    }
                    offset = (int)VisualDomUtil.getOffset(visualNode);
                    nsIDOMNode visualParentNode = visualNode.getParentNode();
                    if (visualParentNode.getNodeType() == 1) {
                        selection.collapse(visualParentNode, offset);
                        this.visualBuilder.setSelectionRectangle((nsIDOMNode)XPCOM.queryInterface((nsISupports)visualParentNode, nsIDOMElement.class));
                        return;
                    }
                    selection.removeAllRanges();
                    this.visualBuilder.setSelectionRectangle(null);
                    return;
                }
                default: {
                    selection.removeAllRanges();
                    this.visualBuilder.setSelectionRectangle(null);
                    return;
                }
            }
        } else {
            selection.removeAllRanges();
            this.visualBuilder.setSelectionRectangle(null);
        }
    }

    private VisualSelectionInfo getVisualFocusSelectedInfo(nsISelection selection) {
        nsIDOMNode parent;
        nsIDOMNode focusNode = selection.getFocusNode();
        if (focusNode != null && focusNode.getNodeType() == 3 && (parent = focusNode.getParentNode()) == null) {
            return null;
        }
        VisualSelectionInfo info = this.getVisualSelectedInfo(focusNode, selection.getFocusOffset());
        return info;
    }

    private VisualSelectionInfo getVisualSelectedInfo(nsIDOMNode visualNode, int visualOffset) {
        if (visualNode != null) {
            switch (visualNode.getNodeType()) {
                case 3: {
                    return new VisualSelectionInfo(visualNode);
                }
                case 1: {
                    nsIDOMNode visualChild;
                    nsIDOMNodeList visualNodes = visualNode.getChildNodes();
                    boolean startFlag = true;
                    long len = visualNodes.getLength();
                    if ((long)visualOffset < len) {
                        nsIDOMNode visualPrevChild;
                        visualChild = visualNodes.item((long)visualOffset);
                        if (visualOffset > 0 && visualChild != null && visualChild.getNodeType() == 3 && (visualPrevChild = visualNodes.item((long)(visualOffset - 1))) != null && visualPrevChild.getNodeType() != 3) {
                            visualChild = visualPrevChild;
                            startFlag = false;
                        }
                    } else if (len > 0L) {
                        visualChild = visualNodes.item(len - 1L);
                        startFlag = false;
                    } else {
                        visualChild = visualNode;
                    }
                    return new VisualSelectionInfo(visualChild, startFlag);
                }
            }
        }
        return null;
    }

    private void setSelection(Node sourceNode, int caretPosition, boolean showCaret) {
        nsIDOMNode visualNode = this.domMapping.getNearVisualNode(sourceNode);
        int startOffset = ((IndexedRegion)sourceNode).getStartOffset();
        int endOffset = ((IndexedRegion)sourceNode).getEndOffset();
        if (caretPosition >= startOffset && caretPosition <= endOffset) {
            int offset = caretPosition - ((IndexedRegion)sourceNode).getStartOffset();
            if (sourceNode.getNodeType() == 3 && offset > sourceNode.getNodeValue().length()) {
                offset = sourceNode.getNodeValue().length();
            }
            if (!showCaret) {
                this.visualSelectionController.setCaretEnabled(false);
            }
            this.setVisualSelectionAtVisualNode(visualNode, offset);
        }
    }

    public void setVisualSelection(Node sourceAnchorNode, int sourceAnchorOffset, Node sourceFocusNode, int sourceFocusOffset, boolean reversionFlag, boolean showCaret) {
        this.setVisualSelection(sourceAnchorNode, sourceAnchorOffset, sourceFocusNode, sourceFocusOffset, reversionFlag, showCaret, false);
    }

    public void setVisualSelection(Node sourceAnchorNode, int sourceAnchorOffset, Node sourceFocusNode, int sourceFocusOffset, boolean reversionFlag, boolean showCaret, boolean into) {
        if (!showCaret) {
            this.visualSelectionController.setCaretEnabled(false);
        }
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        if (sourceAnchorNode == null || sourceFocusNode == null) {
            selection.removeAllRanges();
            this.visualBuilder.setSelectionRectangle(null);
        } else if (sourceAnchorNode == sourceFocusNode && sourceAnchorOffset == sourceFocusOffset) {
            nsIDOMNode visualNode = this.domMapping.getNearVisualNode(sourceAnchorNode);
            if (visualNode != null) {
                nsIDOMNode br;
                if (sourceAnchorNode.getNodeType() == 3) {
                    if (visualNode.getNodeType() != 3) {
                        sourceAnchorOffset = 1;
                    } else if (sourceAnchorOffset > sourceAnchorNode.getNodeValue().length()) {
                        sourceAnchorOffset = sourceAnchorNode.getNodeValue().length();
                    }
                }
                if (into && visualNode != null && visualNode.getChildNodes().getLength() == 1L && "br".equalsIgnoreCase((br = VisualDomUtil.getChildNode(visualNode, 0L)).getNodeName())) {
                    visualNode = VisualDomUtil.getChildNode(visualNode, 0L);
                    sourceAnchorOffset = 2;
                }
            } else if (sourceAnchorNode.getNodeType() == 2) {
                visualNode = this.visualBuilder.getOutputTextNode((Attr)sourceAnchorNode);
                if (visualNode != null) {
                    if (!VpeVisualDomBuilder.isTextEditable(visualNode)) {
                        sourceAnchorOffset = 0;
                    }
                } else {
                    visualNode = this.domMapping.getNearVisualNode(((Attr)sourceAnchorNode).getOwnerElement());
                    sourceAnchorOffset = 0;
                }
            }
            if (sourceAnchorNode instanceof CommentImpl) {
                sourceAnchorOffset = 0;
            }
            this.setVisualSelectionAtVisualNode(visualNode, sourceAnchorOffset);
        } else {
            VisualSelectionInfo focusInfo;
            VisualSelectionInfo anchorInfo;
            nsIDOMNode visualAnchorNode = null;
            nsIDOMNode visualFocusNode = null;
            boolean anchorStartFlag = false;
            boolean focusStartFlag = false;
            boolean anchorDirectFlag = true;
            boolean focusDirectFlag = true;
            if (!reversionFlag) {
                anchorInfo = this.getStartSelectionInfo(sourceAnchorNode, sourceAnchorOffset == 0);
                if (anchorInfo != null) {
                    visualAnchorNode = anchorInfo.node;
                    anchorStartFlag = anchorInfo.startFlag;
                    anchorDirectFlag = anchorInfo.directFlag;
                }
                if ((focusInfo = this.getEndSelectionInfo(sourceFocusNode, sourceFocusOffset == 0)) != null) {
                    visualFocusNode = focusInfo.node;
                    focusStartFlag = focusInfo.startFlag;
                    focusDirectFlag = focusInfo.directFlag;
                }
            } else {
                anchorInfo = this.getEndSelectionInfo(sourceAnchorNode, sourceAnchorOffset == 0);
                if (anchorInfo != null) {
                    visualAnchorNode = anchorInfo.node;
                    anchorStartFlag = anchorInfo.startFlag;
                    anchorDirectFlag = anchorInfo.directFlag;
                }
                if ((focusInfo = this.getStartSelectionInfo(sourceFocusNode, sourceFocusOffset == 0)) != null) {
                    visualFocusNode = focusInfo.node;
                    focusStartFlag = focusInfo.startFlag;
                    focusDirectFlag = focusInfo.directFlag;
                }
            }
            if (visualAnchorNode == null || visualFocusNode == null) {
                selection.removeAllRanges();
                this.visualBuilder.setSelectionRectangle(null);
                return;
            }
            nsIDOMNode visualAnchorContainer = null;
            long visualAnchorOffset = 0L;
            if (visualAnchorNode.getNodeType() == 3) {
                visualAnchorContainer = visualAnchorNode;
                if (anchorDirectFlag && sourceAnchorNode.getNodeType() == 3) {
                    visualAnchorOffset = sourceAnchorOffset > sourceAnchorNode.getNodeValue().length() ? (long)sourceAnchorNode.getNodeValue().length() : (long)sourceAnchorOffset;
                    if (visualAnchorOffset > (long)visualAnchorNode.getNodeValue().length()) {
                        visualAnchorOffset = visualAnchorNode.getNodeValue().length();
                    }
                } else {
                    visualAnchorOffset = anchorStartFlag ? 0L : (long)visualAnchorNode.getNodeValue().length();
                }
            } else if (sourceAnchorNode.getNodeType() == 8) {
                nsIDOMNodeList visualNodes = visualAnchorNode.getChildNodes();
                long len = visualNodes.getLength();
                if (len > 0L) {
                    visualAnchorContainer = visualNodes.item(0L);
                    String text = visualAnchorContainer.getNodeValue();
                    if (text != null && sourceAnchorOffset <= text.length()) {
                        visualAnchorOffset = sourceAnchorOffset;
                    } else if (text != null) {
                        visualAnchorOffset = text.length();
                    }
                }
            } else {
                visualAnchorContainer = visualAnchorNode.getParentNode();
                visualAnchorOffset = VisualDomUtil.getOffset(visualAnchorNode);
                if (!anchorStartFlag) {
                    ++visualAnchorOffset;
                }
            }
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println("setVisualSelection");
                System.out.println("                     visualAnchorNode: " + visualAnchorNode.getNodeName() + "(" + visualAnchorNode + ")  visualAnchorContainer: " + visualAnchorContainer.getNodeName() + "(" + visualAnchorContainer + ")  visualAnchorOffset: " + visualAnchorOffset + "  anchorStartFlag: " + anchorStartFlag);
            }
            nsIDOMNode visualFocusContainer = null;
            long visualFocusOffset = 0L;
            if (visualFocusNode.getNodeType() == 3) {
                visualFocusContainer = visualFocusNode;
                if (focusDirectFlag && sourceFocusNode.getNodeType() == 3) {
                    visualFocusOffset = sourceFocusOffset > sourceFocusNode.getNodeValue().length() ? (long)sourceFocusNode.getNodeValue().length() : (long)sourceFocusOffset;
                    if (visualFocusOffset > (long)visualFocusNode.getNodeValue().length()) {
                        visualFocusOffset = visualFocusNode.getNodeValue().length();
                    }
                } else {
                    visualFocusOffset = focusStartFlag ? 0L : (long)visualFocusNode.getNodeValue().length();
                }
            } else if (sourceFocusNode.getNodeType() == 8) {
                nsIDOMNodeList visualNodes = visualFocusNode.getChildNodes();
                long len = visualNodes.getLength();
                if (len > 0L) {
                    visualFocusContainer = visualNodes.item(0L);
                    String text = visualFocusContainer.getNodeValue();
                    if (text != null && sourceFocusOffset <= text.length()) {
                        visualFocusOffset = sourceFocusOffset;
                    } else if (text != null) {
                        visualFocusOffset = text.length();
                    }
                }
            } else {
                visualFocusContainer = visualFocusNode.getParentNode();
                visualFocusOffset = VisualDomUtil.getOffset(visualFocusNode);
                if (!focusStartFlag) {
                    ++visualFocusOffset;
                }
            }
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println("                     visualFocusNode: " + (visualFocusNode != null ? String.valueOf(visualFocusNode.getNodeName()) + "(" + visualFocusNode + ")" : null) + "  visualFocusContainer: " + (visualFocusContainer != null ? String.valueOf(visualFocusContainer.getNodeName()) + "(" + visualFocusContainer + ") visualFocusOffset: " + visualFocusOffset + "  focusStartFlag: " + focusStartFlag : null));
            }
            if (visualAnchorContainer == null || visualFocusContainer == null) {
                return;
            }
            if (visualAnchorContainer.equals(visualFocusContainer) && visualAnchorOffset == visualFocusOffset) {
                if (!reversionFlag) {
                    this.setVisualSelectionAtVisualNode(visualFocusNode, 0);
                } else {
                    this.setVisualSelectionAtVisualNode(visualAnchorNode, 0);
                }
            } else {
                selection.collapse(visualAnchorContainer, (int)visualAnchorOffset);
                selection.extend(visualFocusContainer, (int)visualFocusOffset);
                nsIDOMElement commonElement = this.getVisualCommonElement(visualAnchorNode, visualFocusNode);
                this.visualBuilder.setSelectionRectangle((nsIDOMNode)commonElement);
                if (!(commonElement == null || commonElement.equals(visualAnchorNode) || commonElement.equals(visualFocusNode) || commonElement.equals(visualAnchorContainer))) {
                    commonElement.equals(visualFocusContainer);
                }
            }
        }
    }

    private VisualSelectionInfo getStartSelectionInfo(Node sourceNode, boolean initialStartFlag) {
        boolean startFlag = initialStartFlag;
        nsIDOMNode visualNode = this.domMapping.getVisualNode(sourceNode);
        boolean directFlag = visualNode != null;
        while (sourceNode != null && visualNode == null) {
            Node sourcePrevNode = sourceNode.getPreviousSibling();
            if (sourcePrevNode != null) {
                sourceNode = sourcePrevNode;
                startFlag = false;
            } else {
                sourceNode = sourceNode.getParentNode();
                startFlag = true;
            }
            visualNode = this.domMapping.getVisualNode(sourceNode);
        }
        if (visualNode != null) {
            return new VisualSelectionInfo(visualNode, startFlag, directFlag);
        }
        return null;
    }

    private VisualSelectionInfo getEndSelectionInfo(Node sourceNode, boolean initialStartFlag) {
        boolean startFlag = initialStartFlag;
        nsIDOMNode visualNode = this.domMapping.getVisualNode(sourceNode);
        boolean directFlag = visualNode != null;
        while (sourceNode != null && visualNode == null) {
            Node sourceNextNode = sourceNode.getNextSibling();
            if (sourceNextNode != null) {
                sourceNode = sourceNextNode;
                startFlag = true;
            } else {
                sourceNode = sourceNode.getParentNode();
                startFlag = false;
            }
            visualNode = this.domMapping.getVisualNode(sourceNode);
        }
        if (visualNode != null) {
            return new VisualSelectionInfo(visualNode, startFlag, directFlag);
        }
        return null;
    }

    private nsIDOMElement getVisualCommonElement(nsIDOMNode nodeA, nsIDOMNode nodeB) {
        int len;
        nsIDOMNode[] nodesA = this.getVisualPath(nodeA);
        nsIDOMNode[] nodesB = this.getVisualPath(nodeB);
        int index = len = Math.min(nodesA.length, nodesB.length);
        int i = 0;
        while (i < len) {
            if (!nodesA[i].equals(nodesB[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            index = len;
        }
        if (index > 0) {
            nsIDOMNode commonNode = nodesA[index - 1];
            if (commonNode.getNodeType() == 3) {
                nsIDOMNode parent;
                commonNode = parent = commonNode.getParentNode();
            }
            return (nsIDOMElement)XPCOM.queryInterface((nsISupports)commonNode, nsIDOMElement.class);
        }
        return null;
    }

    private nsIDOMNode[] getVisualPath(nsIDOMNode node) {
        return this.getVisualPath(node, 0);
    }

    private nsIDOMNode[] getVisualPath(nsIDOMNode node, int height) {
        nsIDOMNode parent = node.getParentNode();
        nsIDOMNode[] path = parent != null ? this.getVisualPath(parent, height) : new nsIDOMNode[++height];
        path[path.length - height] = node;
        return path;
    }

    public VpeVisualCaretInfo getVisualCaretInfo(nsIDOMEvent event) {
        nsIDOMNSUIEvent nsuiEvent = (nsIDOMNSUIEvent)XPCOM.queryInterface((nsISupports)event, nsIDOMNSUIEvent.class);
        return new VpeVisualCaretInfo(this, nsuiEvent.getRangeParent(), nsuiEvent.getRangeOffset());
    }

    int getSourcePosition(nsIDOMNode visualInitNode, int visualInitOffset) {
        int position = 0;
        VisualSelectionInfo info = this.getVisualSelectedInfo(visualInitNode, visualInitOffset);
        if (info != null) {
            nsIDOMNode visualNode = info.node;
            Node sourceNode = this.domMapping.getNearSourceNode(visualNode);
            nsIDOMNode visualSelectedNode = this.domMapping.getVisualNode(sourceNode);
            if (visualSelectedNode == null) {
                visualSelectedNode = visualNode;
            }
            if (sourceNode != null) {
                switch (visualSelectedNode.getNodeType()) {
                    case 3: {
                        if (visualInitNode.getNodeType() != 3) {
                            visualInitOffset = info.startFlag ? 0 : visualSelectedNode.getNodeValue().length();
                        }
                        int ofset = visualInitOffset;
                        position = this.sourceBuilder.getPosition(sourceNode, ofset, false);
                        try {
                            IndexedRegion region = (IndexedRegion)sourceNode;
                            int start = region.getStartOffset();
                            String text = this.sourceBuilder.getStructuredTextViewer().getDocument().get(start, region.getEndOffset() - start);
                            position = start + TextUtil.sourcePosition(text, visualSelectedNode.getNodeValue(), visualInitOffset);
                        }
                        catch (BadLocationException ex) {
                            VpePlugin.reportProblem((Exception)((Object)ex));
                        }
                        break;
                    }
                    case 1: {
                        int offset = info.startFlag ? 0 : ((IndexedRegion)sourceNode).getEndOffset() - ((IndexedRegion)sourceNode).getStartOffset();
                        position = info.startFlag && info.isPseudoElement() ? this.sourceBuilder.getPosition(sourceNode, 0, true) : this.sourceBuilder.getPosition(sourceNode, offset, false);
                    }
                }
            }
        }
        return position;
    }

    private Point getSourceSelectionRangeAtVisualNode(nsIDOMNode visualInitNode, int visualInitOffset) {
        Point outputAttributesPositions;
        Node sourceNode;
        if (visualInitNode.getNodeType() == 3 && (sourceNode = this.domMapping.getSourceNode(visualInitNode)) == null && (sourceNode = this.domMapping.getNearSourceNode(visualInitNode)) != null && sourceNode.getNodeType() == 1 && (outputAttributesPositions = this.sourceBuilder.getOutputAttributesPositions((Element)sourceNode)) != null) {
            return new Point(outputAttributesPositions.x, outputAttributesPositions.y - outputAttributesPositions.x);
        }
        Point range = this.sourceBuilder.getSelectionRange();
        int pos = this.getSourcePosition(visualInitNode, visualInitOffset);
        if (pos >= range.x && pos <= range.x + range.y) {
            return range;
        }
        return new Point(pos, 0);
    }

    void setVisualElementSelection(nsIDOMMouseEvent mouseEvent) {
        nsIDOMNode visualNode;
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        if (selection.containsNode(visualNode = this.visualBuilder.getOriginalTargetNode((nsIDOMEvent)mouseEvent), false) || VpeVisualDomBuilder.isAnonElement(visualNode)) {
            return;
        }
        if (!selection.containsNode(visualNode, false) && visualNode.getNodeType() == 1 && !VpeVisualDomBuilder.isAnonElement(visualNode)) {
            nsIDOMNode visualParent = visualNode.getParentNode();
            long offset = VisualDomUtil.getOffset(visualNode);
            selection.removeAllRanges();
            selection.collapse(visualParent, (int)offset);
            selection.extend(visualParent, (int)offset + 1);
            this.setSelection(selection);
        }
    }

    nsIDOMElement getAppropriateElementForSelection(nsIDOMEvent event) {
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        nsIDOMNode visualNode = VisualDomUtil.getTargetNode(event);
        if (visualNode != null) {
            VpeElementMapping elementMapping;
            if (!"input".equalsIgnoreCase(visualNode.getNodeName())) {
                visualNode = this.visualBuilder.getOriginalTargetNode(event);
            }
            if (visualNode != null && visualNode.getNodeType() == 1 && !selection.containsNode(visualNode, false) && (elementMapping = this.domMapping.getNearElementMapping(visualNode)) != null) {
                return elementMapping.getVisualElement();
            }
        }
        return null;
    }

    void setVisualElementSelection(nsIDOMElement visualElement) {
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        visualElement.removeAttribute(XulRunnerEditor.VPE_INVISIBLE_ELEMENT);
        nsIDOMNode visualParent = visualElement.getParentNode();
        int offset = (int)VisualDomUtil.getOffset((nsIDOMNode)visualElement);
        selection.removeAllRanges();
        selection.collapse(visualParent, offset);
        selection.extend(visualParent, offset + 1);
        this.setSelection(selection);
    }

    void setMouseUpSelection(nsIDOMMouseEvent mouseEvent) {
    }

    void printVisualSelection() {
        nsIDOMNode focusNode;
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        boolean collapsed = selection.getIsCollapsed();
        System.out.println("  ## VisualSelection");
        System.out.println("  ## collapsed: " + collapsed);
        if (!collapsed) {
            nsIDOMNode anchorNode = selection.getAnchorNode();
            if (anchorNode != null) {
                System.out.println("  ## anchorNode: " + anchorNode.getNodeName() + " (" + anchorNode + ")  offset: " + selection.getAnchorOffset());
            } else {
                System.out.println("  ## anchorNode: null");
            }
        }
        if ((focusNode = selection.getFocusNode()) != null) {
            System.out.println("  ## focusNode: " + focusNode.getNodeName() + " (" + focusNode + ")  offset: " + selection.getFocusOffset());
        } else {
            System.out.println("  ## focusNode: null");
        }
    }

    void setVisualCaret(nsIDOMNode visualNode, int offset) {
        nsISelection selection = this.visualSelectionController.getSelection((short)1);
        if (visualNode != null) {
            if (visualNode.getNodeType() == 3 && offset > visualNode.getNodeValue().length()) {
                offset = visualNode.getNodeValue().length();
            }
            selection.collapse(visualNode, offset);
        } else {
            selection.removeAllRanges();
        }
        this.visualSelectionController.setCaretEnabled(true);
        this.setSelection(selection);
    }

    private static class VisualSelectionInfo {
        nsIDOMNode node;
        boolean startFlag;
        boolean directFlag;

        private VisualSelectionInfo(nsIDOMNode node) {
            this.node = node;
        }

        private VisualSelectionInfo(nsIDOMNode node, boolean startFlag) {
            this(node, startFlag, true);
        }

        private VisualSelectionInfo(nsIDOMNode node, boolean startFlag, boolean directFlag) {
            this(node);
            this.startFlag = startFlag;
            this.directFlag = directFlag;
        }

        private boolean isPseudoElement() {
            return VpeVisualDomBuilder.isPseudoElement(this.node);
        }
    }
}

