/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeDisposeException;
import org.jboss.tools.vpe.editor.VpeDomBuilder;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeSourceDropInfo;
import org.jboss.tools.vpe.editor.VpeSourceInnerDragInfo;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.proxy.VpeProxyUtil;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.VpeDefaultPseudoContentCreator;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.util.ElService;
import org.jboss.tools.vpe.editor.util.FaceletUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.jboss.tools.vpe.resref.core.CSSReferenceList;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMNSEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeVisualDomBuilder
extends VpeDomBuilder {
    public static final String VPE_USER_TOGGLE_ID = "vpe-user-toggle-id";
    public static final String VPE_USER_TOGGLE_LOOKUP_PARENT = "vpe-user-toggle-lookup-parent";
    public static final String VPE_FACET = "VPE-FACET";
    private static final String PSEUDO_ELEMENT_ATTR = "vpe:pseudo-element";
    private static final String MOZ_ANONCLASS_ATTR = "_MOZ_ANONCLASS";
    private static final String INCLUDE_ELEMENT_ATTR = "vpe:include-element";
    private static String DOTTED_BORDER = "border: 1px dotted #FF6600; padding: 5px;";
    private static final String CSS_STYLE_FOR_BORDER_FOR_UNKNOWN_TAGS = ";border: 1px solid green;";
    private MozillaEditor visualEditor;
    private XulRunnerEditor xulRunnerEditor;
    private VpePageContext pageContext;
    private List<VpeIncludeInfo> includeStack;
    private static final String ATTR_VPE = "vpe";
    private static final String ATTR_VPE_INLINE_LINK_VALUE = "inlinelink";
    private static final String ATTR_REL_STYLESHEET_VALUE = "stylesheet";
    private static final String YES_STRING = "yes";
    private static final String EMPTY_STRING = "";
    private static HashSet<String> unborderedSourceNodes = new HashSet();
    private static HashSet<String> unborderedVisualNodes;
    private Map<IStorage, Document> includeDocuments = new HashMap<IStorage, Document>();
    private boolean showInvisibleTags;
    private boolean showBorderForUnknownTags;

    static {
        unborderedSourceNodes.add("html");
        unborderedSourceNodes.add("head");
        unborderedSourceNodes.add("body");
        unborderedVisualNodes = new HashSet();
        unborderedVisualNodes.add("tbody");
        unborderedVisualNodes.add("thead");
        unborderedVisualNodes.add("tr");
        unborderedVisualNodes.add("td");
        unborderedVisualNodes.add("col");
        unborderedVisualNodes.add("cols");
        unborderedVisualNodes.add("colgroup");
        unborderedVisualNodes.add("li");
        unborderedVisualNodes.add("br");
    }

    public VpeVisualDomBuilder(VpeDomMapping domMapping, INodeAdapter sorceAdapter, MozillaEditor visualEditor, VpePageContext pageContext) {
        super(domMapping, sorceAdapter);
        this.visualEditor = visualEditor;
        this.xulRunnerEditor = visualEditor.getXulRunnerEditor();
        this.pageContext = pageContext;
        this.showInvisibleTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show non-visual tags");
        this.showBorderForUnknownTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Border for Unknown Tags");
    }

    public void buildDom(Document sourceDocument) {
        IFile file;
        nsIDOMNodeList children = this.getContentArea().getChildNodes();
        long len = children.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            this.getContentArea().removeChild(children.item(i));
            --i;
        }
        VpeSourceDomBuilder sourceBuilder = this.pageContext.getSourceBuilder();
        IDocument document = sourceBuilder.getStructuredTextViewer().getDocument();
        if (document == null) {
            return;
        }
        this.includeStack = new ArrayList<VpeIncludeInfo>();
        IEditorInput input = this.pageContext.getEditPart().getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            this.includeStack.add(new VpeIncludeInfo(null, (IStorage)file, this.pageContext.getSourceBuilder().getSourceDocument()));
        }
        this.pageContext.refreshConnector();
        this.refreshExternalLinks();
        Element root = FaceletUtil.findComponentElement(sourceDocument.getDocumentElement());
        if (root != null && FaceletUtil.isFacelet(root, XmlUtil.getTaglibsForNode(root, this.pageContext))) {
            this.addNode(root, null, (nsIDOMNode)this.getContentArea());
        } else {
            this.addChildren(null, sourceDocument, (nsIDOMNode)this.getContentArea());
        }
        this.registerNodes(new VpeNodeMapping(sourceDocument, (nsIDOMNode)this.getContentArea()));
    }

    public void rebuildDom(Document sourceDocument) {
        this.cleanHead();
        this.domMapping.clear((nsIDOMNode)this.getContentArea());
        super.dispose();
        this.pageContext.clearAll();
        this.pageContext.getBundle().refreshRegisteredBundles();
        if (sourceDocument != null) {
            this.buildDom(sourceDocument);
        }
    }

    private boolean addNode(Node sourceNode, nsIDOMNode visualNextNode, nsIDOMNode visualContainer) {
        block7: {
            try {
                nsIDOMNode visualNewNode = this.createNode(sourceNode, visualContainer);
                if (visualNewNode == null) break block7;
                nsIDOMElement element = null;
                try {
                    element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNewNode, nsIDOMElement.class);
                }
                catch (XPCOMException xPCOMException) {}
                if (element == null || !element.hasAttribute(VPE_FACET)) {
                    if (visualNextNode == null) {
                        visualContainer.appendChild(visualNewNode);
                    } else {
                        visualContainer.insertBefore(visualNewNode, visualNextNode);
                    }
                }
                return true;
            }
            catch (XPCOMException xpcomException) {
                VpePlugin.reportProblem((Exception)((Object)xpcomException));
            }
        }
        return false;
    }

    protected nsIDOMNode createNode(Node sourceNode, nsIDOMNode visualOldContainer) {
        boolean registerFlag = this.isCurrentMainDocument();
        if (this.visualEditor.getController().getSelectionManager() != null) {
            this.getPageContext().processDisplayEvents();
        }
        if (this.getPageContext().getSourceBuilder() == null || this.includeDocuments == null) {
            throw new VpeDisposeException();
        }
        if (sourceNode == null || sourceNode.getNodeType() != 3 && sourceNode.getNodeType() != 1 && sourceNode.getNodeType() != 8 && sourceNode.getNodeType() != 4) {
            return null;
        }
        HashSet ifDependencySet = new HashSet();
        this.pageContext.setCurrentVisualNode(visualOldContainer);
        VpeTemplate template = this.getTemplateManager().getTemplate(this.pageContext, sourceNode, ifDependencySet);
        VpeCreationData creationData = null;
        Node sourceNodeProxy = null;
        try {
            if (ElService.getInstance().isELNode(this.getPageContext(), sourceNode)) {
                sourceNodeProxy = VpeProxyUtil.createProxyForELExpressionNode(this.getPageContext(), sourceNode);
                try {
                    creationData = template.create(this.getPageContext(), sourceNodeProxy, this.getVisualDocument());
                }
                catch (ClassCastException ex) {
                    VpePlugin.reportProblem(ex);
                    sourceNodeProxy = null;
                    creationData = template.create(this.getPageContext(), sourceNode, this.getVisualDocument());
                }
            } else {
                creationData = template.create(this.getPageContext(), sourceNode, this.getVisualDocument());
            }
        }
        catch (XPCOMException ex) {
            VpePlugin.getPluginLog().logError((Throwable)ex);
            VpeTemplate defTemplate = this.getTemplateManager().getDefTemplate();
            creationData = defTemplate.create(this.getPageContext(), sourceNode, this.getVisualDocument());
        }
        this.getPageContext().setCurrentVisualNode(null);
        nsIDOMNode visualNewNode = creationData.getNode();
        if (sourceNode.getNodeType() == 1 && visualNewNode == null && this.isShowInvisibleTags()) {
            visualNewNode = this.createInvisbleElementLabel(sourceNode);
        }
        nsIDOMElement border = null;
        if (visualNewNode != null && visualNewNode.getNodeType() == 1) {
            nsIDOMElement visualNewElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNewNode, nsIDOMElement.class);
            if (visualNewElement != null && template.hasImaginaryBorder()) {
                visualNewElement.setAttribute("style", String.valueOf(visualNewElement.getAttribute("style")) + ";" + DOTTED_BORDER);
            }
            if (visualNewElement != null) {
                this.correctVisualAttribute(visualNewElement);
            }
            if (template.getType() == 4 && this.showBorderForUnknownTags) {
                String style = visualNewElement.getAttribute("style");
                style = String.valueOf(style) + CSS_STYLE_FOR_BORDER_FOR_UNKNOWN_TAGS;
                visualNewElement.setAttribute("style", style);
            }
            if (!this.isCurrentMainDocument() && visualNewElement != null) {
                this.setReadOnlyElement(visualNewElement);
            }
        }
        if (sourceNode instanceof Element && visualNewNode != null && visualNewNode.getNodeType() == 1) {
            this.setTooltip((Element)sourceNode, (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNewNode, nsIDOMElement.class));
        }
        if (registerFlag) {
            VpeElementData data = creationData.getElementData();
            if (sourceNodeProxy != null && data != null && data.getNodesData() != null && data.getNodesData().size() > 0) {
                for (NodeData nodeData : data.getNodesData()) {
                    if (nodeData.getSourceNode() == null) continue;
                    Node attr = null;
                    attr = sourceNode.getAttributes() != null ? sourceNode.getAttributes().getNamedItem(nodeData.getSourceNode().getNodeName()) : sourceNode;
                    nodeData.setSourceNode(attr);
                    nodeData.setEditable(false);
                }
            }
            VpeElementMapping elementMapping = new VpeElementMapping(sourceNode, visualNewNode, border, template, ifDependencySet, creationData.getData(), data);
            this.registerNodes(elementMapping);
        }
        if (template.hasChildren()) {
            List<VpeChildrenInfo> childrenInfoList = creationData.getChildrenInfoList();
            if (childrenInfoList == null) {
                this.addChildren(template, sourceNode, visualNewNode != null ? visualNewNode : visualOldContainer);
            } else {
                this.addChildren(template, sourceNode, visualOldContainer, childrenInfoList);
            }
        } else if (sourceNode.getNodeType() == 1 && visualNewNode != null && this.isShowInvisibleTags()) {
            nsIDOMElement span = this.getVisualDocument().createElement("span");
            span.appendChild(visualNewNode);
            this.addChildren(template, sourceNode, (nsIDOMNode)span);
            visualNewNode = span;
        }
        this.getPageContext().setCurrentVisualNode(visualOldContainer);
        template.validate(this.getPageContext(), sourceNode, this.getVisualDocument(), creationData);
        this.getPageContext().setCurrentVisualNode(null);
        if (border != null) {
            // empty if block
        }
        return visualNewNode;
    }

    protected void correctVisualAttribute(nsIDOMElement element) {
        String styleValue = element.getAttribute("style");
        String backgroundValue = element.getAttribute("background");
        if (styleValue != null) {
            styleValue = VpeStyleUtil.addFullPathIntoURLValue(styleValue, this.pageContext);
            element.setAttribute("style", styleValue);
        }
        if (backgroundValue != null) {
            backgroundValue = VpeStyleUtil.addFullPathIntoBackgroundValue(backgroundValue, this.pageContext.getEditPart().getEditorInput());
            element.setAttribute("background", backgroundValue);
        }
        if (element.hasAttribute("dir")) {
            element.removeAttribute("dir");
        }
    }

    protected void addChildren(VpeTemplate containerTemplate, Node sourceContainer, nsIDOMNode visualContainer) {
        NodeList sourceNodes = sourceContainer.getChildNodes();
        int len = sourceNodes.getLength();
        int childrenCount = 0;
        int i = 0;
        while (i < len) {
            Node sourceNode = sourceNodes.item(i);
            if (this.addNode(sourceNode, null, visualContainer)) {
                sourceNode.getNodeType();
                ++childrenCount;
            }
            ++i;
        }
        if (childrenCount == 0) {
            this.setPseudoContent(containerTemplate, sourceContainer, visualContainer);
        }
    }

    protected void addChildren(VpeTemplate containerTemplate, Node sourceContainer, nsIDOMNode visualOldContainer, List<?> childrenInfoList) {
        int i = 0;
        while (i < childrenInfoList.size()) {
            VpeChildrenInfo info = (VpeChildrenInfo)childrenInfoList.get(i);
            nsIDOMElement visualParent = info.getVisualParent();
            if (visualParent == null) {
                visualParent = visualOldContainer;
            }
            List<Node> sourceChildren = info.getSourceChildren();
            int childrenCount = 0;
            if (sourceChildren != null) {
                int j = 0;
                while (j < sourceChildren.size()) {
                    Node child = sourceChildren.get(j);
                    if (!this.isInvisibleNode(child) && this.addNode(child, null, (nsIDOMNode)visualParent)) {
                        ++childrenCount;
                    }
                    ++j;
                }
            }
            if (childrenCount == 0 && childrenInfoList.size() == 0) {
                this.setPseudoContent(containerTemplate, sourceContainer, (nsIDOMNode)visualParent);
            }
            ++i;
        }
    }

    private boolean isInvisibleNode(Node node) {
        HashSet ifDependencySet = new HashSet();
        VpeTemplate template = this.getTemplateManager().getTemplate(this.pageContext, node, ifDependencySet);
        return template.isInvisible();
    }

    public nsIDOMNode addStyleNodeToHead(String styleText) {
        nsIDOMElement newStyle = this.getVisualDocument().createElement("style");
        if (styleText != null) {
            nsIDOMText newText = this.getVisualDocument().createTextNode(styleText);
            newStyle.appendChild((nsIDOMNode)newText);
        }
        this.getHeadNode().appendChild((nsIDOMNode)newStyle);
        return newStyle;
    }

    public nsIDOMNode replaceStyleNodeToHead(nsIDOMNode oldStyleNode, String styleText) {
        nsIDOMElement newStyle = this.getVisualDocument().createElement("style");
        if (styleText != null) {
            nsIDOMText newText = this.getVisualDocument().createTextNode(styleText);
            newStyle.appendChild((nsIDOMNode)newText);
        }
        this.getHeadNode().replaceChild((nsIDOMNode)newStyle, oldStyleNode);
        return newStyle;
    }

    public void removeStyleNodeFromHead(nsIDOMNode oldStyleNode) {
        this.getHeadNode().removeChild(oldStyleNode);
    }

    void addExternalLinks() {
        IEditorInput input = this.pageContext.getEditPart().getEditorInput();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        ResourceReference[] l = null;
        if (file != null) {
            l = CSSReferenceList.getInstance().getAllResources(file);
        }
        if (l != null) {
            ResourceReference[] resourceReferenceArray = l;
            int n = l.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceReference item = resourceReferenceArray[n2];
                this.addLinkNodeToHead("file:///" + item.getLocation(), YES_STRING, false);
                ++n2;
            }
        }
    }

    void removeExternalLinks() {
        nsIDOMNodeList childs = this.getHeadNode().getChildNodes();
        long length = childs.getLength();
        long i = length - 1L;
        while (i >= 0L) {
            nsIDOMNode node = childs.item(i);
            if (node.getNodeType() == 1) {
                boolean isLink = false;
                boolean isStyle = false;
                isLink = "link".equalsIgnoreCase(node.getNodeName());
                if (isLink || (isStyle = "style".equalsIgnoreCase(node.getNodeName()))) {
                    nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
                    if ((isLink || isStyle && ATTR_VPE_INLINE_LINK_VALUE.equalsIgnoreCase(element.getAttribute(ATTR_VPE))) && YES_STRING.equalsIgnoreCase(element.getAttribute("ext"))) {
                        this.getHeadNode().removeChild(node);
                    }
                }
            }
            --i;
        }
    }

    void refreshExternalLinks() {
        this.removeExternalLinks();
        this.addExternalLinks();
    }

    public static boolean isPseudoElement(nsIDOMNode visualNode) {
        if (visualNode == null) {
            return false;
        }
        if (visualNode.getNodeType() != 1) {
            return false;
        }
        return YES_STRING.equalsIgnoreCase(((nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class)).getAttribute(PSEUDO_ELEMENT_ATTR));
    }

    private void setPseudoContent(VpeTemplate containerTemplate, Node sourceContainer, nsIDOMNode visualContainer) {
        if (containerTemplate != null) {
            containerTemplate.setPseudoContent(this.pageContext, sourceContainer, visualContainer, this.getVisualDocument());
        } else {
            try {
                VpeDefaultPseudoContentCreator.getInstance().setPseudoContent(this.pageContext, sourceContainer, visualContainer, this.getVisualDocument());
            }
            catch (VpeExpressionException ex) {
                VpeExpressionException exception = new VpeExpressionException("Error for source node" + sourceContainer.toString(), ex);
                VpePlugin.reportProblem(exception);
            }
        }
    }

    public boolean isEmptyElement(nsIDOMNode visualParent) {
        nsIDOMNodeList visualNodes = visualParent.getChildNodes();
        long len = visualNodes.getLength();
        return len == 0L || len == 1L && this.isEmptyText(visualNodes.item(0L));
    }

    public boolean isEmptyDocument() {
        nsIDOMNodeList visualNodes = this.getContentArea().getChildNodes();
        long len = visualNodes.getLength();
        return len == 0L || len == 1L && (this.isEmptyText(visualNodes.item(0L)) || VpeVisualDomBuilder.isPseudoElement(visualNodes.item(0L)));
    }

    private boolean isEmptyText(nsIDOMNode visualNode) {
        if (visualNode == null || visualNode.getNodeType() != 3) {
            return false;
        }
        return visualNode.getNodeValue().trim().length() == 0;
    }

    public void updateNode(Node sourceNode) {
        if (sourceNode == null) {
            return;
        }
        switch (sourceNode.getNodeType()) {
            case 9: {
                this.rebuildDom((Document)sourceNode);
                break;
            }
            default: {
                this.updateElement(this.getNodeForUpdate(sourceNode));
            }
        }
    }

    private Node getNodeForUpdate(Node sourceNode) {
        Node sourceTable = this.getParentTable(sourceNode, 2);
        if (sourceTable != null) {
            return sourceTable;
        }
        Node sourceSelect = this.getParentSelect(sourceNode);
        if (sourceSelect != null) {
            return sourceSelect;
        }
        return sourceNode;
    }

    private void updateElement(Node sourceNode) {
        VpeElementMapping elementMapping = null;
        VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(sourceNode);
        if (nodeMapping instanceof VpeElementMapping && (elementMapping = (VpeElementMapping)nodeMapping) != null && elementMapping.getTemplate() != null) {
            Node updateNode = elementMapping.getTemplate().getNodeForUpdate(this.pageContext, elementMapping.getSourceNode(), elementMapping.getVisualNode(), elementMapping.getData());
            if ("style".equalsIgnoreCase(sourceNode.getNodeName())) {
                VpeStyleUtil.refreshStyleElement(this, elementMapping);
                return;
            }
            if (updateNode != null && updateNode != sourceNode) {
                this.updateNode(updateNode);
                return;
            }
        }
        nsIDOMNode visualOldNode = this.domMapping.remove(sourceNode);
        this.getSourceNodes().remove(sourceNode);
        if (sourceNode instanceof INodeNotifier) {
            ((INodeNotifier)sourceNode).removeAdapter(this.getSorceAdapter());
        }
        if (visualOldNode != null) {
            nsIDOMElement border;
            if (elementMapping != null && (border = elementMapping.getBorder()) != null) {
                visualOldNode = border;
            }
            nsIDOMNode visualContainer = visualOldNode.getParentNode();
            nsIDOMNode visualNextNode = visualOldNode.getNextSibling();
            if (visualContainer != null) {
                this.addNode(sourceNode, visualNextNode, visualContainer);
                visualContainer.removeChild(visualOldNode);
            }
        } else if (sourceNode.getNodeType() == 3) {
            this.updateNode(sourceNode.getParentNode());
        } else if ("link".equalsIgnoreCase(sourceNode.getNodeName())) {
            this.addNode(sourceNode, null, this.getHeadNode());
        }
    }

    public void removeNode(Node sourceNode) {
        this.domMapping.remove(sourceNode);
        this.getSourceNodes().remove(sourceNode);
        if (sourceNode instanceof INodeNotifier) {
            ((INodeNotifier)sourceNode).removeAdapter(this.getSorceAdapter());
        }
    }

    private Node getParentTable(Node sourceNode, int depth) {
        Node parentNode = sourceNode.getParentNode();
        int i = 0;
        while (parentNode != null && i < depth) {
            if ("table".equalsIgnoreCase(parentNode.getNodeName())) {
                return parentNode;
            }
            parentNode = parentNode.getParentNode();
            ++i;
        }
        return null;
    }

    private Node getParentSelect(Node sourceNode) {
        Node parentNode;
        if ("option".equalsIgnoreCase(sourceNode.getNodeName()) && "select".equalsIgnoreCase((parentNode = sourceNode.getParentNode()).getNodeName())) {
            return parentNode;
        }
        return null;
    }

    public void setCdataText(Node sourceNode) {
        String sourceParentName;
        Node sourceParent = sourceNode.getParentNode();
        if (sourceParent != null && sourceParent.getLocalName() != null && "programlisting".equalsIgnoreCase(sourceParentName = sourceParent.getLocalName())) {
            this.updateNode(sourceParent);
        }
    }

    public boolean setText(Node sourceText) {
        String sourceParentName;
        Node sourceParent = sourceText.getParentNode();
        if (sourceParent != null && sourceParent.getLocalName() != null && ("textarea".equalsIgnoreCase(sourceParentName = sourceParent.getLocalName()) || "option".equalsIgnoreCase(sourceParentName) || "style".equalsIgnoreCase(sourceParentName))) {
            this.updateNode(sourceText.getParentNode());
            return true;
        }
        nsIDOMNode visualText = this.domMapping.getVisualNode(sourceText);
        if (visualText == null) {
            VpeTemplate template;
            VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(sourceParent);
            if (nodeMapping != null && nodeMapping instanceof VpeElementMapping && (template = ((VpeElementMapping)nodeMapping).getTemplate()) != null && !template.containsText()) {
                return false;
            }
            this.updateNode(sourceText);
            return true;
        }
        String visualValue = TextUtil.visualText(sourceText.getNodeValue());
        visualText.setNodeValue(visualValue);
        return false;
    }

    public void setAttribute(Element sourceElement, String name, String value) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null) {
            this.updateElement(sourceElement);
        }
    }

    public void stopToggle(Node sourceNode) {
        VpeTemplate template;
        if (!(sourceNode instanceof Element)) {
            return;
        }
        Element sourceElement = (Element)sourceNode;
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null && (template = elementMapping.getTemplate()) instanceof VpeToggableTemplate) {
            ((VpeToggableTemplate)((Object)template)).stopToggling(sourceElement);
        }
    }

    public Element doToggle(nsIDOMNode visualNode) {
        Node sourceNode;
        nsIDOMElement selectedElem;
        if (visualNode == null) {
            return null;
        }
        nsIDOMElement visualElement = null;
        try {
            visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        }
        catch (XPCOMException xPCOMException) {
            visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode.getParentNode(), nsIDOMElement.class);
        }
        if (visualElement == null) {
            return null;
        }
        nsIDOMAttr toggleIdAttr = visualElement.getAttributeNode(VPE_USER_TOGGLE_ID);
        if (toggleIdAttr == null) {
            return null;
        }
        String toggleId = toggleIdAttr.getNodeValue();
        if (toggleId == null) {
            return null;
        }
        boolean toggleLookup = false;
        nsIDOMAttr toggleLookupAttr = visualElement.getAttributeNode(VPE_USER_TOGGLE_LOOKUP_PARENT);
        if (toggleLookupAttr != null) {
            toggleLookup = "true".equals(toggleLookupAttr.getNodeValue());
        }
        if ((selectedElem = this.getLastSelectedElement()) == null) {
            return null;
        }
        VpeElementMapping elementMapping = null;
        VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping((nsIDOMNode)selectedElem);
        if (nodeMapping instanceof VpeElementMapping) {
            elementMapping = (VpeElementMapping)nodeMapping;
        }
        if (elementMapping == null) {
            while (!selectedElem.getNodeName().equals("table")) {
                selectedElem = (nsIDOMElement)XPCOM.queryInterface((nsISupports)selectedElem.getParentNode(), nsIDOMElement.class);
            }
            nodeMapping = this.domMapping.getNodeMapping((nsIDOMNode)selectedElem);
            if (nodeMapping instanceof VpeElementMapping) {
                elementMapping = (VpeElementMapping)nodeMapping;
            }
        }
        if ((sourceNode = this.domMapping.getSourceNode((nsIDOMNode)selectedElem)) == null) {
            return null;
        }
        Element sourceElement = (Element)(sourceNode instanceof Element ? sourceNode : sourceNode.getParentNode());
        toggleLookupAttr = selectedElem.getAttributeNode(VPE_USER_TOGGLE_LOOKUP_PARENT);
        if (toggleLookupAttr != null) {
            toggleLookup = "true".equals(toggleLookupAttr.getNodeValue());
        }
        if (elementMapping != null) {
            VpeTemplate template = elementMapping.getTemplate();
            while (toggleLookup && sourceElement != null && !(template instanceof VpeToggableTemplate)) {
                if ((sourceElement = (Element)sourceElement.getParentNode()) == null) break;
                nodeMapping = this.domMapping.getNodeMapping(sourceElement);
                if (nodeMapping instanceof VpeElementMapping) {
                    elementMapping = (VpeElementMapping)nodeMapping;
                }
                if (elementMapping == null) continue;
                template = elementMapping.getTemplate();
            }
            if (template instanceof VpeToggableTemplate) {
                ((VpeToggableTemplate)((Object)template)).toggle(this, sourceElement, toggleId);
                this.updateElement(sourceElement);
                return sourceElement;
            }
        }
        return null;
    }

    public void removeAttribute(Element sourceElement, String name) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null) {
            this.updateElement(sourceElement);
        }
    }

    public void refreshBundleValues(Element sourceElement) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null) {
            VpeTemplate template = elementMapping.getTemplate();
            template.refreshBundleValues(this.pageContext, sourceElement, elementMapping.getData());
        }
    }

    boolean isContentArea(nsIDOMNode visualNode) {
        return this.getContentArea().equals(visualNode);
    }

    public nsIDOMElement getContentArea() {
        return this.visualEditor.getContentArea();
    }

    public void setSelectionRectangle(nsIDOMNode visualElement) {
        this.setSelectionRectangle(visualElement, true);
    }

    void setSelectionRectangle(nsIDOMNode visualElement, boolean scroll) {
        int resizerConstrains = this.getResizerConstrains(visualElement);
        this.visualEditor.setSelectionRectangle(visualElement, resizerConstrains, scroll);
    }

    public nsIDOMNode addLinkNodeToHead(String href_val, String ext_val, boolean firstElement) {
        nsIDOMElement newNode = this.createLinkNode(href_val, ATTR_REL_STYLESHEET_VALUE, ext_val);
        if (firstElement) {
            nsIDOMNode firstNode = this.getHeadNode().getFirstChild();
            this.getHeadNode().insertBefore((nsIDOMNode)newNode, firstNode);
        } else {
            this.getHeadNode().appendChild((nsIDOMNode)newNode);
        }
        return newNode;
    }

    public nsIDOMNode replaceLinkNodeToHead(nsIDOMNode oldNode, String href_val, String ext_val) {
        nsIDOMElement newNode = this.createLinkNode(href_val, ATTR_REL_STYLESHEET_VALUE, ext_val);
        this.getHeadNode().replaceChild((nsIDOMNode)newNode, oldNode);
        return newNode;
    }

    public nsIDOMNode replaceLinkNodeToHead(String href_val, String ext_val, boolean firstElement) {
        nsIDOMNode newNode = null;
        nsIDOMNode oldNode = this.getLinkNode(href_val, ext_val);
        if (oldNode == null) {
            newNode = this.addLinkNodeToHead(href_val, ext_val, firstElement);
        }
        return newNode;
    }

    public void removeLinkNodeFromHead(nsIDOMNode node) {
        this.getHeadNode().removeChild(node);
    }

    private nsIDOMElement createLinkNode(String href_val, String rel_val, String ext_val) {
        nsIDOMElement linkNode = null;
        if (ATTR_REL_STYLESHEET_VALUE.equalsIgnoreCase(rel_val) && href_val.startsWith("file:")) {
            linkNode = this.getVisualDocument().createElement("style");
            linkNode.setAttribute(ATTR_VPE, ATTR_VPE_INLINE_LINK_VALUE);
            linkNode.setAttribute("href", href_val);
            linkNode.setAttribute("ext", ext_val);
            BufferedReader in = null;
            try {
                StringBuffer styleText = new StringBuffer(EMPTY_STRING);
                URL url = new URL(new Path(href_val).toOSString());
                String fileName = url.getFile();
                in = new BufferedReader(new FileReader(fileName));
                String str = EMPTY_STRING;
                while ((str = in.readLine()) != null) {
                    styleText.append(str);
                }
                String styleForParse = styleText.toString();
                styleForParse = VpeStyleUtil.addFullPathIntoURLValue(styleForParse, href_val);
                in.close();
                nsIDOMText textNode = this.getVisualDocument().createTextNode(styleForParse);
                linkNode.appendChild((nsIDOMNode)textNode);
                nsIDOMElement nsIDOMElement2 = linkNode;
                return nsIDOMElement2;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ioe) {
                VpePlugin.getPluginLog().logError(ioe.getMessage(), (Throwable)ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        VpePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            }
        }
        linkNode = this.getVisualDocument().createElement("link");
        linkNode.setAttribute("rel", rel_val);
        linkNode.setAttribute("href", href_val);
        linkNode.setAttribute("ext", ext_val);
        return linkNode;
    }

    private boolean isLinkReplacer(nsIDOMNode node) {
        return "style".equalsIgnoreCase(node.getNodeName()) && ATTR_VPE_INLINE_LINK_VALUE.equalsIgnoreCase(((nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class)).getAttribute(ATTR_VPE));
    }

    private nsIDOMNode getLinkNode(String href_val, String ext_val) {
        nsIDOMNodeList children = this.getHeadNode().getChildNodes();
        long len = children.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            nsIDOMElement element;
            nsIDOMNode node = children.item(i);
            if (node.getNodeType() == 1 && ("link".equalsIgnoreCase(node.getNodeName()) || this.isLinkReplacer(node)) && ext_val.equalsIgnoreCase((element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class)).getAttribute("ext")) && href_val.equalsIgnoreCase(element.getAttribute("href"))) {
                return node;
            }
            --i;
        }
        return null;
    }

    private void cleanHead() {
        if (this.getHeadNode() == null) {
            return;
        }
        nsIDOMNodeList children = this.getHeadNode().getChildNodes();
        long len = children.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            nsIDOMNode node = children.item(i);
            if (node.getNodeType() == 1) {
                if (this.isLinkReplacer(node)) {
                    if (!YES_STRING.equalsIgnoreCase(((nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class)).getAttribute("ext"))) {
                        node = this.getHeadNode().removeChild(node);
                    }
                } else if ("style".equalsIgnoreCase(node.getNodeName()) && !YES_STRING.equalsIgnoreCase(((nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class)).getAttribute(ATTR_VPE))) {
                    node = this.getHeadNode().removeChild(node);
                }
            }
            --i;
        }
    }

    private int getResizerConstrains(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(visualNode);
        if (nodeMapping != null && nodeMapping instanceof VpeElementMapping && nodeMapping.getSourceNode() instanceof Element && nodeMapping.getVisualNode().getNodeType() == 1) {
            return ((VpeElementMapping)nodeMapping).getTemplate().getTagDescription(this.pageContext, (Element)nodeMapping.getSourceNode(), this.getVisualDocument(), (nsIDOMElement)XPCOM.queryInterface((nsISupports)nodeMapping.getVisualNode(), nsIDOMElement.class), ((VpeElementMapping)nodeMapping).getData()).getResizeConstrains();
        }
        return 0;
    }

    public void resize(nsIDOMElement element, int constrains, int top, int left, int width, int height) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping((nsIDOMNode)element);
        if (elementMapping != null) {
            elementMapping.getTemplate().resize(this.pageContext, (Element)elementMapping.getSourceNode(), this.getVisualDocument(), element, elementMapping.getData(), constrains, top, left, width, height);
        }
    }

    public static boolean isAnonElement(nsIDOMNode visualNode) {
        if (visualNode != null && visualNode.getNodeType() == 1) {
            String attrValue = ((nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class)).getAttribute(MOZ_ANONCLASS_ATTR);
            return attrValue != null && attrValue.length() > 0;
        }
        return false;
    }

    public void innerDrop(Node dragNode, Node container, int offset) {
        VpeNodeMapping mapping = this.domMapping.getNearNodeMapping(container);
        if (mapping != null) {
            nsIDOMNode visualDropContainer = mapping.getVisualNode();
            nsIDOMNode visualParent = visualDropContainer.getParentNode();
            VpeNodeMapping oldMapping = mapping;
            mapping = this.domMapping.getNearNodeMapping(visualParent);
            if (mapping != null && mapping instanceof VpeElementMapping) {
                ((VpeElementMapping)mapping).getTemplate().innerDrop(this.pageContext, new VpeSourceInnerDragInfo(dragNode, 0, 0), new VpeSourceDropInfo(container, offset, true));
            } else if (oldMapping instanceof VpeElementMapping) {
                ((VpeElementMapping)oldMapping).getTemplate().innerDrop(this.pageContext, new VpeSourceInnerDragInfo(dragNode, 0, 0), new VpeSourceDropInfo(container, offset, true));
            }
        }
    }

    public static boolean isTextEditable(nsIDOMNode visualNode) {
        nsIDOMNode parent;
        if (visualNode != null && (parent = visualNode.getParentNode()) != null && parent.getNodeType() == 1) {
            String classValue;
            nsIDOMAttr classAttr;
            nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)parent, nsIDOMElement.class);
            nsIDOMAttr style = element.getAttributeNode("style");
            if (style != null) {
                String styleValue = style.getNodeValue();
                String[] items = styleValue.split(";");
                int i = 0;
                while (i < items.length) {
                    String[] item = items[i].split(":");
                    if ("-moz-user-modify".equals(item[0].trim()) && "read-only".equals(item[1].trim())) {
                        return false;
                    }
                    ++i;
                }
            }
            if ((classAttr = element.getAttributeNode("class")) != null && "__any__tag__caption".equals(classValue = classAttr.getNodeValue().trim())) {
                return false;
            }
        }
        return true;
    }

    protected void setTooltip(Element sourceElement, nsIDOMElement visualElement) {
        if (visualElement != null && sourceElement != null && !((IDOMElement)sourceElement).isJSPTag()) {
            if ("html".equalsIgnoreCase(sourceElement.getNodeName())) {
                return;
            }
            String titleValue = this.getTooltip(sourceElement);
            if (titleValue != null) {
                titleValue = titleValue.replaceAll("&", "&amp;");
                titleValue = titleValue.replaceAll("<", "&lt;");
                titleValue = titleValue.replaceAll(">", "&gt;");
            }
            if (titleValue != null) {
                this.setTooltip(visualElement, titleValue);
            }
        }
    }

    protected void setTooltip(nsIDOMElement visualElement, String titleValue) {
        visualElement.setAttribute("title", titleValue);
        nsIDOMNodeList children = visualElement.getChildNodes();
        long len = children.getLength();
        long i = 0L;
        while (i < len) {
            nsIDOMNode child = children.item(i);
            if (child.getNodeType() == 1) {
                this.setTooltip((nsIDOMElement)XPCOM.queryInterface((nsISupports)child, nsIDOMElement.class), titleValue);
            }
            ++i;
        }
    }

    private String getTooltip(Element sourceElement) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(sourceElement.getNodeName());
        NamedNodeMap attrs = sourceElement.getAttributes();
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            if (i == 7) {
                return buffer.append("\n\t... ").toString();
            }
            int valueLength = attrs.item(i).getNodeValue().length();
            if (valueLength > 30) {
                StringBuffer temp = new StringBuffer();
                temp.append(String.valueOf(attrs.item(i).getNodeValue().substring(0, 15)) + " ... " + attrs.item(i).getNodeValue().substring(valueLength - 15, valueLength));
                buffer.append("\n" + attrs.item(i).getNodeName() + ": " + temp);
            } else {
                buffer.append("\n" + attrs.item(i).getNodeName() + ": " + attrs.item(i).getNodeValue());
            }
            ++i;
        }
        return buffer.toString();
    }

    public static nsIDOMNode getLastAppreciableVisualChild(nsIDOMNode visualParent) {
        nsIDOMNode visualLastChild = null;
        nsIDOMNodeList visualChildren = visualParent.getChildNodes();
        long len = visualChildren.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            nsIDOMNode visualChild = visualChildren.item(i);
            if (!VpeVisualDomBuilder.isPseudoElement(visualChild) && !VpeVisualDomBuilder.isAnonElement(visualChild)) {
                visualLastChild = visualChild;
                break;
            }
            --i;
        }
        return visualLastChild;
    }

    public static boolean isIncludeElement(nsIDOMElement visualElement) {
        return YES_STRING.equalsIgnoreCase(visualElement.getAttribute(INCLUDE_ELEMENT_ATTR));
    }

    public static void markIncludeElement(nsIDOMElement visualElement) {
        visualElement.setAttribute(INCLUDE_ELEMENT_ATTR, YES_STRING);
    }

    protected void setReadOnlyElement(nsIDOMElement node) {
        String style = node.getAttribute("style");
        style = VpeStyleUtil.setParameterInStyle(style, "-moz-user-modify", "read-only");
        node.setAttribute("style", style);
    }

    public nsIDOMNode getOriginalTargetNode(nsIDOMEvent event) {
        nsIDOMNode targetNode = VisualDomUtil.getTargetNode(event);
        if ("input".equalsIgnoreCase(targetNode.getNodeName())) {
            return targetNode;
        }
        nsIDOMNSEvent nsEvent = (nsIDOMNSEvent)XPCOM.queryInterface((nsISupports)event, nsIDOMNSEvent.class);
        nsIDOMEventTarget target = nsEvent.getOriginalTarget();
        nsIDOMNode originalNode = (nsIDOMNode)XPCOM.queryInterface((nsISupports)target, nsIDOMNode.class);
        if (VpeVisualDomBuilder.isAnonElement(originalNode)) {
            originalNode = this.getLastSelectedElement();
        }
        return originalNode;
    }

    public nsIDOMText getOutputTextNode(Attr attr) {
        Element sourceElement = attr.getOwnerElement();
        VpeElementMapping elementMapping = this.domMapping.getNearElementMapping(sourceElement);
        if (elementMapping != null) {
            return elementMapping.getTemplate().getOutputTextNode(this.pageContext, sourceElement, elementMapping.getData());
        }
        return null;
    }

    nsIDOMElement getLastSelectedElement() {
        return this.xulRunnerEditor.getLastSelectedElement();
    }

    public void pushIncludeStack(VpeIncludeInfo includeInfo) {
        this.includeStack.add(includeInfo);
    }

    public VpeIncludeInfo popIncludeStack() {
        VpeIncludeInfo includeInfo = null;
        if (this.includeStack.size() > 0) {
            includeInfo = this.includeStack.remove(this.includeStack.size() - 1);
        }
        return includeInfo;
    }

    public boolean isFileInIncludeStack(IStorage file) {
        if (file == null) {
            return false;
        }
        int i = 0;
        while (i < this.includeStack.size()) {
            if (file.equals(this.includeStack.get(i).getStorage())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isCurrentMainDocument() {
        return this.includeStack.size() <= 1;
    }

    public VpeIncludeInfo getCurrentIncludeInfo() {
        if (this.includeStack.size() <= 0) {
            return null;
        }
        return this.includeStack.get(this.includeStack.size() - 1);
    }

    @Override
    public void dispose() {
        this.clearIncludeDocuments();
        this.includeDocuments = null;
        this.cleanHead();
        this.domMapping.clear((nsIDOMNode)this.getContentArea());
        this.pageContext.dispose();
        super.dispose();
    }

    private void clearIncludeDocuments() {
        Collection<Document> documents = this.includeDocuments.values();
        for (Document document : documents) {
            VpeCreatorUtil.releaseDocumentFromRead(document);
        }
        this.includeDocuments.clear();
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected nsIDOMDocument getVisualDocument() {
        return this.visualEditor.getDomDocument();
    }

    public XulRunnerEditor getXulRunnerEditor() {
        return this.xulRunnerEditor;
    }

    public Map<IStorage, Document> getIncludeDocuments() {
        return this.includeDocuments;
    }

    public nsIDOMNode getHeadNode() {
        return this.visualEditor.getHeadNode();
    }

    public boolean isShowInvisibleTags() {
        return this.showInvisibleTags;
    }

    public void setShowInvisibleTags(boolean showInvisibleTags) {
        this.showInvisibleTags = showInvisibleTags;
    }

    public boolean isShowBorderForUnknownTags() {
        return this.showBorderForUnknownTags;
    }

    public void setShowBorderForUnknownTags(boolean showBorderForUnknownTags) {
        this.showBorderForUnknownTags = showBorderForUnknownTags;
    }

    public nsIDOMNode createInvisbleElementLabel(Node sourceNode) {
        nsIDOMElement span = this.getVisualDocument().createElement("span");
        span.setAttribute("style", "border: 1px dashed GREY; color: GREY; font-size: 12px;");
        nsIDOMText text = this.getVisualDocument().createTextNode(sourceNode.getNodeName());
        span.appendChild((nsIDOMNode)text);
        return span;
    }
}

