/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mapping;

import java.util.Set;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeElementMapping
extends VpeNodeMapping {
    private VpeTemplate template;
    private Set ifDependencySet;
    private Object data;
    private VpeElementData elementData;
    private nsIDOMElement border;

    public VpeElementMapping(Node sourceElement, nsIDOMNode visualNode, nsIDOMElement border, VpeTemplate template, Set ifDependencySet, Object data, VpeElementData elementData) {
        super(sourceElement, visualNode);
        this.template = template;
        if (ifDependencySet != null && ifDependencySet.size() > 0) {
            this.ifDependencySet = ifDependencySet;
        }
        this.data = data;
        this.elementData = elementData;
        this.border = border;
    }

    public VpeElementMapping(Element sourceElement, nsIDOMElement visualElement, nsIDOMElement border, VpeTemplate template, Set ifDependencySet, VpeElementData elementData) {
        super(sourceElement, (nsIDOMNode)visualElement);
        this.template = template;
        if (ifDependencySet != null && ifDependencySet.size() > 0) {
            this.ifDependencySet = ifDependencySet;
        }
        this.elementData = elementData;
        this.border = border;
    }

    public nsIDOMElement getVisualElement() {
        return (nsIDOMElement)this.getVisualNode();
    }

    public VpeTemplate getTemplate() {
        return this.template;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isIfDependencyFromAttribute(String attrName) {
        if (this.ifDependencySet == null) {
            return false;
        }
        String signature = VpeExpressionBuilder.attrSignature(attrName, this.template.isCaseSensitive());
        if (this.ifDependencySet.contains(signature)) {
            return true;
        }
        return this.ifDependencySet.contains("@*");
    }

    public nsIDOMElement getBorder() {
        return this.border;
    }

    public boolean isBorder(nsIDOMNode border) {
        if (this.border == null) {
            return false;
        }
        if (this.border.equals(border)) {
            return true;
        }
        nsIDOMNode element = border;
        do {
            if (this.border.equals(element)) {
                return true;
            }
            if (!this.getVisualNode().equals(element)) continue;
            return false;
        } while ((element = element.getParentNode()) != null);
        return false;
    }

    public VpeElementData getElementData() {
        return this.elementData;
    }

    public void setElementData(VpeElementData elementData) {
        this.elementData = elementData;
    }
}

