/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeDataTableElements {
    public static nsIDOMElement getNamedChild(nsIDOMNode visualParent, String tagName) {
        return VpeDataTableElements.getNamedChild(visualParent, tagName, 0);
    }

    public static nsIDOMElement getNamedChild(nsIDOMNode visualParent, String tagName, int index) {
        if (visualParent != null) {
            int ind = 0;
            nsIDOMNodeList children = visualParent.getChildNodes();
            long count = children != null ? children.getLength() : 0L;
            long i = 0L;
            while (i < count) {
                nsIDOMNode child = children.item(i);
                if (tagName.equalsIgnoreCase(child.getNodeName())) {
                    if (ind == index) {
                        return (nsIDOMElement)XPCOM.queryInterface((nsISupports)child, nsIDOMElement.class);
                    }
                    ++ind;
                }
                ++i;
            }
        }
        return null;
    }

    public static VisualDataTableElements getVisualDataTableElements(nsIDOMNode visualParent) {
        VisualDataTableElements visualDataTableElements = new VisualDataTableElements(VpeDataTableElements.getNamedChild(visualParent, "caption"), VpeDataTableElements.getNamedChild(visualParent, "thead"), VpeDataTableElements.getNamedChild(visualParent, "tfoot"), VpeDataTableElements.getNamedChild(visualParent, "thead"), VpeDataTableElements.getNamedChild(visualParent, "tbody"), VpeDataTableElements.getNamedChild(visualParent, "tfoot"));
        visualDataTableElements.setCaption(VpeDataTableElements.getNamedChild((nsIDOMNode)visualDataTableElements.getCaption(), "caption"));
        visualDataTableElements.setTableHeaderRow(VpeDataTableElements.getNamedChild((nsIDOMNode)visualDataTableElements.getTableHeader(), "tr"));
        visualDataTableElements.setColumnsHeaderRow(VpeDataTableElements.getNamedChild((nsIDOMNode)visualDataTableElements.getColumnsHeader(), "tr"));
        visualDataTableElements.setBodyRow(VpeDataTableElements.getNamedChild((nsIDOMNode)visualDataTableElements.getBody(), "tr"));
        visualDataTableElements.setColumnsFooterRow(VpeDataTableElements.getNamedChild((nsIDOMNode)visualDataTableElements.getColumnsFooter(), "tr"));
        visualDataTableElements.setTableFooterRow(VpeDataTableElements.getNamedChild((nsIDOMNode)visualDataTableElements.getTableFooter(), "tr"));
        return visualDataTableElements;
    }

    public static nsIDOMElement makeCell(nsIDOMNode row, int index, String cellTag, nsIDOMDocument visualDocument) {
        nsIDOMElement visualCell = null;
        if (visualDocument != null && row != null) {
            visualCell = visualDocument.createElement(cellTag);
            if ((long)index >= row.getChildNodes().getLength()) {
                row.appendChild((nsIDOMNode)visualCell);
            } else {
                row.insertBefore((nsIDOMNode)visualCell, row.getChildNodes().item((long)index));
            }
        }
        return visualCell;
    }

    public static class SourceColumnElements {
        private Node column;
        private Node header;
        private List<Node> body;
        private Node footer;

        public SourceColumnElements(Node columnNode) {
            this.init(columnNode);
        }

        private void init(Node columnNode) {
            int cnt;
            this.column = columnNode;
            NodeList list = columnNode.getChildNodes();
            int n = cnt = list != null ? list.getLength() : 0;
            if (cnt > 0) {
                Node text;
                int i = 0;
                while (i < cnt) {
                    Node node = list.item(i);
                    if (node.getNodeType() == 1) {
                        boolean isFacet = node.getNodeName().indexOf(":facet") > 0;
                        Node attrName = node.getAttributes().getNamedItem("name");
                        if (isFacet && attrName != null && "header".equals(attrName.getNodeValue())) {
                            this.header = node;
                        } else if (isFacet && attrName != null && "footer".equals(attrName.getNodeValue())) {
                            this.footer = node;
                        } else {
                            this.getBody().add(node);
                        }
                    }
                    ++i;
                }
                if (!this.hasBody() && (text = VpeCreatorUtil.getTextChildNode(columnNode)) != null) {
                    this.getBody().add(text);
                }
            }
        }

        public boolean hasHeader() {
            return this.header != null;
        }

        public boolean hasBody() {
            return this.body != null && this.body.size() > 0;
        }

        public List<Node> getBody() {
            if (this.body == null) {
                this.body = new ArrayList<Node>();
            }
            return this.body;
        }

        public void setBody(List<Node> body) {
            this.body = body;
        }

        public Node getFooter() {
            return this.footer;
        }

        public void setFooter(Node footer) {
            this.footer = footer;
        }

        public Node getHeader() {
            return this.header;
        }

        public void setHeader(Node header) {
            this.header = header;
        }

        public void setColumn(Node column) {
            this.column = column;
        }

        public boolean hasFooter() {
            return this.footer != null;
        }

        public int getBodyElementsCount() {
            if (this.body != null) {
                return this.body.size();
            }
            return 0;
        }

        public Node getBodyElement(int index) {
            if (this.body != null) {
                return this.body.get(index);
            }
            return null;
        }

        public Node getColumn() {
            return this.column;
        }
    }

    public static class SourceDataTableElements {
        private Node tableCaption;
        private Node tableHeader;
        private List<SourceColumnElements> columns;
        private List<Node> redundantTextNodes;
        private Node tableFooter;

        public SourceDataTableElements(Node dataTableNode) {
            this.init(dataTableNode);
        }

        private void init(Node dataTableNode) {
            int cnt;
            NodeList list = dataTableNode.getChildNodes();
            int n = cnt = list != null ? list.getLength() : 0;
            if (cnt > 0) {
                int i = 0;
                while (i < cnt) {
                    Node node = list.item(i);
                    if (node.getNodeType() == 3) {
                        if (this.redundantTextNodes == null) {
                            this.redundantTextNodes = new ArrayList<Node>();
                        }
                        this.redundantTextNodes.add(node);
                    }
                    if (node.getNodeType() == 1) {
                        boolean isColumn = node.getNodeName().indexOf(":column") > 0 || node.getNodeName().indexOf(":treeColumn") > 0;
                        boolean isFacet = !isColumn && node.getNodeName().indexOf(":facet") > 0;
                        Node attrName = node.getAttributes().getNamedItem("name");
                        if (!isColumn && isFacet && attrName != null && "header".equals(attrName.getNodeValue())) {
                            this.tableHeader = node;
                        } else if (!isColumn && isFacet && attrName != null && "footer".equals(attrName.getNodeValue())) {
                            this.tableFooter = node;
                        } else if (!isColumn && isFacet && attrName != null && "caption".equals(attrName.getNodeValue())) {
                            this.tableCaption = node;
                        } else if (isColumn) {
                            if (this.columns == null) {
                                this.columns = new ArrayList<SourceColumnElements>();
                            }
                            this.columns.add(new SourceColumnElements(node));
                        }
                    }
                    ++i;
                }
            }
        }

        public Node getRedundantTextNode(int index) {
            if (this.redundantTextNodes != null && index < this.getRedundantTextNodesCount()) {
                return this.redundantTextNodes.get(index);
            }
            return null;
        }

        public int getRedundantTextNodesCount() {
            if (this.redundantTextNodes != null) {
                return this.redundantTextNodes.size();
            }
            return 0;
        }

        public SourceColumnElements getColumn(int index) {
            if (this.columns != null && index < this.getColumnCount()) {
                return this.columns.get(index);
            }
            return null;
        }

        public int getColumnCount() {
            if (this.columns != null) {
                return this.columns.size();
            }
            return 0;
        }

        public boolean hasColspan() {
            return this.getColumnCount() >= 2;
        }

        public boolean hasHeaderSection() {
            return this.tableHeader != null || this.hasColumnsHeader();
        }

        public boolean hasBodySection() {
            int i = 0;
            while (i < this.getColumnCount()) {
                SourceColumnElements column = this.getColumn(i);
                if (column.hasBody()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean hasFooterSection() {
            return this.tableFooter != null || this.hasColumnsFooter();
        }

        public boolean hasTableHeader() {
            return this.tableHeader != null;
        }

        public boolean hasTableFooter() {
            return this.tableFooter != null;
        }

        public boolean hasTableCaption() {
            return this.tableCaption != null;
        }

        public boolean hasColumnsHeader() {
            int i = 0;
            while (i < this.getColumnCount()) {
                SourceColumnElements column = this.getColumn(i);
                if (column.hasHeader()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean hasColumnsFooter() {
            int i = 0;
            while (i < this.getColumnCount()) {
                SourceColumnElements column = this.getColumn(i);
                if (column.hasFooter()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Node getTableFooter() {
            return this.tableFooter;
        }

        public void setTableFooter(Node tableFooter) {
            this.tableFooter = tableFooter;
        }

        public Node getTableHeader() {
            return this.tableHeader;
        }

        public void setTableHeader(Node tableHeader) {
            this.tableHeader = tableHeader;
        }

        public Node getTableCaption() {
            return this.tableCaption;
        }

        public void setTableCaption(Node tableCaption) {
            this.tableCaption = tableCaption;
        }
    }

    public static class VisualColumnElements {
        private nsIDOMElement headerCell;
        private nsIDOMElement bodyCell;
        private nsIDOMElement footerCell;

        public nsIDOMElement getBodyCell() {
            return this.bodyCell;
        }

        public void setBodyCell(nsIDOMElement bodyCell) {
            this.bodyCell = bodyCell;
        }

        public nsIDOMElement getFooterCell() {
            return this.footerCell;
        }

        public void setFooterCell(nsIDOMElement footerCell) {
            this.footerCell = footerCell;
        }

        public nsIDOMElement getHeaderCell() {
            return this.headerCell;
        }

        public void setHeaderCell(nsIDOMElement headerCell) {
            this.headerCell = headerCell;
        }
    }

    public static class VisualDataTableElements {
        private nsIDOMElement caption;
        private nsIDOMElement tableHeader;
        private nsIDOMElement tableHeaderRow;
        private nsIDOMElement columnsHeader;
        private nsIDOMElement columnsHeaderRow;
        private nsIDOMElement body;
        private nsIDOMElement bodyRow;
        private nsIDOMElement contentTableBodyRow;
        private nsIDOMElement tableFooter;
        private nsIDOMElement tableFooterRow;
        private nsIDOMElement columnsFooter;
        private nsIDOMElement columnsFooterRow;

        public VisualDataTableElements() {
        }

        public VisualDataTableElements(nsIDOMElement caption, nsIDOMElement columnsHeader, nsIDOMElement columnsFooter, nsIDOMElement header, nsIDOMElement body, nsIDOMElement footer) {
            this.caption = caption;
            this.columnsHeader = columnsHeader;
            this.columnsFooter = columnsFooter;
            this.tableHeader = header;
            this.body = body;
            this.tableFooter = footer;
        }

        public nsIDOMElement getBody() {
            return this.body;
        }

        public void setBody(nsIDOMElement body) {
            this.body = body;
        }

        public nsIDOMElement getBodyRow() {
            return this.bodyRow;
        }

        public void setBodyRow(nsIDOMElement bodyRow) {
            this.bodyRow = bodyRow;
        }

        public nsIDOMElement getContentTableBodyRow() {
            return this.contentTableBodyRow;
        }

        public void setContentTableBodyRow(nsIDOMElement contentTableBodyRow) {
            this.contentTableBodyRow = contentTableBodyRow;
        }

        public nsIDOMElement getColumnsFooterRow() {
            return this.columnsFooterRow;
        }

        public void setColumnsFooterRow(nsIDOMElement columnsFooterRow) {
            this.columnsFooterRow = columnsFooterRow;
        }

        public nsIDOMElement getColumnsHeaderRow() {
            return this.columnsHeaderRow;
        }

        public void setColumnsHeaderRow(nsIDOMElement columnsHeaderRow) {
            this.columnsHeaderRow = columnsHeaderRow;
        }

        public nsIDOMElement getTableFooter() {
            return this.tableFooter;
        }

        public void setTableFooter(nsIDOMElement footer) {
            this.tableFooter = footer;
        }

        public nsIDOMElement getTableHeader() {
            return this.tableHeader;
        }

        public void setTableHeader(nsIDOMElement header) {
            this.tableHeader = header;
        }

        public nsIDOMElement getColumnsFooter() {
            return this.columnsFooter;
        }

        public void setColumnsFooter(nsIDOMElement footer) {
            this.columnsFooter = footer;
        }

        public nsIDOMElement getColumnsHeader() {
            return this.columnsHeader;
        }

        public void setColumnsHeader(nsIDOMElement header) {
            this.columnsHeader = header;
        }

        public nsIDOMElement getCaption() {
            return this.caption;
        }

        public void setCaption(nsIDOMElement caption) {
            this.caption = caption;
        }

        public nsIDOMElement getTableFooterRow() {
            return this.tableFooterRow;
        }

        public void setTableFooterRow(nsIDOMElement tableFooterRow) {
            this.tableFooterRow = tableFooterRow;
        }

        public nsIDOMElement getTableHeaderRow() {
            return this.tableHeaderRow;
        }

        public void setTableHeaderRow(nsIDOMElement tableHeaderRow) {
            this.tableHeaderRow = tableHeaderRow;
        }
    }
}

