/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeFacetCreator
extends VpeAbstractCreator {
    VpeFacetCreator(Element element, VpeDependencyMap dependencyMap, boolean caseSensitive) {
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) {
        Node sourceParent;
        VpeCreatorInfo creatorInfo = null;
        boolean isHeader = false;
        boolean isFooter = false;
        Node nameAttr = sourceNode.getAttributes().getNamedItem("name");
        if (nameAttr != null) {
            String name = nameAttr.getNodeValue();
            isHeader = name.equals("header");
            isFooter = name.equals("footer");
        }
        if ((isHeader || isFooter) && (sourceParent = sourceNode.getParentNode()) != null) {
            nsIDOMElement cell = null;
            int columnsCount = this.getColumnsCount(sourceParent);
            if (isHeader) {
                cell = this.makeCell(columnsCount, "th", visualDocument);
            } else if (isFooter) {
                cell = this.makeCell(columnsCount, "td", visualDocument);
            }
            if (cell != null) {
                if (isHeader) {
                    this.setCellClass(cell, this.getTableAttrValue(sourceParent, "headerClass"));
                } else if (isFooter) {
                    this.setCellClass(cell, this.getTableAttrValue(sourceParent, "footerClass"));
                }
                creatorInfo = new VpeCreatorInfo((nsIDOMNode)cell);
            }
        }
        return creatorInfo;
    }

    @Override
    public boolean isRecreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        return true;
    }

    public Node getNodeForUpdate(VpePageContext pageContext, Node sourceNode, Node visualNode, Map visualNodeMap) {
        return sourceNode.getParentNode();
    }

    private void setCellClass(nsIDOMElement cell, String className) {
        if (cell != null && className != null && className.trim().length() > 0) {
            cell.setAttribute("class", className);
        }
    }

    private String getTableAttrValue(Node dataTableNode, String attrName) {
        Node attr;
        if (dataTableNode != null && (attr = dataTableNode.getAttributes().getNamedItem(attrName)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    private int getColumnsCount(Node dataTableNode) {
        int count = 0;
        NodeList childs = dataTableNode.getChildNodes();
        int length = childs != null ? childs.getLength() : 0;
        int i = 0;
        while (i < length) {
            Node child = childs.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().indexOf(":column") > 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private nsIDOMElement makeCell(int columnCount, String cellTag, nsIDOMDocument visualDocument) {
        nsIDOMElement visualCell = visualDocument.createElement(cellTag);
        if (columnCount > 1) {
            visualCell.setAttribute("colspan", "" + columnCount);
        }
        return visualCell;
    }
}

