/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.open;

import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.TaglibMapping;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.pv.StrutsProjectsRoot;
import org.jboss.tools.struts.model.pv.StrutsProjectsTree;

public class OpenTagLib {
    public String run(XModel model, String uri, String tag, String attribute) {
        if (model == null || uri == null) {
            return null;
        }
        if (uri.length() == 0) {
            return StrutsUIMessages.URI_ISNOT_SPECIFIED;
        }
        XModelObject t = this.findTagLib(model, uri);
        if (t == null) {
            return NLS.bind((String)StrutsUIMessages.CANNOT_FIND_TAGLIBRARY, (Object)uri);
        }
        if (tag != null) {
            if (tag.length() == 0) {
                return StrutsUIMessages.TAG_ISNOT_SPECIFIED;
            }
            if ((t = this.findTag(t, tag)) == null) {
                return NLS.bind((String)StrutsUIMessages.CANNOT_FIND_TAG_IN_LIBRARY, (Object)tag, (Object)uri);
            }
        }
        FindObjectHelper.findModelObject((XModelObject)t, (int)FindObjectHelper.IN_EDITOR_ONLY);
        if (attribute != null) {
            if (attribute.length() == 0) {
                return StrutsUIMessages.ATTRIBUTE_ISNOT_SPECIFIED;
            }
            if ((t = this.findAttribute(t, attribute)) == null) {
                return NLS.bind((String)StrutsUIMessages.CANNOT_FIND_ATTRIBUTE_IN_TAG, (Object)attribute, (Object)tag);
            }
        }
        FindObjectHelper.findModelObject((XModelObject)t, (int)FindObjectHelper.IN_EDITOR_ONLY);
        return null;
    }

    private XModelObject findTagLib(XModel model, String uri) {
        TaglibMapping t = WebProject.getInstance((XModel)model).getTaglibMapping();
        XModelObject o = t.getTaglibObject(uri);
        if (o != null) {
            return o;
        }
        StrutsProjectsRoot root = StrutsProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return null;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Tag Libraries");
        if (n == null) {
            return null;
        }
        XModelObject[] os = n.getTreeChildren();
        int i = 0;
        while (i < os.length) {
            if (uri.equals(os[i].getAttributeValue("uri"))) {
                return os[i];
            }
            ++i;
        }
        if (uri.endsWith(".tld") && (o = XModelImpl.getByRelativePath((XModel)model, (String)uri)) != null) {
            return o;
        }
        return null;
    }

    private XModelObject findTag(XModelObject taglib, String name) {
        return taglib.getChildByPath(name);
    }

    private XModelObject findAttribute(XModelObject tag, String name) {
        return tag.getChildByPath(name);
    }
}

