/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.path;

import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class SelectPathSupport
extends SpecialWizardSupport {
    protected void reset() {
        this.getProperties().put("contextProcess", this.getTarget());
        this.loadSelection();
    }

    private UrlPattern getUrlPattern() {
        return StrutsProcessStructureHelper.instance.getUrlPattern(this.getTarget());
    }

    private void loadSelection() {
        String p = this.getProperties().getProperty("selectedPath");
        this.getProperties().remove("selectedAction");
        this.getProperties().remove("selectedObject");
        if (p == null || p.length() == 0) {
            return;
        }
        boolean isAction = this.getUrlPattern().isActionUrl(p);
        XModelObject so = this.findInProcess(p, isAction);
        if (isAction) {
            this.getProperties().setProperty("selectedTab", "Actions");
            if (so != null) {
                this.getProperties().put("selectedAction", so);
            }
        } else {
            this.getProperties().setProperty("selectedTab", "Pages");
            so = so != null ? StrutsProcessStructureHelper.instance.getPhysicalPage(so) : StrutsProcessStructureHelper.instance.getPhysicalPage(this.getTarget(), p);
            if (so != null) {
                this.getProperties().put("selectedObject", so);
            }
        }
    }

    private XModelObject findInProcess(String p, boolean isAction) {
        if (isAction) {
            p = this.getUrlPattern().getActionPath(p);
        }
        XModelObject[] cs = this.getTarget().getChildren();
        int i = 0;
        while (i < cs.length) {
            if (p.equals(cs[i].getAttributeValue("path"))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setStepId(-1);
            this.getProperties().remove("selectedPath");
            this.setFinished(true);
        }
    }

    public String getStepImplementingClass(int stepId) {
        return super.getStepImplementingClass(stepId);
    }

    public boolean isActionEnabled(String name) {
        if (name.equals(OK)) {
            String pn;
            String tab = this.getProperties().getProperty("selectedTab");
            String string = pn = "Actions".equals(tab) ? "selectedAction" : "selectedObject";
            return this.getProperties().get(pn) != null;
        }
        return true;
    }
}

