/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.rulesets.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.core.PMDCoreException;
import net.sourceforge.pmd.eclipse.core.rulesets.IRuleSetsManager;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.RuleSet;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.RuleSets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class RuleSetsManagerImpl
implements IRuleSetsManager {
    private static final Log LOG;
    private static final String RULESETS_MAPPING = "/net/sourceforge/pmd/eclipse/core/rulesets/impl/mapping.xml";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.core.rulesets.impl.RuleSetsManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public RuleSets readFromXml(InputStream inputStream) throws PMDCoreException {
        return null;
    }

    public RuleSet valueOf(String[] stringArray) throws PMDCoreException {
        LOG.debug((Object)"Compting value of a collection of rule set urls");
        if (stringArray == null) {
            throw new IllegalArgumentException("ruleSetUrls cannot be null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("ruleSetsUrls cannot be empty");
        }
        try {
            RuleSet ruleSet = new RuleSet();
            int n = 0;
            while (n < stringArray.length) {
                RuleSetFactory ruleSetFactory = new RuleSetFactory();
                Collection collection = ruleSetFactory.createSingleRuleSet(stringArray[n]).getRules();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Rule rule = (Rule)iterator.next();
                    net.sourceforge.pmd.eclipse.core.rulesets.vo.Rule rule2 = new net.sourceforge.pmd.eclipse.core.rulesets.vo.Rule();
                    rule2.setRef(String.valueOf(stringArray[n]) + '/' + rule.getName());
                    rule2.setPmdRule(rule);
                    ruleSet.addRule(rule2);
                }
                ++n;
            }
            return ruleSet;
        }
        catch (RuleSetNotFoundException ruleSetNotFoundException) {
            LOG.error((Object)"A RuleSetsNotFound Exception was thrown.");
            throw new PMDCoreException("A RuleSetsNotFound Exception was thrown.", ruleSetNotFoundException);
        }
    }

    public void writeToXml(RuleSets ruleSets, OutputStream outputStream) throws PMDCoreException {
        LOG.debug((Object)"Storing plug-in rulesets");
        try {
            LocalConfiguration.getInstance().getProperties().setProperty("org.exolab.castor.indent", "true");
            Mapping mapping = new Mapping(this.getClass().getClassLoader());
            URL uRL = this.getClass().getResource(RULESETS_MAPPING);
            mapping.loadMapping(uRL);
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = new Marshaller((Writer)stringWriter);
            marshaller.setMapping(mapping);
            marshaller.marshal((Object)ruleSets);
            stringWriter.flush();
            stringWriter.close();
            outputStream.write(stringWriter.getBuffer().toString().getBytes());
            outputStream.flush();
        }
        catch (MarshalException marshalException) {
            LOG.error((Object)"A Marshal Exception was thrown.");
            throw new PMDCoreException("A Marshal Exception was thrown.", marshalException);
        }
        catch (ValidationException validationException) {
            LOG.error((Object)"A Validation Exception was thrown.");
            throw new PMDCoreException("A Validation Exception was thrown.", validationException);
        }
        catch (MappingException mappingException) {
            LOG.error((Object)"A Mapping Exception was thrown.");
            throw new PMDCoreException("A Mapping Exception was thrown.", mappingException);
        }
        catch (IOException iOException) {
            LOG.error((Object)"A IO Exception was thrown.");
            throw new PMDCoreException("A IO Exception was thrown.", iOException);
        }
    }
}

