/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.rulesets.vo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.Rule;

public class RuleSet {
    public static final String LANGUAGE_JAVA = "JAVA";
    public static final String LANGUAGE_JSP = "JSP";
    private String name = "";
    private String description = "";
    private String language = "JAVA";
    private final net.sourceforge.pmd.RuleSet pmdRuleSet = new net.sourceforge.pmd.RuleSet();
    private final Collection rules = new ArrayList();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new IllegalArgumentException("description cannot be null");
        }
        this.description = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.name = string;
    }

    public Collection getRules() {
        return this.rules;
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("rule cannot be null");
        }
        this.rules.add(rule);
        this.pmdRuleSet.addRule(rule.getPmdRule());
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        if (!LANGUAGE_JAVA.equals(string) && !LANGUAGE_JSP.equals(string)) {
            throw new IllegalArgumentException("language must be one of the LANGUAGE_xxx constant and found " + string);
        }
        this.language = string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RuleSet) {
            RuleSet ruleSet = (RuleSet)object;
            bl = this.name.equals(ruleSet.name) && this.rules.equals(ruleSet.rules) && this.language.equals(ruleSet.language);
        }
        return bl;
    }

    public int hashCode() {
        return this.name.hashCode() + this.rules.hashCode() * 21 * 21 + this.language.hashCode() * 13 * 13;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RuleSet name=" + this.name + " description=" + " language=" + this.language + " rules=");
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(' ').append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public net.sourceforge.pmd.RuleSet getPmdRuleSet() {
        return this.pmdRuleSet;
    }
}

