/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.TableColumnSorter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DataflowAnomalyTableViewer
extends TableViewer {
    protected Integer[] columnWidths;
    protected int[] columnSortOrder = new int[]{1, 1, 1};
    protected int currentSortedColumn;

    public DataflowAnomalyTableViewer(Composite composite, int n) {
        super(composite, n | 0x100 | 0x200 | 4 | 0x10000);
        this.setUseHashlookup(true);
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.createColumns(this.getTable());
        GridData gridData = new GridData(1808);
        this.getTable().setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.getTable().setLayout((Layout)gridLayout);
    }

    private void createColumns(Table table) {
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setWidth(80);
        tableColumn.setText(this.getString("view.dataflow.table.column_type"));
        tableColumn.setToolTipText(this.getString("view.dataflow.table.column_type.tooltip"));
        TableColumn tableColumn2 = new TableColumn(table, 131072);
        tableColumn2.setWidth(100);
        tableColumn2.setText(this.getString("view.dataflow.table.column_line"));
        TableColumn tableColumn3 = new TableColumn(table, 131072);
        tableColumn3.setWidth(70);
        tableColumn3.setText(this.getString("view.dataflow.table.column_variable"));
        TableColumn tableColumn4 = new TableColumn(table, 131072);
        tableColumn4.setWidth(100);
        tableColumn4.setText(this.getString("view.dataflow.table.column_method"));
        this.createColumnAdapters(table);
        this.setSorter(this.getViewerSorter(1));
    }

    private void createColumnAdapters(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        this.columnWidths = new Integer[tableColumnArray.length];
        int n = 0;
        while (n < tableColumnArray.length) {
            this.columnWidths[n] = new Integer(tableColumnArray[n].getWidth());
            final int n2 = n;
            tableColumnArray[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = DataflowAnomalyTableViewer.this.currentSortedColumn = n2;
                    DataflowAnomalyTableViewer.this.columnSortOrder[n] = DataflowAnomalyTableViewer.this.columnSortOrder[n] * -1;
                    DataflowAnomalyTableViewer.this.setSorter(DataflowAnomalyTableViewer.this.getViewerSorter(DataflowAnomalyTableViewer.this.currentSortedColumn));
                }
            });
            tableColumnArray[n].addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    DataflowAnomalyTableViewer.this.columnWidths[n2] = new Integer(DataflowAnomalyTableViewer.this.getTable().getColumn(n2).getWidth());
                }
            });
            ++n;
        }
    }

    private ViewerSorter getViewerSorter(int n) {
        TableColumn tableColumn = this.getTable().getColumn(n);
        final int n2 = this.columnSortOrder[n];
        TableColumnSorter tableColumnSorter = null;
        switch (n) {
            case 0: {
                tableColumnSorter = new TableColumnSorter(tableColumn, n2){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        int n = 0;
                        if (object instanceof IRuleViolation && object2 instanceof IRuleViolation) {
                            String string;
                            IRuleViolation iRuleViolation = (IRuleViolation)object;
                            IRuleViolation iRuleViolation2 = (IRuleViolation)object2;
                            String string2 = iRuleViolation.getDescription();
                            if (string2.equalsIgnoreCase(string = iRuleViolation2.getDescription())) {
                                int n22 = iRuleViolation.getBeginLine();
                                int n3 = iRuleViolation2.getBeginLine();
                                int n4 = iRuleViolation.getEndLine();
                                int n5 = iRuleViolation2.getEndLine();
                                Integer n6 = new Integer(n22 < n3 ? n22 : n3);
                                Integer n7 = new Integer(n4 < n5 ? n4 : n5);
                                n = n6.compareTo(n7) * n2;
                            } else {
                                n = string2.compareToIgnoreCase(string) * n2;
                            }
                        }
                        return n;
                    }
                };
                break;
            }
            case 1: {
                tableColumnSorter = new TableColumnSorter(tableColumn, n2){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        int n = 0;
                        if (object instanceof IRuleViolation && object2 instanceof IRuleViolation) {
                            IRuleViolation iRuleViolation = (IRuleViolation)object;
                            IRuleViolation iRuleViolation2 = (IRuleViolation)object2;
                            int n22 = iRuleViolation.getBeginLine();
                            int n3 = iRuleViolation2.getBeginLine();
                            int n4 = iRuleViolation.getEndLine();
                            int n5 = iRuleViolation2.getEndLine();
                            Integer n6 = new Integer(n22 < n3 ? n22 : n3);
                            Integer n7 = new Integer(n4 < n5 ? n4 : n5);
                            n = n6.compareTo(n7) * n2;
                        }
                        return n;
                    }
                };
                break;
            }
            case 2: {
                tableColumnSorter = new TableColumnSorter(tableColumn, n2){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        int n = 0;
                        if (object instanceof IRuleViolation && object2 instanceof IRuleViolation) {
                            IRuleViolation iRuleViolation = (IRuleViolation)object;
                            IRuleViolation iRuleViolation2 = (IRuleViolation)object2;
                            String string = iRuleViolation.getVariableName();
                            String string2 = iRuleViolation2.getVariableName();
                            n = string.compareToIgnoreCase(string2) * n2;
                        }
                        return n;
                    }
                };
            }
        }
        return tableColumnSorter;
    }

    public void setVisible(boolean bl) {
        this.getTable().setVisible(bl);
        ((GridData)this.getTable().getLayoutData()).exclude = !bl;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

