/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;

public class PriorityFilterAction
extends Action {
    private ViolationOutline outlineView;
    private ViolationOverview overviewView;
    private PriorityFilter priorityFilter;
    private Integer priority;

    public PriorityFilterAction(Integer n, ViolationOutline violationOutline) {
        this.outlineView = violationOutline;
        this.priority = n;
        ViewerFilter[] viewerFilterArray = violationOutline.getFilters();
        int n2 = 0;
        while (n2 < viewerFilterArray.length) {
            if (viewerFilterArray[n2] instanceof PriorityFilter) {
                this.priorityFilter = (PriorityFilter)viewerFilterArray[n2];
            }
            ++n2;
        }
        this.setupActionLook();
    }

    public PriorityFilterAction(Integer n, ViolationOverview violationOverview) {
        this.overviewView = violationOverview;
        this.priority = n;
        ViewerFilter[] viewerFilterArray = violationOverview.getViewer().getFilters();
        int n2 = 0;
        while (n2 < viewerFilterArray.length) {
            if (viewerFilterArray[n2] instanceof PriorityFilter) {
                this.priorityFilter = (PriorityFilter)viewerFilterArray[n2];
            }
            ++n2;
        }
        this.setupActionLook();
    }

    private void setupActionLook() {
        ImageDescriptor imageDescriptor = null;
        String string = null;
        String string2 = null;
        switch (this.priority) {
            case 1: {
                imageDescriptor = PMDPlugin.getImageDescriptor("icons/btn_prio1.gif");
                string = this.getString("view.filter.priority.1");
                string2 = this.getString("view.tooltip.filter.priority.1");
                break;
            }
            case 2: {
                imageDescriptor = PMDPlugin.getImageDescriptor("icons/btn_prio2.gif");
                string = this.getString("view.filter.priority.2");
                string2 = this.getString("view.tooltip.filter.priority.2");
                break;
            }
            case 3: {
                imageDescriptor = PMDPlugin.getImageDescriptor("icons/btn_prio3.gif");
                string = this.getString("view.filter.priority.3");
                string2 = this.getString("view.tooltip.filter.priority.3");
                break;
            }
            case 4: {
                imageDescriptor = PMDPlugin.getImageDescriptor("icons/btn_prio4.gif");
                string = this.getString("view.filter.priority.4");
                string2 = this.getString("view.tooltip.filter.priority.4");
                break;
            }
            case 5: {
                imageDescriptor = PMDPlugin.getImageDescriptor("icons/btn_prio5.gif");
                string = this.getString("view.filter.priority.5");
                string2 = this.getString("view.tooltip.filter.priority.5");
            }
        }
        this.setImageDescriptor(imageDescriptor);
        this.setText(string);
        this.setToolTipText(string2);
    }

    public int getStyle() {
        return 2;
    }

    public void run() {
        if (this.isChecked()) {
            this.priorityFilter.addPriorityToList(this.priority);
        } else {
            this.priorityFilter.removePriorityFromList(this.priority);
        }
        if (this.outlineView != null) {
            this.outlineView.refresh();
        } else if (this.overviewView != null) {
            this.overviewView.refresh();
        }
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

