/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.PasteEnterNewNameSupport;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;

public class DefaultRenameSupport
extends SpecialWizardSupport {
    protected int returnCode = -1;
    protected XModelObject source;
    protected XModelObject copy;
    RenameValidator pasteValidator = new RenameValidator();

    public static int run(XModelObject object, XEntityData data, Properties p) {
        return DefaultRenameSupport.run(object, data, p, new DefaultRenameSupport());
    }

    public static int run(XModelObject object, XEntityData data, Properties p, DefaultRenameSupport support) {
        support.setActionData(null, new XEntityData[]{data}, object, p);
        object.getModel().getService().showDialog(support);
        return support.getReturnCode();
    }

    public void reset() {
        this.returnCode = -1;
        this.source = this.getTarget();
        this.copy = this.source.copy();
    }

    public String getTitle() {
        String title = this.getProperties().getProperty("title");
        if (title != null) {
            return title;
        }
        return MessageFormat.format("Rename {0}", PasteEnterNewNameSupport.getCapitalizedName(this.getTarget()));
    }

    public String getSubtitle() {
        XModelObject o = this.getTarget();
        if (o == null) {
            return "";
        }
        String element = o.getAttributeValue("element type");
        if (element == null) {
            return "";
        }
        return WizardKeys.toDisplayName(element);
    }

    public String getMessage(int stepId) {
        String displayName = WizardKeys.getAttributeDisplayName(this.getEntityData()[0].getAttributeData()[0].getAttribute(), true);
        return MessageFormat.format("Please enter new {0}.", displayName);
    }

    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL};
    }

    public void action(String name) throws XModelException {
        if (name.equals(FINISH)) {
            this.returnCode = 0;
            this.setFinished(true);
        } else if (name.equals(CANCEL)) {
            this.returnCode = 1;
            this.setFinished(true);
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public WizardDataValidator getValidator(int step) {
        this.pasteValidator.setSupport(this, step);
        return this.pasteValidator;
    }

    protected void applyDataToCopy(Properties data, int step) {
        XAttributeData[] ad = this.getEntityData()[step].getAttributeData();
        int i = 0;
        while (i < ad.length) {
            String n = ad[i].getAttribute().getName();
            String v = data.getProperty(n);
            if (v != null) {
                this.copy.setAttributeValue(n, v);
            }
            ++i;
        }
    }

    class RenameValidator
    extends DefaultWizardDataValidator {
        RenameValidator() {
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            DefaultRenameSupport.this.applyDataToCopy(data, this.step);
            this.message = DefaultRenameSupport.this.source.getPathPart().equals(DefaultRenameSupport.this.copy.getPathPart()) ? this.support.getMessage(this.step) : DefaultCreateHandler.getContainsMessage(DefaultRenameSupport.this.source.getParent(), DefaultRenameSupport.this.copy);
        }
    }
}

