/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class DefaultSpecialHandler
extends AbstractHandler {
    private boolean validated = false;
    private SpecialWizard wizard = null;
    private SpecialWizardSupport support = null;

    public static SpecialWizardSupport createSpecialWizardSupport(String id) {
        try {
            return (SpecialWizardSupport)ModelFeatureFactory.getInstance().createFeatureInstance(id);
        }
        catch (ClassCastException e) {
            ModelPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.common.model", 0, "Model warning: Cannot load special wizard support " + id + ".", (Throwable)e));
            return null;
        }
    }

    private void validate() {
        if (this.validated) {
            return;
        }
        this.validated = true;
        this.wizard = SpecialWizardFactory.createSpecialWizard("org.jboss.tools.common.model.ui.wizards.special.DefaultSpecialWizard");
        this.support = DefaultSpecialHandler.createSpecialWizardSupport(this.action.getProperty("support"));
        if (this.support != null) {
            this.support.setAction(this.action);
        }
    }

    public boolean isEnabled(XModelObject object) {
        this.validate();
        return object != null && this.wizard != null && this.support != null && this.support.isEnabled(object);
    }

    public boolean isEnabled(XModelObject object, XModelObject[] objects) {
        if (object != null && (objects == null || objects.length == 1)) {
            return this.isEnabled(object);
        }
        return false;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        this.support.setActionData(this.action, this.data, object, p);
        if (this.support.isFinished()) {
            return;
        }
        this.wizard.setObject(new Object[]{this.support});
        this.wizard.execute();
    }
}

