/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.help;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.help.WorkbenchHelp;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.impl.handlers.OpenWithExternalBrowserHandler;
import org.jboss.tools.common.meta.key.KeyLoader;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpUtil {
    private static final String HELP_PLUGIN_ID = "org.jboss.tools.struts.doc.ui";
    private static final String JSF_HELP_PLUGIN_ID = "org.jboss.tools.jsf.doc.ui";
    static String[] PLUGINS = new String[]{"org.jboss.tools.struts.doc.ui", "org.jboss.tools.jsf.doc.ui"};
    static Properties keys = KeyLoader.load("help/keys");
    static Map<String, Set<String>> zips = new HashMap<String, Set<String>>();

    public static boolean hasHelp(String key) {
        String path;
        String string = path = key == null ? null : keys.getProperty(key);
        return path != null && path.length() > 0;
    }

    public static boolean isHelpPluginInstalled() {
        int i = 0;
        while (i < PLUGINS.length) {
            if (Platform.getBundle((String)PLUGINS[i]) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasEclipseHelp(String key) {
        String path;
        String string = path = key == null ? null : keys.getProperty(key);
        return path != null && path.length() > 0;
    }

    public static void callExternalBrowser(XModel model, String url) throws XModelException {
        XModelObject editor = model.getByPath("%Options%/External Programs/Internet Browser");
        if (editor == null) {
            throw new XModelException("External Program 'Internet Browser' is not set in Options.");
        }
        OpenWithExternalBrowserHandler.start("Help", url, editor);
    }

    public static String createKey(XModelObject object, XAction action) {
        return String.valueOf(object.getModelEntity().getName()) + "_" + action.getName();
    }

    public static Properties createKey(XModelObject object, XAction action, Properties p) {
        if (p == null) {
            p = new Properties();
        }
        p.setProperty("help", HelpUtil.createKey(object, action));
        return p;
    }

    public static void helpEclipse(XModel model, String key) {
        ServiceDialog d = model.getService();
        if (!HelpUtil.isHelpPluginInstalled()) {
            d.showDialog("Help", "User Guide is not installed.", new String[]{"Close"}, null, 3);
        } else if (!HelpUtil.hasEclipseHelp(key)) {
            d.showDialog("Help", MessageFormat.format("Help key {0} is not found.", key), new String[]{"Close"}, null, 3);
        } else {
            String path = HelpUtil.getValidPath(keys.getProperty(key));
            if (path != null) {
                WorkbenchHelp.displayHelpResource((String)path);
            } else {
                d.showDialog("Help", MessageFormat.format("Help resource {0} is not found.", keys.getProperty(key)), new String[]{"Close"}, null, 3);
            }
        }
    }

    private static String getValidPath(String path) {
        if (path == null) {
            return null;
        }
        int i = 0;
        while (i < PLUGINS.length) {
            Bundle p = Platform.getBundle((String)PLUGINS[i]);
            URL url = EclipseResourceUtil.getInstallURL(p);
            if (url != null) {
                Set<String> set;
                String zipPath;
                String f = url.getFile().replace('\\', '/');
                if (f.endsWith("/")) {
                    f = f.substring(0, f.length() - 1);
                }
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (new File(zipPath = String.valueOf(f) + "/doc.zip").exists() && (set = HelpUtil.getZipEntries(zipPath)).contains(path)) {
                    return "/" + PLUGINS[i] + "/" + path;
                }
                if (new File(String.valueOf(f) + path).isFile()) {
                    return "/" + PLUGINS[i] + "/" + path;
                }
            }
            ++i;
        }
        return null;
    }

    private static Set<String> getZipEntries(String zipPath) {
        Set<String> set = zips.get(zipPath);
        if (set != null) {
            return set;
        }
        set = new HashSet<String>();
        zips.put(zipPath, set);
        try {
            ZipFile zip = new ZipFile(new File(zipPath));
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                set.add("/" + entry.getName());
            }
        }
        catch (IOException iOException) {}
        return set;
    }
}

