/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.constraint.XAdapter;
import org.jboss.tools.common.meta.constraint.XAttributeConstraint;
import org.jboss.tools.common.meta.constraint.XAttributeEditor;
import org.jboss.tools.common.meta.constraint.impl.XAttributeEditorImpl;
import org.jboss.tools.common.meta.impl.AdapterHolder;
import org.jboss.tools.common.meta.impl.ConstraintHolder;
import org.jboss.tools.common.meta.impl.XMetaDataLoader;
import org.jboss.tools.common.meta.impl.XMetaElementImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XMLUtil;
import org.w3c.dom.Element;

public class XAttributeImpl
extends XMetaElementImpl
implements XAttribute {
    private XModelEntity entity;
    protected XAttributeEditor m_Editor;
    protected String m_DefValue;
    protected boolean m_Visible;
    protected ConstraintHolder constraint = new ConstraintHolder(this);
    protected boolean m_Required;
    protected boolean m_Editable;
    protected boolean trimmable;
    protected boolean copyable;
    protected String m_XMLName;
    protected AdapterHolder adapter = new AdapterHolder();
    public static final String LOADER = "loader";
    public static final String CONSTRAINT_PREFIX = "org.jboss.tools.common.meta.constraint.impl.XAttributeConstraint";
    public static final String ATTRIBUTE_PREFIX = "org.jboss.tools.common.meta.impl.adapters.XAdapter";

    public XAttributeImpl copy() {
        XAttributeImpl copy = new XAttributeImpl();
        copy.name = this.name;
        copy.displayName = this.displayName;
        copy.p = this.p;
        copy.m_Editor = this.m_Editor;
        copy.m_DefValue = this.m_DefValue;
        copy.m_Visible = this.m_Visible;
        copy.constraint = this.constraint;
        copy.m_Required = this.m_Required;
        copy.m_Editable = this.m_Editable;
        copy.trimmable = this.trimmable;
        copy.copyable = this.copyable;
        copy.m_XMLName = this.m_XMLName;
        copy.adapter = this.adapter;
        return copy;
    }

    public void valueChanged(XModelObject object) {
    }

    public XModelEntity getModelEntity() {
        return this.entity;
    }

    void setModelEntity(XModelEntity entity) {
        this.entity = entity;
    }

    public XAttributeEditor getEditor() {
        return this.m_Editor;
    }

    void setEditor(XAttributeEditor ed) {
        this.m_Editor = ed;
    }

    public String getDefaultValue() {
        return this.m_DefValue;
    }

    public void setDefaultValue(String value) {
        this.m_DefValue = XAttributeImpl.replace(value, "%cr%", "\n");
    }

    public boolean isTrimmable() {
        return this.trimmable;
    }

    public boolean isCopyable() {
        return this.copyable;
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    void setVisible(boolean v) {
        this.m_Visible = v;
    }

    public XAttributeConstraint getConstraint() {
        return this.constraint.getConstraint();
    }

    public boolean isRequired() {
        return this.m_Required;
    }

    void setRequired(boolean req) {
        this.m_Required = req;
    }

    public boolean isEditable() {
        return this.m_Editable;
    }

    void setEditable(boolean ed) {
        this.m_Editable = ed;
    }

    void setXMLName(String xname) {
        this.m_XMLName = xname;
    }

    public String getXMLName() {
        return this.m_XMLName;
    }

    public boolean isFake() {
        return "FAKE".equals(this.m_XMLName);
    }

    public void load(Element el) {
        if (XMLUtil.getUniqueChild(el, "Editor") == null) {
            XAttributeEditorImpl editor = new XAttributeEditorImpl();
            editor.setName(null);
            this.setEditor(editor);
        } else {
            this.setEditor((XAttributeEditor)XMetaDataLoader.loadMetaElement(el, "Editor", XAttributeEditorImpl.class, false));
        }
        Element c = XMetaDataLoader.getUniqueChild(el, "Constraint");
        if (c != null) {
            this.loadConstraint(c);
        }
        this.setVisible(XMetaDataLoader.getBoolean(el, "visibility", true));
        this.setRequired(XMetaDataLoader.getBoolean(el, "required", false));
        this.setEditable(XMetaDataLoader.getBoolean(el, "editable", false));
        this.setDefaultValue(el.getAttribute("default"));
        this.setXMLName(el.getAttribute("xmlname"));
        this.loadAdapter(el);
        this.trimmable = !"no".equals(el.getAttribute("TRIM"));
        this.copyable = !"no".equals(el.getAttribute("COPYABLE"));
        this.loadProperties(el);
    }

    public String toString() {
        return this.getName();
    }

    public void loadConstraint(Element element) {
        if (element == null) {
            return;
        }
        String loader = element.getAttribute(LOADER);
        if (!XMetaDataLoader.hasAttribute(element, LOADER) || loader.trim().length() == 0) {
            loader = "";
        }
        if (loader != null && loader.startsWith("%")) {
            loader = this.expand(loader, "AttributeConstraints");
        }
        this.constraint.init(loader, element);
    }

    public void loadAdapter(Element element) {
        String loader = element.getAttribute(LOADER);
        if (loader.length() == 0 && this.getXMLName().length() > 0) {
            loader = "ModelElement";
        }
        this.adapter.init(this, loader, element);
        this.loadValueListeners(element);
    }

    public XAdapter getAdapter() {
        return this.adapter.getAdapter();
    }

    public void loadValueListeners(Element element) {
    }

    private static String replace(String source, String a, String b) {
        if (source == null || source.indexOf(a) < 0) {
            return source;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int sL = source.length();
        int aL = a.length();
        while (i < sL) {
            int j = source.indexOf(a, i);
            if (j < 0) {
                sb.append(source.substring(i));
                break;
            }
            sb.append(source.substring(i, j)).append(b);
            i = j + aL;
        }
        return sb.toString();
    }
}

