/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import java.io.FileNotFoundException;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Vector;
import org.jboss.tools.common.meta.XMetaElement;
import org.jboss.tools.common.meta.impl.MetaLibLoader;
import org.jboss.tools.common.meta.impl.XExtensions;
import org.jboss.tools.common.meta.impl.XMetaDataConstants;
import org.jboss.tools.common.meta.impl.XMetaElementImpl;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ClassLoaderUtil;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;

public class XMetaDataLoader
implements XMetaDataConstants {
    public static boolean hasAttribute(Element e, String s) {
        return XMLUtil.hasAttribute(e, s);
    }

    private static XMetaElement getDefaultMetaElementInstance(Class defImpl) {
        try {
            return (XMetaElementImpl)defImpl.newInstance();
        }
        catch (InstantiationException instantiationException) {
            ModelPlugin.getPluginLog().logError("Error in getDefaultMetaElementInstance");
        }
        catch (IllegalAccessException illegalAccessException) {
            ModelPlugin.getPluginLog().logError("Error in getDefaultMetaElementInstance");
        }
        return null;
    }

    private static XMetaElement getMetaElementInstance(Element element, Class defImpl, boolean isRequired) {
        if (element == null) {
            return !isRequired ? null : XMetaDataLoader.getDefaultMetaElementInstance(defImpl);
        }
        if (defImpl != null) {
            return XMetaDataLoader.getDefaultMetaElementInstance(defImpl);
        }
        String loader = element.getAttribute("loader");
        if (loader == null || loader.length() == 0) {
            return null;
        }
        try {
            return (XMetaElementImpl)ClassLoaderUtil.getClassLoader().loadClass(loader).newInstance();
        }
        catch (InstantiationException e) {
            ModelPlugin.getPluginLog().logError("Error in getMetaElementInstance " + loader, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelPlugin.getPluginLog().logError("Error in getMetaElementInstance " + loader, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            ModelPlugin.getPluginLog().logError("Error in getMetaElementInstance " + loader, (Throwable)e);
        }
        return null;
    }

    public static XMetaElement loadMetaElement(Element parent, String nodeName, Class defImpl, boolean isRequired) {
        return XMetaDataLoader.loadMetaElement(XMetaDataLoader.getUniqueChild(parent, nodeName), defImpl, isRequired);
    }

    public static XMetaElement loadMetaElement(Element element, Class defImpl, boolean isRequired) {
        XMetaElementImpl m = (XMetaElementImpl)XMetaDataLoader.getMetaElementInstance(element, defImpl, isRequired);
        if (m != null && element != null) {
            m.setName(element.getAttribute("name"));
            m.setDisplayName(element.getAttribute("displayName"));
            m.load(element);
        }
        return m;
    }

    public static XMetaElement[] loadElementGroup(Element element, String groupName, String elName, Class defImpl) {
        Element att = XMetaDataLoader.getUniqueChild(element, groupName);
        if (att == null) {
            return (XMetaElement[])Array.newInstance(defImpl, 0);
        }
        Element[] cs = XMetaDataLoader.getChildrenElements(att, elName);
        Vector<XMetaElement> v = new Vector<XMetaElement>(cs.length);
        int i = 0;
        while (i < cs.length) {
            XMetaElement attr = XMetaDataLoader.loadMetaElement(cs[i], defImpl, false);
            if (attr != null) {
                v.addElement(attr);
            }
            ++i;
        }
        return v.toArray((XMetaElement[])Array.newInstance(defImpl, v.size()));
    }

    public static Element getUniqueChild(Element element, String name) {
        return XMLUtil.getUniqueChild(element, name);
    }

    public static Element[] getChildrenElements(Element element, String child) {
        return XMLUtil.getChildren(element, child);
    }

    public static boolean getBoolean(Element el, String attName, boolean def) {
        String a = el.getAttribute(attName);
        return a == null || a.length() == 0 ? def : "true".equalsIgnoreCase(a) || "yes".equalsIgnoreCase(a);
    }

    public static int getInt(Element el, String attName, int def) {
        try {
            return Integer.parseInt(el.getAttribute(attName));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    static Element loadDocument(String filename) throws FileNotFoundException {
        Element e = XMLUtil.getElement(filename);
        if (e == null) {
            throw new FileNotFoundException(MessageFormat.format("Can''t load meta model from {0}", filename));
        }
        return e;
    }

    public static void loadMetaModel(XModelMetaDataImpl factory) {
        new MetaLibLoader().load(factory);
    }

    static void loadEntityGroup(XModelMetaDataImpl factory, Element g) {
        String module = "";
        Element v = XMLUtilities.getUniqueChild((Element)g, (String)"VERSION");
        if (v != null && v.hasAttribute("MODULE")) {
            module = v.getAttribute("MODULE");
        }
        XMetaDataLoader.loadMappings(factory, g);
        factory.createIconList(XMetaDataLoader.getUniqueChild(g, "ICONS"));
        XMetaDataLoader.loadGlobalActions(factory, g);
        XMetaDataLoader.loadEntities(factory, g, module);
    }

    private static void loadEntities(XModelMetaDataImpl factory, Element element, String module) {
        Element[] cs = XMetaDataLoader.getChildrenElements(element, "XModelEntity");
        int i = 0;
        while (i < cs.length) {
            factory.createEntity(cs[i], module);
            ++i;
        }
        cs = XMetaDataLoader.getChildrenElements(element, "XEntityExtension");
        XExtensions extensions = factory.getExtensions();
        int i2 = 0;
        while (i2 < cs.length) {
            extensions.addExtension(cs[i2]);
            ++i2;
        }
    }

    private static void loadMappings(XModelMetaDataImpl factory, Element group) {
        Element mappings = XMetaDataLoader.getUniqueChild(group, "MAPPINGS");
        if (mappings != null) {
            factory.loadMappings(mappings);
        }
    }

    private static void loadGlobalActions(XModelMetaDataImpl factory, Element group) {
        Element actions = XMetaDataLoader.getUniqueChild(group, "GlobalActions");
        if (actions != null) {
            factory.loadGlobalActions(actions);
        }
    }
}

