/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.meta.XParents;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.meta.action.impl.XActionListImpl;
import org.jboss.tools.common.meta.constraint.XAttributeConstraint;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.meta.impl.XExtensions;
import org.jboss.tools.common.meta.impl.XMappingImpl;
import org.jboss.tools.common.meta.impl.XMetaDataConstants;
import org.jboss.tools.common.meta.impl.XMetaDataLoader;
import org.jboss.tools.common.meta.impl.XModelEntityImpl;
import org.jboss.tools.common.meta.impl.XParentsImpl;
import org.jboss.tools.common.model.icons.XIconList;
import org.jboss.tools.common.model.icons.impl.XIconListImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XModelMetaDataImpl
implements XModelMetaData,
XMetaDataConstants {
    private static XModelMetaDataImpl instance = null;
    private static boolean loaded = false;
    boolean reportLoadingTime = false;
    private HashMap<String, XModelEntity> entities = new HashMap(50);
    private XIconListImpl icons = new XIconListImpl();
    private HashMap<String, XMappingImpl> mappings = new HashMap();
    private XActionListImpl actions = new XActionListImpl();
    private XExtensions extensions = new XExtensions();
    private XParentsImpl parents = new XParentsImpl();
    static Object lock = new Object();
    private HashMap<String, String> loadedmodules = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XModelMetaData getInstance() {
        if (loaded) {
            return instance;
        }
        Object object = lock;
        synchronized (object) {
            if (instance != null) {
                return instance;
            }
            instance = new XModelMetaDataImpl();
            loaded = true;
        }
        return instance;
    }

    private XModelMetaDataImpl() {
        long t = System.currentTimeMillis();
        XMetaDataLoader.loadMetaModel(this);
        instance = this;
        this.parents.init(this);
        XModelEntityImpl r = (XModelEntityImpl)this.getEntity("Root");
        r.validateChildren();
        XModelEntity[] es = this.entities.values().toArray(new XModelEntity[0]);
        int i = 0;
        while (i < es.length) {
            ((XModelEntityImpl)es[i]).validate();
            ++i;
        }
        if (this.reportLoadingTime) {
            long l = -t;
            t = System.currentTimeMillis();
            long dt = l + t;
            ModelPlugin.getPluginLog().logInfo("Meta model loaded in " + dt + " ms");
        }
    }

    private void makeStatistics(XModelEntity[] es) {
        HashSet<String> attNames = new HashSet<String>();
        HashSet<String> listValues = new HashSet<String>();
        HashSet<String> actionMenuNames = new HashSet<String>();
        int attrCount = 0;
        int i = 0;
        while (i < es.length) {
            XAttribute[] as = es[i].getAttributes();
            int j = 0;
            while (j < as.length) {
                if (as[j].isVisible()) {
                    ++attrCount;
                    attNames.add(as[j].getName());
                    XAttributeConstraint c = as[j].getConstraint();
                    if (c instanceof XAttributeConstraintAList) {
                        String[] values = ((XAttributeConstraintAList)c).getValues();
                        int k = 0;
                        while (k < values.length) {
                            listValues.add(values[k]);
                            ++k;
                        }
                    }
                }
                ++j;
            }
            XActionList al = es[i].getActionList();
            this.makeActionList(al, actionMenuNames);
            ++i;
        }
        System.out.println("------> Attributes=" + attNames.size() + " (total " + attrCount + ")");
        System.out.println("------> List values=" + listValues.size());
        System.out.println("------> Action menu names=" + actionMenuNames.size());
    }

    private void makeActionList(XActionList list, Set<String> actionMenuNames) {
        XActionItem[] is = list.getActionItems();
        int i = 0;
        while (i < is.length) {
            actionMenuNames.add(is[i].getName());
            if (is[i] instanceof XActionList) {
                this.makeActionList((XActionList)is[i], actionMenuNames);
            }
            ++i;
        }
    }

    @Override
    public XIconList getIconList() {
        return this.icons;
    }

    @Override
    public String[] entities() {
        return this.entities.keySet().toArray(new String[0]);
    }

    @Override
    public XModelEntity getEntity(String entityname) {
        XModelEntityImpl entity = (XModelEntityImpl)this.entities.get(entityname);
        if (entity != null) {
            entity.validate();
        }
        return entity;
    }

    public XExtensions getExtensions() {
        return this.extensions;
    }

    public XModelEntity createEntity(Element element, String module) {
        XModelEntityImpl entity = new XModelEntityImpl();
        entity.setModule(module);
        entity.setElement(element);
        this.entities.put(entity.getName(), entity);
        return entity;
    }

    @Override
    public XMapping getMapping(String name) {
        return this.mappings.get(name);
    }

    public void createIconList(Element element) {
        this.icons.load(element);
    }

    public void loadMappings(Element element) {
        Element[] es = XMetaDataLoader.getChildrenElements(element, "MAPPING");
        int i = 0;
        while (i < es.length) {
            String n = es[i].getAttribute("name");
            XMappingImpl m = this.mappings.get(n);
            if (m == null) {
                m = new XMappingImpl();
                this.mappings.put(n, m);
            }
            m.load(es[i]);
            ++i;
        }
    }

    @Override
    public XActionList getGlobalActions() {
        return this.actions;
    }

    public void loadGlobalActions(Element element) {
        if (this.actions.getActionItems() == null) {
            this.actions.load(element);
        } else {
            XActionListImpl a = new XActionListImpl();
            a.load(element);
            this.actions.merge(a);
        }
    }

    public HashMap<String, String> getLoadedModules() {
        return this.loadedmodules;
    }

    Map<String, XModelEntity> getEntities() {
        return this.entities;
    }

    @Override
    public XParents getParentInfo() {
        return this.parents;
    }
}

