/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XParents;
import org.jboss.tools.common.meta.impl.XMetaDataConstants;
import org.jboss.tools.common.meta.impl.XMetaDataLoader;
import org.jboss.tools.common.meta.impl.XModelEntityExtensionImpl;
import org.jboss.tools.common.meta.impl.XModelEntityImpl;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XParentsImpl
implements XParents,
XMetaDataConstants {
    private Map<String, Set<String>> parents = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> ancestors = new HashMap<String, Set<String>>();

    @Override
    public boolean isDescendant(String entity1, String entity2) {
        if (!this.parents.containsKey(entity1)) {
            return false;
        }
        Set<String> as = this.getAncestors(entity1);
        return as != null && as.contains(entity2);
    }

    @Override
    public Set<String> getAncestors(String entity) {
        Set<String> set = this.ancestors.get(entity);
        if (set == null) {
            set = new HashSet<String>();
            this.fillAncestors(entity, set);
            this.ancestors.put(entity, set);
        }
        return set;
    }

    void init(XModelMetaDataImpl meta) {
        Iterator<String> it = meta.getEntities().keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            XModelEntityImpl entity = (XModelEntityImpl)meta.getEntities().get(name);
            Element element = entity.element;
            if (element == null) {
                this.addParents(entity.getChildren(), name);
                continue;
            }
            this.addParents(element, name);
            ArrayList<XModelEntityExtensionImpl> l = meta.getExtensions().getExtensions(name);
            if (l == null) continue;
            XModelEntityExtensionImpl[] ees = l.toArray(new XModelEntityExtensionImpl[0]);
            int k = 0;
            while (k < ees.length) {
                Element e1 = ees[k].element;
                if (e1 == null) {
                    this.addParents(ees[k].getChildren(), name);
                } else {
                    this.addParents(e1, name);
                }
                ++k;
            }
        }
    }

    private void addParents(XChild[] cs, String parent) {
        int i = 0;
        while (i < cs.length) {
            this.add(cs[i].getName(), parent);
            ++i;
        }
    }

    private void addParents(Element element, String parent) {
        Element e = XMetaDataLoader.getUniqueChild(element, "XChildrenEntities");
        if (e == null) {
            return;
        }
        Element[] es = XMetaDataLoader.getChildrenElements(e, "XChildEntity");
        int i = 0;
        while (i < es.length) {
            this.add(es[i].getAttribute("name"), parent);
            ++i;
        }
    }

    private void add(String child, String parent) {
        Set<String> ps = this.parents.get(child);
        if (ps == null) {
            ps = new HashSet<String>();
            this.parents.put(child, ps);
        }
        ps.add(parent);
    }

    public Set getParents(String entity) {
        return this.parents.get(entity);
    }

    private void fillAncestors(String entity, Set<String> set) {
        Set parents = this.getParents(entity);
        if (parents == null) {
            return;
        }
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            String e = it.next().toString();
            if (set.contains(e)) continue;
            set.add(e);
            Set<String> as = this.ancestors.get(entity);
            if (as != null) {
                set.addAll(as);
                continue;
            }
            this.fillAncestors(e, set);
        }
    }
}

