/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.OLBind;
import org.jboss.tools.common.model.event.XModelChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XModelChangeManager {
    private ArrayList<OLBind> binds = new ArrayList();

    public synchronized void createListener(XModelObject object, XModelChangeListener listener) {
        this.binds.add(new OLBind(object, listener));
    }

    public synchronized void removeListener(XModel model, String path, XModelChangeListener listener) {
        XModelObject object = model.getByPath(path);
        if (object == null) {
            return;
        }
        OLBind bind = new OLBind(object, listener);
        int l = this.binds.size();
        int i = l - 1;
        while (i >= 0) {
            if (bind.equals(this.binds.get(i))) {
                this.binds.remove(i);
            }
            --i;
        }
    }

    public synchronized void removeListener(XModelChangeListener listener) {
        int l = this.binds.size();
        int i = l - 1;
        while (i >= 0) {
            OLBind bind = this.binds.get(i);
            if (listener == bind.listener) {
                this.binds.remove(i);
            }
            --i;
        }
    }

    public boolean canFire() {
        int l = this.binds.size();
        int i = l - 1;
        while (i >= 0) {
            OLBind bind = this.binds.get(i);
            if (bind.canFire()) {
                return true;
            }
            --i;
        }
        return false;
    }

    public synchronized void fire() {
        int l = this.binds.size();
        int i = l - 1;
        while (i >= 0) {
            OLBind bind = this.binds.get(i);
            bind.fire();
            if (bind.isDead()) {
                this.binds.remove(i);
            }
            --i;
        }
    }

    public List<OLBind> getBindList() {
        return Collections.unmodifiableList(this.binds);
    }
}

