/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class CreateFileHandler
extends DefaultCreateHandler {
    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        XModelObject q;
        if (!this.isEnabled(object) || this.data == null || this.data.length == 0) {
            return;
        }
        Properties p = CreateFileHandler.extractProperties(this.data[0]);
        String defaultExtention = this.getDefaultExtension(prop);
        CreateFileHandler.validateNameAndExtension(this.action, p, defaultExtention);
        XModelObject parent = this.getParentFolder(object, p);
        String ext = p.getProperty("extension");
        String entity = this.action.getProperty("entity");
        if (entity == null) {
            String string = entity = ext != null ? object.getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext(ext)) : this.data[0].getModelEntity().getName();
            if (entity == null || object.getModel().getMetaData().getEntity(entity) == null) {
                entity = this.data[0].getModelEntity().getName();
            }
        }
        this.setOtherProperties(object, p);
        XModelObject c = XModelObjectLoaderUtil.createValidObject(object.getModel(), entity, p);
        c = this.modifyCreatedObject(c);
        if (parent.isActive()) {
            CreateFileHandler.addCreatedObject(parent, c, p);
        } else {
            CreateFileHandler.addCreatedObject(parent, c, false, p);
            XModelObject po = (XModelObject)p.get("parentObject");
            XModelObject co = (XModelObject)p.get("childObject");
            CreateFileHandler.addCreatedObject(po, co, p);
        }
        if (parent instanceof FolderImpl) {
            FolderImpl f = (FolderImpl)parent;
            f.saveChild(c);
        }
        if ((q = c) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    XActionInvoker.invoke("Open", q, new Properties());
                }
            });
        }
    }

    private String getDefaultExtension(Properties prop) {
        String ext = prop == null ? null : prop.getProperty("defaultExtention");
        return ext == null ? null : ext;
    }

    public static void validateNameAndExtension(XAction action, Properties p, String defaultExtention) {
        String name = p.getProperty("name");
        String ext = defaultExtention;
        String path = null;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            String es = action.getProperty("extensions");
            String xext = name.substring(i + 1);
            if (es == null || es.length() == 0 || es.indexOf("." + xext + ".") >= 0) {
                ext = xext;
                name = name.substring(0, i);
            }
        }
        if ((i = (name = name.replace('\\', '/')).lastIndexOf(47)) >= 0) {
            path = name.substring(0, i);
            name = name.substring(i + 1);
        }
        p.setProperty("name", name);
        if (ext != null) {
            p.setProperty("extension", ext);
        }
        if (path != null) {
            p.setProperty("path", path);
        }
    }

    private XModelObject getParentFolder(XModelObject object, Properties p) throws XModelException {
        String path = p.getProperty("path");
        if (path == null || path.length() == 0) {
            return object;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String pp = st.nextToken();
            XModelObject c = object.getChildByPath(pp);
            if (c == null) {
                c = object.getModel().createModelObject("FileFolder", null);
                c.setAttributeValue("name", pp);
                p.put("parentObject", object);
                p.put("childObject", c);
                return this.createFolder(c, st);
            }
            if (!"FileFolder".equals(c.getModelEntity().getName())) {
                throw new XModelException("Cannot create folder " + pp + " in " + object.getPathPart());
            }
            object = c;
        }
        return object;
    }

    private XModelObject createFolder(XModelObject object, StringTokenizer path) throws XModelException {
        while (path.hasMoreTokens()) {
            String pp = path.nextToken();
            XModelObject c = object.getModel().createModelObject("FileFolder", null);
            c.setAttributeValue("name", pp);
            object.addChild(c);
            object = c;
        }
        return object;
    }
}

