/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import org.jboss.tools.common.model.filesystems.impl.JarAccess;
import org.jboss.tools.common.model.filesystems.impl.LFileObject;

class LFileObjectJarImpl
implements LFileObject {
    private JarAccess access = null;
    private String aliaspath = null;
    private String relpath = null;

    public LFileObjectJarImpl(JarAccess access, String alias, String relpath) {
        this.access = access;
        this.aliaspath = relpath.length() == 0 ? alias : String.valueOf(alias) + '/' + relpath;
        this.relpath = relpath;
    }

    public String getName() {
        return this.relpath.substring(this.relpath.lastIndexOf(47) + 1);
    }

    public boolean exists() {
        return this.access.hasFolder(this.relpath) || this.access.hasFile(this.relpath);
    }

    public boolean isDirectory() {
        return this.access.hasFolder(this.relpath);
    }

    public boolean isFile() {
        return this.access.hasFile(this.relpath);
    }

    public long lastModified() {
        return 0L;
    }

    public String getPath() {
        return this.aliaspath;
    }

    public boolean canWrite() {
        return false;
    }

    public String read() {
        return this.access.getContent(this.relpath);
    }

    public void write(String s) {
    }

    public String[] listFiles() {
        String[] r = this.access.getChildren(this.relpath);
        String rp = this.getPath();
        int i = 0;
        while (i < r.length) {
            if (r[i].endsWith("/")) {
                r[i] = r[i].substring(0, r[i].length() - 1);
            }
            r[i] = String.valueOf(rp) + "/" + r[i];
            ++i;
        }
        return r;
    }

    public boolean mkdirs() {
        return false;
    }

    public boolean delete() {
        return false;
    }
}

