/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class SelectOverlappedFileSystemHandler
extends AbstractHandler {
    public boolean isEnabled(XModelObject o) {
        return o != null && "true".equals(o.get("overlapped"));
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        XModelObject fs = SelectOverlappedFileSystemHandler.getOverlappedFileSystem(object);
        if (object == fs) {
            return;
        }
        if (fs == null) {
            if (object.isActive() && object.getFileType() == 1 && XActionInvoker.getAction("OpenFile", object) != null) {
                XActionInvoker.invoke("OpenFile", object, null);
            }
            return;
        }
        Properties fsp = XModelObjectUtil.toProperties(fs);
        if ("yes".equals(fsp.getProperty("hidden", "no"))) {
            fsp.setProperty("hidden", "no");
            fs.setAttributeValue("info", XModelObjectUtil.toString(fsp));
            fs.setModified(true);
            XModelImpl m = (XModelImpl)object.getModel();
            m.fireStructureChanged(fs.getParent());
        }
        FindObjectHelper.findModelObject(fs, FindObjectHelper.EVERY_WHERE);
    }

    static XModelObject getOverlappedFileSystem(XModelObject source) {
        String fp = SelectOverlappedFileSystemHandler.getAbsoluteFileFolderPath(source);
        if (fp == null) {
            return null;
        }
        XModelObject fs = FileSystemsHelper.getFileSystems(source.getModel());
        if (fs == null) {
            return null;
        }
        XModelObject[] cs = fs.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (fp.equals(SelectOverlappedFileSystemHandler.getAbsoluteFileSystemPath(cs[i]))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    private static String getAbsoluteFileSystemPath(XModelObject fso) {
        String path = XModelObjectUtil.getExpandedValue(fso, "location", null);
        try {
            path = new File(path).getCanonicalPath().replace('\\', '/');
            return FilePathHelper.toPathPath(path);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getAbsoluteFileFolderPath(XModelObject f) {
        String path = f.getPath();
        String rpath = XModelObjectLoaderUtil.getResourcePath(f);
        if (path == null || rpath == null) {
            return null;
        }
        XModelObject fso = f.getModel().getByPath(path.substring(0, path.length() - rpath.length()));
        String pp = String.valueOf(SelectOverlappedFileSystemHandler.getAbsoluteFileSystemPath(fso)) + rpath;
        return FilePathHelper.toPathPath(pp);
    }
}

