/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.xml.XMLUtilities;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLRecognizerContext
extends EntityRecognizerContext {
    protected boolean isDTD = false;
    protected DoctypeInfo doctypeInfo = null;
    static DoctypeInfo NULL_INFO = new DoctypeInfo();
    static HashMap<String, DoctypeInfo> doctypes = new HashMap();

    public XMLRecognizerContext(EntityRecognizerContext context) {
        super(context.getFileName(), context.getExtension(), context.getBody());
        this.init();
    }

    void init() {
        if (this.body == null) {
            return;
        }
        String doctypeText = this.getUnformattedDoctypeFromBody(this.body);
        if (doctypeText != null) {
            this.isDTD = true;
            this.doctypeInfo = this.checkDocType(doctypeText);
        }
    }

    public boolean isDTD() {
        return this.isDTD;
    }

    public String getPublicId() {
        return this.doctypeInfo == null ? null : this.doctypeInfo.publicId;
    }

    public String getSystemId() {
        return this.doctypeInfo == null ? null : this.doctypeInfo.systemId;
    }

    public String getRootName() {
        if (this.doctypeInfo != null) {
            return this.doctypeInfo.name;
        }
        return null;
    }

    public XMLRecognizerContext getXMLContext() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private DoctypeInfo checkDocType(String docTypeString) {
        block19: {
            block18: {
                if (XMLRecognizerContext.doctypes.containsKey(docTypeString)) {
                    return XMLRecognizerContext.doctypes.get(docTypeString);
                }
                xml = new StringReader(String.valueOf(docTypeString) + "<root></root>");
                db = XMLUtilities.createDocumentBuilder((boolean)false);
                if (db == null) {
                    return XMLRecognizerContext.NULL_INFO;
                }
                db.setErrorHandler(new ErrorHandler(){

                    public void warning(SAXParseException exception) throws SAXException {
                    }

                    public void fatalError(SAXParseException exception) throws SAXException {
                    }

                    public void error(SAXParseException exception) throws SAXException {
                    }
                });
                db.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new StringReader(""));
                    }
                });
                doc = db.parse(new InputSource(xml));
                if (doc == null) break block18;
                dt = doc.getDoctype();
                doctypeInfo = new DoctypeInfo();
                doctypeInfo.publicId = dt.getPublicId();
                doctypeInfo.systemId = dt.getSystemId();
                doctypeInfo.name = dt.getName();
                XMLRecognizerContext.doctypes.put(docTypeString, doctypeInfo);
                var8_7 = doctypeInfo;
                try {
                    xml.close();
                }
                catch (IOException v0) {}
                return var8_7;
                catch (SAXException v1) {
                    ** try [egrp 2[TRYBLOCK] [6 : 183->184)] { 
lbl27:
                    // 1 sources

                    try {
                        xml.close();
                    }
                    catch (IOException v2) {}
                    break block19;
                }
                catch (IOException v3) {
                    ** try [egrp 4[TRYBLOCK] [7 : 195->196)] { 
lbl-1000:
                    // 3 sources

                    {
                        catch (Throwable var7_8) {
                            try {
                                xml.close();
                            }
                            catch (IOException v4) {}
                            throw var7_8;
                        }
                    }
lbl40:
                    // 1 sources

                    try {
                        xml.close();
                    }
                    catch (IOException v5) {}
                    break block19;
                }
            }
            try {
                xml.close();
            }
            catch (IOException v6) {}
        }
        XMLRecognizerContext.doctypes.put(docTypeString, XMLRecognizerContext.NULL_INFO);
        return XMLRecognizerContext.NULL_INFO;
    }

    private String getUnformattedDoctypeFromBody(String body) {
        int i = body.indexOf("<!DOCTYPE");
        if (i < 0) {
            return null;
        }
        int j = body.indexOf(">", i);
        if (j < 0) {
            return null;
        }
        return body.substring(i, j + 1);
    }

    protected static class DoctypeInfo {
        protected String publicId;
        protected String systemId;
        protected String name;

        protected DoctypeInfo() {
        }
    }
}

