/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options.impl;

import java.io.File;
import java.util.Hashtable;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.SharableConstants;

class XStudioLoaderPeer
implements SharableConstants {
    private static final XStudioLoaderPeer instance = new XStudioLoaderPeer();
    private Hashtable<String, File[]> paths = new Hashtable(3);
    private boolean isLoadingOn;

    public static XStudioLoaderPeer instance() {
        return instance;
    }

    private XStudioLoaderPeer() {
    }

    public void init(XModelObject studio) {
        XModel model = studio.getModel();
        String r = String.valueOf(XModelConstants.getWorkspace(model)) + "/";
        int i = 0;
        while (i < LIST.length) {
            String[] fns = FILE_LIST[i];
            File[] fs = new File[fns.length];
            int j = 0;
            while (j < fs.length) {
                fs[j] = new File(String.valueOf(r) + FILE_LIST[i][j]);
                ++j;
            }
            this.paths.put(LIST[i], fs);
            ++i;
        }
    }

    void setIsLoadingOn(boolean b) {
        this.isLoadingOn = b;
    }

    File[] getFilesForScope(String scope) {
        return this.paths.get(scope);
    }

    public File getProjectPreferencesFile() {
        File[] fs = this.getFilesForScope("project");
        return fs != null && fs.length > 1 ? fs[1] : null;
    }

    public boolean isScopeEditable(String scope) {
        if (this.isLoadingOn) {
            return true;
        }
        if ("general".equals(scope)) {
            return false;
        }
        File[] f = this.getFilesForScope(scope);
        if (f == null) {
            return false;
        }
        int i = 0;
        while (i < f.length) {
            if (f[i].exists() && !f[i].canWrite()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getMaxScope(String s1, String s2) {
        int i2;
        int i1 = XStudioLoaderPeer.range(s1);
        return i1 > (i2 = XStudioLoaderPeer.range(s2)) ? s1 : s2;
    }

    private static int range(String scope) {
        int i = 0;
        while (i < LIST.length) {
            if (LIST[i].equals(scope)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

