/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.project.ext.impl;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;

public class ValueInfo
implements IValueInfo {
    String value;
    public int valueStartPosition;
    public int valueLength;
    static String ATTR_START = "start";
    static String ATTR_LENGTH = "length";

    public static ValueInfo getValueInfo(Annotation node, String name) {
        if (name == null) {
            name = "value";
        }
        if (node instanceof SingleMemberAnnotation) {
            if (name == null || "value".equals(name)) {
                SingleMemberAnnotation m = (SingleMemberAnnotation)node;
                ValueInfo result = new ValueInfo();
                Expression exp = m.getValue();
                result.valueLength = exp.getLength();
                result.valueStartPosition = exp.getStartPosition();
                result.value = ValueInfo.checkExpression(exp);
                return result;
            }
            return null;
        }
        if (node instanceof NormalAnnotation) {
            NormalAnnotation n = (NormalAnnotation)node;
            List vs = n.values();
            if (vs != null) {
                int i = 0;
                while (i < vs.size()) {
                    MemberValuePair p = (MemberValuePair)vs.get(i);
                    String pname = p.getName().getIdentifier();
                    if (name.equals(pname)) {
                        ValueInfo result = new ValueInfo();
                        Expression exp = p.getValue();
                        result.valueLength = exp.getLength();
                        result.valueStartPosition = exp.getStartPosition();
                        result.value = ValueInfo.checkExpression(exp);
                        return result;
                    }
                    ++i;
                }
            }
            return null;
        }
        return null;
    }

    public static ValueInfo getValueInfo(IAnnotation annotation, String name) {
        if (name == null) {
            name = "value";
        }
        ValueInfo result = new ValueInfo();
        ISourceRange r = null;
        IMemberValuePair[] ps = null;
        try {
            r = annotation.getSourceRange();
            ps = annotation.getMemberValuePairs();
        }
        catch (CoreException e) {
            ModelPlugin.getDefault().logError(e);
        }
        if (r != null) {
            result.valueStartPosition = r.getOffset();
            result.valueLength = r.getLength();
        }
        if (ps != null) {
            IMemberValuePair[] iMemberValuePairArray = ps;
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair p = iMemberValuePairArray[n2];
                if (name.equals(p.getMemberName())) {
                    Object v = p.getValue();
                    if (v == null) break;
                    result.value = v.toString();
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public String getValue() {
        return this.value;
    }

    public int getStartPosition() {
        return this.valueStartPosition;
    }

    public int getLength() {
        return this.valueLength;
    }

    static String checkExpression(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (exp instanceof StringLiteral) {
            return ((StringLiteral)exp).getLiteralValue();
        }
        if (exp instanceof QualifiedName) {
            Object o = exp.resolveConstantExpressionValue();
            if (o != null) {
                return o.toString();
            }
            return exp.toString();
        }
        Object o = exp.resolveConstantExpressionValue();
        if (o != null) {
            return o.toString();
        }
        return exp.toString();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Element toXML(Element parent, Properties context) {
        Element element = XMLUtilities.createElement((Element)parent, (String)"value-info");
        if (this.value != null) {
            element.setAttribute("value", this.value);
        }
        if (this.valueStartPosition != 0) {
            element.setAttribute(ATTR_START, "" + this.valueStartPosition);
        }
        if (this.valueLength != 0) {
            element.setAttribute(ATTR_LENGTH, "" + this.valueLength);
        }
        return element;
    }

    public void loadXML(Element element, Properties context) {
        String length;
        this.value = element.getAttribute("value");
        String start = element.getAttribute(ATTR_START);
        if (start != null && start.length() > 0) {
            try {
                this.valueStartPosition = Integer.parseInt(start);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((length = element.getAttribute(ATTR_LENGTH)) != null && length.length() > 0) {
            try {
                this.valueLength = Integer.parseInt(length);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

