/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.jboss.tools.common.model.util.ModelImages;

public class IconUtil {
    public static final int PALETTE_GROUP_IMAGE_TYPE = 1;
    public static final int PALETTE_ELEMENT_AS_GROUP_IMAGE_TYPE = 2;
    public static final int PALETTE_ELEMENT_IMAGE_TYPE = 3;
    public static final int PALETTE_IMAGE_WIDTH = 50;
    private static final int PALETTE_ARROW_TOP = 7;
    private static final int PALETTE_ARROW_RIGHT_SHIFT = 8;

    public static int[] grabPixels(ImageIcon im) {
        int w = im.getIconWidth();
        int h = im.getIconHeight();
        int[] px = new int[h * w];
        PixelGrabber pg = new PixelGrabber(im.getImage(), 0, 0, w, h, px, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        return px;
    }

    public static ImageData toEclipseImageData(ImageIcon icon) {
        int[] pixels = IconUtil.grabPixels(icon);
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        ImageData imgData = new ImageData(w, h, 32, new PaletteData(0xFF0000, 65280, 255));
        int maskWidth = ((w + 7) / 8 + 1) / 2 * 2;
        byte[] maskDate = new byte[maskWidth * h];
        ImageData mask = new ImageData(w, h, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}), 2, maskDate);
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                int pixelValue = pixels[y * w + x];
                if (pixelValue >>> 24 < 128) {
                    imgData.setPixel(x, y, 0);
                    mask.setPixel(x, y, 0);
                } else {
                    imgData.setPixel(x, y, pixelValue);
                    mask.setPixel(x, y, 1);
                }
                ++y;
            }
            ++x;
        }
        imgData.maskPad = mask.scanlinePad;
        imgData.maskData = mask.data;
        return imgData;
    }

    public static Image toEclipseImage(ImageIcon icon) {
        return new Image(null, IconUtil.toEclipseImageData(icon));
    }

    public static Image getEclipseImage(String imageName) {
        return ModelImages.getImage(imageName);
    }
}

