/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor.form;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.jboss.tools.common.editor.ErrorSelectionListener;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class SampleErrorForm
extends ExpandableForm {
    static Color RED = Display.getDefault().getSystemColor(3);
    static Color BLUE = Display.getDefault().getSystemColor(9);
    static Color BLACK = Display.getDefault().getSystemColor(2);
    static Color WHITE = Display.getDefault().getSystemColor(1);
    private Composite control;
    private Composite superControl;
    private Composite contentComposite;
    private String errorsString;
    private boolean visible;
    private static final int ERROR_TYPE = 0;
    private static final int ERROR_LOCATION = 1;
    private static final int ERROR_MESSAGE = 2;
    ErrorSelectionListener listener;
    StyledText styledText = null;
    StyleRange[] regions = new StyleRange[0];

    public SampleErrorForm() {
        this.setHeadingText("Errors");
        this.setCollapsable(Boolean.FALSE);
    }

    public void addErrorSelectionListener(ErrorSelectionListener listener) {
        this.listener = listener;
    }

    public void initialize(Object model) {
        String newErrors = (String)model;
        if (newErrors == null) {
            newErrors = "";
        }
        if (newErrors.equals(this.errorsString)) {
            return;
        }
        this.errorsString = newErrors;
        this.disposeLabels();
        this.createLabels();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        if (this.visible == b) {
            return;
        }
        this.visible = b;
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.control.setVisible(this.visible);
            this.control.setRedraw(false);
            this.control.getParent().setRedraw(false);
            this.control.layout(true);
            this.control.getParent().layout(true);
            this.control.setRedraw(true);
            this.control.getParent().setRedraw(true);
        }
    }

    public Control createControl(Composite parent, IWidgetSettings factory) {
        if (this.control == null) {
            this.control = new Composite(parent, 0);
            Font f = parent.getFont();
            if (f != null) {
                this.control.setFont(f);
            }
            ErrorLayout layout = new ErrorLayout();
            this.control.setLayout((Layout)layout);
            this.control.setLayoutData(this.getLayoutData());
            this.control.setBackground(parent.getBackground());
            this.superControl = (Composite)super.createControl(this.control, factory);
            this.superControl.setLayoutData((Object)new GridData(1808));
            if (f != null) {
                this.superControl.setFont(f);
            }
        }
        return this.control;
    }

    protected Control createClientArea(Composite parent, IWidgetSettings factory) {
        this.contentComposite = new Composite(parent, 0);
        this.contentComposite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.contentComposite.setLayout((Layout)layout);
        this.contentComposite.setLayoutData((Object)new GridData(1808));
        if (this.regions != null && this.regions.length > 0) {
            this.disposeLabels();
            this.createLabels();
        }
        return this.contentComposite;
    }

    private StyledText getStyledText(int errorCount) {
        boolean needsScroll = errorCount > 4;
        int style = 8;
        if (needsScroll) {
            style |= 0x200;
        }
        if (this.styledText == null || this.styledText.isDisposed()) {
            return this.createStyledText(style);
        }
        if (needsScroll != ((this.styledText.getStyle() & 0x200) != 0)) {
            this.styledText.dispose();
            return this.createStyledText(style);
        }
        return this.styledText;
    }

    private StyledText createStyledText(int style) {
        this.styledText = new StyledText(this.contentComposite, style);
        this.styledText.setCaret(null);
        GridData d = new GridData(1808);
        this.styledText.setLayoutData((Object)d);
        ML ml = new ML();
        this.styledText.addMouseMoveListener((MouseMoveListener)ml);
        this.styledText.addMouseListener((MouseListener)ml);
        return this.styledText;
    }

    private void createLabels() {
        if (this.contentComposite == null) {
            return;
        }
        String[] errors = this.getErrorMessages(this.errorsString);
        this.getStyledText(errors.length);
        ArrayList<StyleRange> regionList = new ArrayList<StyleRange>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < errors.length) {
            String[] messages = this.parseErrorMessage(errors[i]);
            int a = sb.length();
            sb.append(messages[0]);
            StyleRange region = new StyleRange(a, sb.length() - a, RED, null);
            regionList.add(region);
            a = sb.length();
            sb.append(messages[1]);
            region = new StyleRange2(a, sb.length() - a, BLUE, null, messages[1]);
            regionList.add(region);
            a = sb.length();
            sb.append(messages[2]);
            region = new StyleRange(a, sb.length() - a, BLACK, null);
            regionList.add(region);
            if (i < errors.length - 1) {
                a = sb.length();
                sb.append("\n");
                region = new StyleRange(a, sb.length() - a, WHITE, null);
                regionList.add(region);
            }
            ++i;
        }
        this.styledText.setText(sb.toString());
        this.regions = regionList.toArray(new StyleRange[0]);
        this.styledText.setStyleRanges(this.regions);
        this.control.update();
        this.control.layout();
        this.control.getParent().update();
        this.control.getParent().layout();
    }

    int getInt(String s, int def) {
        if (s == null || s.length() == 0) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return def;
        }
    }

    StyleRange getRange(MouseEvent e) {
        int offset = 0;
        try {
            offset = this.styledText.getOffsetAtLocation(new Point(e.x, e.y));
        }
        catch (SWTException sWTException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return this.getRange(offset);
    }

    StyleRange getRange(int offset) {
        int i = 0;
        while (i < this.regions.length) {
            if (this.regions[i].start <= offset && offset < this.regions[i].start + this.regions[i].length) {
                return this.regions[i];
            }
            ++i;
        }
        return null;
    }

    private void disposeLabels() {
        if (this.regions != null && this.regions.length > 0) {
            this.regions = new StyleRange[0];
            if (this.styledText != null && !this.styledText.isDisposed()) {
                this.styledText.setStyleRanges(this.regions);
                this.styledText.setText("");
            }
        }
    }

    public void dispose() {
        this.disposeLabels();
        if (this.contentComposite != null && !this.contentComposite.isDisposed()) {
            this.contentComposite.dispose();
        }
        this.contentComposite = null;
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        this.control = null;
        this.listener = null;
        super.dispose();
    }

    private String[] getErrorMessages(String s) {
        if (s == null) {
            s = "";
        }
        StringTokenizer st = new StringTokenizer(s, "\n");
        String[] rs = new String[st.countTokens()];
        int i = 0;
        while (i < rs.length) {
            rs[i] = st.nextToken();
            ++i;
        }
        return rs;
    }

    private String[] parseErrorMessage(String s) {
        String[] result = new String[3];
        int i = s.indexOf(64);
        int j = s.indexOf(64, i + 1);
        int k = s.indexOf(64, j + 1);
        if (k > j) {
            String q = s.substring(j + 1, k);
            result[0] = s.substring(0, i);
            result[1] = q;
            result[2] = s.substring(k + 1);
        } else {
            result[0] = "ERROR";
            result[1] = "0:0";
            result[2] = s;
        }
        if (result[1] == null || "0:0".equals(result[1])) {
            result[1] = "";
        }
        return result;
    }

    public boolean doGlobalAction(String actionId) {
        if (this.styledText == null || this.styledText.isDisposed() || !this.styledText.isFocusControl()) {
            return false;
        }
        if (this.styledText != null && !this.styledText.isDisposed() && ActionFactory.COPY.getId().equals(actionId)) {
            this.styledText.copy();
        }
        return true;
    }

    class ErrorLayout
    extends Layout {
        ErrorLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (!SampleErrorForm.this.isVisible()) {
                return new Point(-1, -1);
            }
            Point size = SampleErrorForm.this.superControl.computeSize(wHint, hHint, flushCache);
            if (SampleErrorForm.this.getLayout() instanceof GridLayout) {
                GridLayout layout = (GridLayout)SampleErrorForm.this.getLayout();
                size.x += layout.marginWidth * 2;
                size.y += layout.marginHeight * 2;
            }
            if (size.y > 100) {
                size.y = 100;
            }
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            int x = 0;
            int y = 0;
            int width = composite.getClientArea().width;
            int height = composite.getClientArea().height;
            if (!SampleErrorForm.this.isVisible()) {
                return;
            }
            if (SampleErrorForm.this.getLayout() instanceof GridLayout) {
                GridLayout layout = (GridLayout)SampleErrorForm.this.getLayout();
                x = layout.marginHeight;
                y = layout.marginWidth;
                width -= x * 2;
                height -= y * 2;
            }
            SampleErrorForm.this.superControl.setBounds(x, y, width, height);
            SampleErrorForm.this.superControl.layout();
            SampleErrorForm.this.contentComposite.layout();
        }
    }

    class ML
    extends MouseAdapter
    implements MouseMoveListener {
        Cursor hand = new Cursor(null, 21);
        Cursor arrow = new Cursor(null, 0);

        ML() {
        }

        public void mouseMove(MouseEvent e) {
            StyleRange range = SampleErrorForm.this.getRange(e);
            if (range != null && range.foreground == BLUE) {
                SampleErrorForm.this.styledText.setCursor(this.hand);
            } else {
                SampleErrorForm.this.styledText.setCursor(this.arrow);
            }
        }

        public void mouseUp(MouseEvent e) {
            StyleRange range = SampleErrorForm.this.getRange(e);
            if (range instanceof StyleRange2) {
                ((StyleRange2)range).execute();
            }
        }
    }

    class StyleRange2
    extends StyleRange {
        int line;
        int position;

        public StyleRange2(int start, int length, Color fg, Color bg, String location) {
            super(start, length, fg, bg);
            this.line = 0;
            this.position = 0;
            int i = location.indexOf(":");
            this.line = i < 0 ? 0 : SampleErrorForm.this.getInt(location.substring(0, i), 0);
            this.position = i < 0 ? 0 : SampleErrorForm.this.getInt(location.substring(i + 1), 0);
        }

        public void execute() {
            if (SampleErrorForm.this.listener != null) {
                SampleErrorForm.this.listener.errorSelected(this.line, this.position);
            }
        }
    }
}

