/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeContentProposal;
import org.eclipse.pde.internal.ui.editor.contentassist.TypePackageCompletionProcessor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.ui.attribute.IValueFilter;

class TypeContentProposalProvider
extends TypePackageCompletionProcessor
implements IContentProposalProvider {
    public static final char F_DOT = '.';
    private IProject fProject;
    private int fTypeScope;
    private ArrayList fInitialContentProposals;
    private String fInitialContent;
    private Comparator fComparator;
    IValueFilter valueFilter;

    public TypeContentProposalProvider(IProject project, int scope, IValueFilter valueFilter) {
        this.fProject = project;
        this.fTypeScope = scope;
        this.fComparator = new TypeComparator();
        this.valueFilter = valueFilter;
        this.reset();
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList currentContentProposals = null;
        currentContentProposals = position == 0 ? null : (this.fInitialContentProposals == null || !contents.startsWith(this.fInitialContent) || this.endsWithDot(contents) ? this.generateContentProposals(contents.substring(0, position)) : this.filterContentProposals(contents));
        currentContentProposals = this.filterContentProposalsByValueFilter(currentContentProposals);
        return this.convertResultsToSortedProposals(currentContentProposals);
    }

    public void reset() {
        this.fInitialContentProposals = null;
    }

    protected void addProposalToCollection(Collection collection, int startOffset, int length, String label, String content, Image image) {
        TypeContentProposal proposal = new TypeContentProposal(label, content, null, image);
        collection.add(proposal);
    }

    private boolean endsWithDot(String string) {
        int index = string.lastIndexOf(46);
        return index + 1 == string.length();
    }

    private ArrayList generateContentProposals(String currentContent) {
        this.fInitialContentProposals = new ArrayList();
        this.fInitialContent = currentContent;
        this.generateTypePackageProposals(currentContent, this.fProject, this.fInitialContentProposals, 0, this.fTypeScope, true);
        return this.fInitialContentProposals;
    }

    private IContentProposal[] convertResultsToSortedProposals(ArrayList list) {
        IContentProposal[] proposals = null;
        if (list != null && list.size() != 0) {
            proposals = list.toArray(new IContentProposal[list.size()]);
            Arrays.sort(proposals, this.fComparator);
        } else {
            proposals = new IContentProposal[]{};
        }
        return proposals;
    }

    private ArrayList filterContentProposals(String currentContent) {
        String lowerCaseCurrentContent = currentContent.toLowerCase();
        ListIterator iterator = this.fInitialContentProposals.listIterator();
        ArrayList<IContentProposal> filteredContentProposals = new ArrayList<IContentProposal>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            IContentProposal proposal = (IContentProposal)object;
            String compareString = null;
            compareString = lowerCaseCurrentContent.indexOf(46) == -1 ? proposal.getLabel().toLowerCase() : proposal.getContent().toLowerCase();
            if (!compareString.startsWith(lowerCaseCurrentContent, 0)) continue;
            filteredContentProposals.add(proposal);
        }
        return filteredContentProposals;
    }

    private ArrayList filterContentProposalsByValueFilter(ArrayList filteredContentProposals) {
        if (this.valueFilter != null && filteredContentProposals != null) {
            ArrayList<IContentProposal> filteredContentProposals2 = new ArrayList<IContentProposal>();
            ListIterator iterator = filteredContentProposals.listIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                IContentProposal proposal = (IContentProposal)object;
                String value = proposal.getContent();
                if (!this.valueFilter.accept(value)) continue;
                filteredContentProposals2.add(proposal);
            }
            filteredContentProposals = filteredContentProposals2;
        }
        return filteredContentProposals;
    }

    private static class TypeComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            String proposalSortKey1 = ((IContentProposal)arg0).getLabel();
            String proposalSortKey2 = ((IContentProposal)arg1).getLabel();
            return proposalSortKey1.compareToIgnoreCase(proposalSortKey2);
        }
    }
}

