/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.core.resources.XModelObjectEditorInputFactory;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.ui.editor.ModelObjectEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;

public class ModelObjectStorageEditorInput
extends ModelObjectEditorInput
implements IStorageEditorInput {
    JarEntryFile jarEntryFile = null;
    IStorage storage = new Storage();

    public ModelObjectStorageEditorInput(XModelObject object) {
        super(object);
        this.jarEntryFile = this.findJarEntryFile();
    }

    public IStorage getStorage() throws CoreException {
        return this.jarEntryFile != null ? this.jarEntryFile : this.storage;
    }

    JarEntryFile findJarEntryFile() {
        XModelObject o = this.object;
        JarEntryFile f = null;
        JarEntryFile current = null;
        String packageName = "";
        while (o != null && o.getFileType() != 3) {
            String part;
            String string = o.getFileType() == 1 ? FileAnyImpl.toFileName((XProperty)o) : (part = o.getFileType() == 2 ? o.getAttributeValue("name") : null);
            if (part != null) {
                if (f == null) {
                    current = f = new JarEntryFile(part){

                        public InputStream getContents() throws CoreException {
                            return ModelObjectStorageEditorInput.this.storage.getContents();
                        }
                    };
                } else {
                    if (f == null) {
                        // empty if block
                    }
                    packageName = packageName.length() > 0 ? String.valueOf(part) + "." + packageName : part;
                    JarEntryDirectory d = new JarEntryDirectory(part);
                    current.setParent((Object)d);
                    current = d;
                }
            }
            o = o.getParent();
        }
        if (!(o instanceof JarSystemImpl)) {
            return null;
        }
        String file = ((JarSystemImpl)o).getLocation();
        IProject p = EclipseResourceUtil.getProject((XModelObject)o);
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)p);
        if (jp == null) {
            return null;
        }
        IPackageFragmentRoot root = jp.getPackageFragmentRoot(file);
        if (root == null) {
            return null;
        }
        try {
            file = new File(file).getCanonicalPath();
        }
        catch (IOException iOException) {}
        if (current != null && !"META-INF".equalsIgnoreCase(current.getName()) && packageName.length() > 0) {
            IPackageFragment pf = root.getPackageFragment(packageName);
            f.setParent((Object)pf);
        } else {
            current.setParent((Object)root);
        }
        return f;
    }

    protected boolean isEditable() {
        return false;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof IStorageEditorInput) {
            String[] entryInfo;
            try {
                IStorage st = ((IStorageEditorInput)o).getStorage();
                if (this.jarEntryFile != null && this.jarEntryFile.equals((Object)st)) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            if ((entryInfo = XModelObjectEditorInput.parseJarEntryFileInput((IStorageEditorInput)o)) == null) {
                return false;
            }
            XModelObject mo = XModelObjectEditorInput.getJarEntryObject(null, entryInfo[0], entryInfo[1]);
            return mo != null && mo.equals(this.object);
        }
        return false;
    }

    class Storage
    implements IStorage {
        Storage() {
        }

        public InputStream getContents() throws CoreException {
            ByteArrayInputStream b = null;
            if (ModelObjectStorageEditorInput.this.object instanceof FileAnyImpl) {
                FileAnyImpl f = (FileAnyImpl)ModelObjectStorageEditorInput.this.object;
                String s = f.getAsText();
                String encoding = FileUtil.getEncoding((String)s);
                byte[] bs = null;
                if (encoding == null) {
                    bs = s.getBytes();
                } else {
                    try {
                        bs = s.getBytes(encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bs = s.getBytes();
                    }
                }
                b = new ByteArrayInputStream(bs);
            } else {
                b = new ByteArrayInputStream(new byte[0]);
            }
            return b;
        }

        public IPath getFullPath() {
            IProject p = EclipseResourceUtil.getProject((XModelObject)ModelObjectStorageEditorInput.this.object);
            if (p == null) {
                String location = XModelObjectEditorInputFactory.getFileLocation(ModelObjectStorageEditorInput.this.object);
                if (location != null) {
                    return new Path(location);
                }
            } else {
                IResource jar;
                XModelObject f = ModelObjectStorageEditorInput.this.object;
                while (f != null && f.getFileType() != 3) {
                    f = f.getParent();
                }
                if (f != null && (jar = EclipseResourceUtil.getResource((XModelObject)f)) != null) {
                    return jar.getFullPath();
                }
            }
            String n = p == null ? "" : p.getName();
            return new Path(String.valueOf(n) + "/" + ModelObjectStorageEditorInput.this.object.getPath());
        }

        public String getName() {
            return ModelObjectStorageEditorInput.this.getName();
        }

        public boolean isReadOnly() {
            return !ModelObjectStorageEditorInput.this.isEditable();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ILocationProvider.class && ModelObjectStorageEditorInput.this instanceof ILocationProvider) {
                return (ILocationProvider)ModelObjectStorageEditorInput.this;
            }
            return ModelObjectStorageEditorInput.this.getAdapter(adapter);
        }
    }
}

