/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors;

import java.util.Properties;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.texteditors.ITextProvider;
import org.jboss.tools.common.model.util.XModelObjectCache;

public class TextEditorSupport {
    protected XModelObjectCache object = null;
    protected int lock = 0;
    private boolean modified = false;
    protected ITextProvider provider;
    protected long timeStamp = -1L;

    public void setProvider(ITextProvider provider) {
        this.provider = provider;
    }

    public void setObject(XModelObject object) {
        this.object = new XModelObjectCache(object);
        this.update();
    }

    public XModelObject getModelObject() {
        return this.object == null ? null : this.object.getObject();
    }

    public void update() {
        if (this.lock > 0) {
            return;
        }
        if (!this.needsUpdate()) {
            return;
        }
        ++this.lock;
        try {
            String content = this.loadContent();
            if (this.provider.isEqualText(content)) {
                return;
            }
            this.provider.setText(content);
            this.setModified(false);
        }
        finally {
            --this.lock;
        }
    }

    protected String loadContent() {
        XModelObject o = this.getModelObject();
        return ((FileAnyImpl)o).getAsText();
    }

    public void setModified(boolean set) {
        if (this.modified == set) {
            return;
        }
        this.modified = set;
        XModelObject o = this.getModelObject();
        if (o != null && set) {
            o.setModified(true);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean canSave(boolean force) {
        return this.lock == 0 && (this.modified || force);
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean force) {
        if (!this.canSave(force)) {
            return;
        }
        ++this.lock;
        try {
            try {
                FileAnyImpl f = (FileAnyImpl)this.getModelObject();
                if (f != null) {
                    f.edit(this.provider.getText());
                }
            }
            catch (XModelException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
                --this.lock;
                this.modified = false;
            }
        }
        finally {
            --this.lock;
            this.modified = false;
        }
    }

    protected boolean needsUpdate() {
        XModelObject o;
        XModelObject xModelObject = o = this.object == null ? null : this.object.getObject();
        if (o == null) {
            return false;
        }
        long ts = o.getTimeStamp();
        if (this.timeStamp == ts) {
            return false;
        }
        this.timeStamp = ts;
        return true;
    }

    public boolean canRevertToSaved() {
        XModelObject o = this.getModelObject();
        if (o == null || !o.isActive()) {
            return false;
        }
        XAction a = o.getModelEntity().getActionList().getAction("DiscardActions.Discard");
        return a != null && a.isEnabled(o);
    }

    public void revertToSaved() {
        XModelObject o = this.getModelObject();
        if (o != null) {
            XActionInvoker.invoke((String)"DiscardActions.Discard", (XModelObject)o, (Properties)new Properties());
        }
    }
}

