/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets;

import java.util.HashMap;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.common.model.ui.Insets;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.border.Border;
import org.jboss.tools.common.model.ui.widgets.border.FormControlBorder;

public class DefaultSettings
implements IWidgetSettings {
    private HashMap<String, Object> settings = new HashMap();
    private static IWidgetSettings defaultSettings;
    protected Color redBackground;
    protected Color whiteBackground;
    protected Color defaultBackground;
    protected Color defaultForeground;
    protected Color hyperlinkColor;
    protected Color activeHyperlinkColor;
    protected Font defaultFont;
    protected Font headerFont;
    protected Font titleFont;
    protected Cursor defaultCursor;
    protected Cursor handCursor;
    protected Border defaultBorder;

    public static IWidgetSettings getDefault() {
        if (defaultSettings == null) {
            defaultSettings = new DefaultSettings();
        }
        return defaultSettings;
    }

    protected void initColors() {
        this.defaultBackground = Display.getCurrent().getSystemColor(22);
        this.defaultForeground = Display.getCurrent().getSystemColor(21);
        this.whiteBackground = Display.getCurrent().getSystemColor(1);
        this.redBackground = Display.getCurrent().getSystemColor(3);
        this.hyperlinkColor = JFaceColors.getHyperlinkText((Display)Display.getCurrent());
        this.activeHyperlinkColor = JFaceColors.getActiveHyperlinkText((Display)Display.getCurrent());
    }

    protected void initFonts() {
        this.defaultFont = JFaceResources.getDefaultFont();
        this.headerFont = JFaceResources.getBannerFont();
        this.titleFont = JFaceResources.getHeaderFont();
    }

    protected void initCursors() {
        this.defaultCursor = new Cursor((Device)Display.getCurrent(), 0);
        this.handCursor = new Cursor((Device)Display.getCurrent(), 21);
    }

    protected void initBorders() {
        this.defaultBorder = new FormControlBorder(new Insets(0, 0, 0, 0));
    }

    protected void initSettings() {
        this.put("Control.Style", 0);
        this.put("Control.Background", this.defaultBackground);
        this.put("Control.Foreground", this.defaultForeground);
        this.put("Control.Font", this.defaultFont);
        this.put("Composite.Style", 0);
        this.put("Composite.Background", this.defaultBackground);
        this.put("Composite.Foreground", this.defaultForeground);
        this.put("Composite.Font", this.defaultFont);
        this.put("Label.Style", 0);
        this.put("Label.Background", this.defaultBackground);
        this.put("Label.Foreground", this.defaultForeground);
        this.put("Label.Font", this.defaultFont);
        this.put("Label.Font.Title", this.titleFont);
        this.put("Label.Font.Header", this.headerFont);
        this.put("Hyperlink.Style", 0);
        this.put("Hyperlink.Background", this.defaultBackground);
        this.put("Hyperlink.Foreground", this.hyperlinkColor);
        this.put("Hyperlink.ActiveColor", this.activeHyperlinkColor);
        this.put("Hyperlink.Font", this.defaultFont);
        this.put("Hyperlink.ActiveCursor", this.handCursor);
        this.put("Hyperlink.Disabled", this.defaultForeground);
        this.put("Text.Style", 2048);
        this.put("Text.Background", this.whiteBackground);
        this.put("Text.Foreground", this.defaultForeground);
        this.put("Text.Font", this.defaultFont);
        this.put("Note.Style", 2818);
        this.put("Note.Background", this.whiteBackground);
        this.put("Note.Foreground", this.defaultForeground);
        this.put("Note.Font", this.defaultFont);
        this.put("Note.ValidateStrategy", 0);
        this.put("Combo.Style", 2048);
        this.put("Combo.Background", this.whiteBackground);
        this.put("Combo.Background.Disabled", this.defaultBackground);
        this.put("Combo.Foreground", this.defaultForeground);
        this.put("Combo.Font", this.defaultFont);
        this.put("Button.Style", 8);
        this.put("Button.Background", this.defaultBackground);
        this.put("Button.Foreground", this.defaultForeground);
        this.put("Button.Font", this.defaultFont);
        this.put("CheckBox.Style", 32);
        this.put("CheckBox.Background", this.defaultBackground);
        this.put("CheckBox.Foreground", this.defaultForeground);
        this.put("CheckBox.Font", this.defaultFont);
        this.put("List.Style", 2048);
        this.put("List.Background", this.whiteBackground);
        this.put("List.Foreground", this.defaultForeground);
        this.put("List.Font", this.defaultFont);
        this.put("Tree.Style", 2048);
        this.put("Tree.Background", this.whiteBackground);
        this.put("Tree.Foreground", this.defaultForeground);
        this.put("Tree.Font", this.defaultFont);
        this.put("Table.Style", 2048);
        this.put("Table.Background", this.whiteBackground);
        this.put("Table.Foreground", this.defaultForeground);
        this.put("Table.Font", this.defaultFont);
    }

    public DefaultSettings() {
        this.initColors();
        this.initFonts();
        this.initCursors();
        this.initBorders();
        this.initSettings();
    }

    public Object getObject(String key) {
        return this.settings.get(key);
    }

    public int getInt(String key) {
        Integer integer = (Integer)this.settings.get(key);
        if (integer != null) {
            return integer;
        }
        return -1;
    }

    public int getStyle(String key) {
        Integer integer = (Integer)this.settings.get(key);
        if (integer != null) {
            return integer;
        }
        return 0;
    }

    public Color getColor(String key) {
        Color color = (Color)this.settings.get(key);
        if (color == null) {
            color = this.redBackground;
        }
        return color;
    }

    public Font getFont(String key) {
        Font font = (Font)this.settings.get(key);
        if (font == null) {
            font = this.defaultFont;
        }
        return font;
    }

    public Border getBorder(String key) {
        Border border = (Border)this.settings.get(key);
        if (border == null) {
            border = this.defaultBorder;
        }
        return border;
    }

    public Cursor getCursor(String key) {
        Cursor cursor = (Cursor)this.settings.get(key);
        if (cursor == null) {
            cursor = this.defaultCursor;
        }
        return cursor;
    }

    protected void put(String key, Object object) {
        this.settings.put(key, object);
    }

    protected void put(String key, int i) {
        this.settings.put(key, i);
    }

    protected void put(String key, Color color) {
        this.settings.put(key, color);
    }

    protected void put(String key, Font font) {
        this.settings.put(key, font);
    }

    protected void put(String key, Border border) {
        this.settings.put(key, border);
    }

    protected void put(String key, Cursor cursor) {
        this.settings.put(key, cursor);
    }

    public void setupControl(Control control) {
        FormToolkit toolkit = this.getToolkit(control.getDisplay());
        if (control instanceof Composite) {
            toolkit.adapt((Composite)control);
        }
        if (control instanceof CCombo || control instanceof Combo) {
            control.setBackground(this.getColor("Combo.Background"));
            control.setForeground(this.getColor("Combo.Foreground"));
            control.setFont(this.getFont("Combo.Font"));
        } else if (control instanceof Label) {
            control.setBackground(this.getColor("Label.Background"));
            control.setForeground(this.getColor("Label.Foreground"));
            control.setFont(this.getFont("Label.Font"));
        } else if (control instanceof Text) {
            control.setBackground(this.getColor("Text.Background"));
            control.setForeground(this.getColor("Text.Foreground"));
            control.setFont(this.getFont("Text.Font"));
        } else if (control instanceof Button) {
            control.setBackground(this.getColor("Button.Background"));
            control.setForeground(this.getColor("Button.Foreground"));
            control.setFont(this.getFont("Button.Font"));
        } else if (control instanceof List) {
            control.setBackground(this.getColor("List.Background"));
            control.setForeground(this.getColor("List.Foreground"));
            control.setFont(this.getFont("List.Font"));
        } else if (control instanceof Tree) {
            control.setBackground(this.getColor("Tree.Background"));
            control.setForeground(this.getColor("Tree.Foreground"));
            control.setFont(this.getFont("Tree.Font"));
        } else if (control instanceof Table) {
            control.setBackground(this.getColor("Table.Background"));
            control.setForeground(this.getColor("Table.Foreground"));
            control.setFont(this.getFont("Table.Font"));
        } else if (control instanceof Composite) {
            control.setBackground(this.getColor("Composite.Background"));
            control.setForeground(this.getColor("Composite.Foreground"));
            control.setFont(this.getFont("Composite.Font"));
        } else {
            control.setBackground(this.getColor("Control.Background"));
            control.setForeground(this.getColor("Control.Foreground"));
            control.setFont(this.getFont("Control.Font"));
        }
    }

    public FormToolkit getToolkit(Display display) {
        return null;
    }
}

