/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class NewTypeWizardAdapter {
    private IJavaProject javaProject;
    private IProject project;
    private boolean rawData = Boolean.TRUE;
    private boolean createMain = Boolean.TRUE;
    private boolean createConstructors = Boolean.TRUE;
    private boolean createInherited = Boolean.TRUE;
    private boolean canBeModified = Boolean.TRUE;
    private IStatus classNameStatus;
    private IStatus packageNameStatus;
    private HashSet<String> rawInterfaces = new HashSet();
    private String superClassName;
    private String className;
    private String packageName;
    private IPackageFragmentRoot packageFragmentRoot;
    private IPackageFragment packageFragment;
    private ArrayList<String> interfaces = new ArrayList();

    private NewTypeWizardAdapter() {
    }

    public NewTypeWizardAdapter(IProject project) {
        if (project != null) {
            try {
                this.javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        this.project = project;
    }

    public void setRawClassName(String rawClassName) {
        this.rawData = Boolean.TRUE;
        this.className = rawClassName;
    }

    public void setRawSuperClassName(String rawSuperClassName) {
        this.rawData = Boolean.TRUE;
        this.superClassName = rawSuperClassName;
    }

    public void setRawPackageName(String rawPackageName) {
        this.rawData = Boolean.TRUE;
        this.packageName = rawPackageName;
    }

    public void addRawInterfaceName(String rawInterfaceName) {
        this.rawData = Boolean.TRUE;
        this.rawInterfaces.add(rawInterfaceName);
    }

    public void setCanBeModified(boolean canBeModified) {
        this.canBeModified = canBeModified;
    }

    public void setCreateConstructors(boolean createConstructors) {
        this.createConstructors = createConstructors;
    }

    public void setCreateInherited(boolean createInherited) {
        this.createInherited = createInherited;
    }

    public void setCreateMain(boolean createMain) {
        this.createMain = createMain;
    }

    private void doAdapted() {
        int loc = this.className.indexOf(":");
        if (loc != -1) {
            if (loc < this.className.length()) {
                this.className = this.className.substring(0, loc);
            }
            if (loc > 0) {
                this.className = this.className.substring(0, loc);
            } else if (loc == 0) {
                this.className = "";
            }
        }
        this.classNameStatus = JavaConventions.validateJavaTypeName((String)this.className);
        loc = this.className.lastIndexOf(46);
        if (loc != -1) {
            this.packageName = this.className.substring(0, loc);
            this.className = this.className.substring(loc + 1);
            this.packageNameStatus = JavaConventions.validatePackageName((String)this.packageName);
            this.classNameStatus = JavaConventions.validateJavaTypeName((String)this.className);
        }
        if (this.javaProject == null) {
            return;
        }
        try {
            if (this.packageFragmentRoot == null) {
                IPackageFragmentRoot srcEntryDft = null;
                IPackageFragmentRoot[] roots = this.javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        srcEntryDft = roots[i];
                        break;
                    }
                    ++i;
                }
                this.packageFragmentRoot = srcEntryDft != null ? srcEntryDft : this.javaProject.getPackageFragmentRoot(this.javaProject.getResource());
                if (this.packageFragment == null && this.packageFragmentRoot != null && this.packageName != null && this.packageName.length() > 0) {
                    IFolder packageFolder = this.project.getFolder(this.packageName);
                    this.packageFragment = this.packageFragmentRoot.getPackageFragment(packageFolder.getProjectRelativePath().toOSString());
                }
            }
            if (this.rawInterfaces != null && this.rawInterfaces.size() > 0) {
                Iterator<String> i = this.rawInterfaces.iterator();
                this.interfaces.clear();
                while (i.hasNext()) {
                    String _interface = i.next();
                    this.interfaces.add(_interface);
                }
            }
            if (this.superClassName != null) {
                this.superClassName.length();
            }
            this.rawData = Boolean.FALSE;
        }
        catch (JavaModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.packageFragmentRoot;
    }

    public IPackageFragment getPackageFragment() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.packageFragment;
    }

    public IType getEnclosingType() {
        if (this.rawData) {
            this.doAdapted();
        }
        return null;
    }

    public boolean getEnclosingTypeSelection() {
        if (this.rawData) {
            this.doAdapted();
        }
        return Boolean.FALSE;
    }

    public String getTypeName() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.className;
    }

    public String getSuperClass() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.superClassName;
    }

    public List getSuperInterfaces() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.interfaces;
    }

    public boolean isCreateMain() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.createMain;
    }

    public boolean isCreateConstructors() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.createConstructors;
    }

    public boolean isCreateInherited() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.createInherited;
    }

    public boolean isCanBeModified() {
        if (this.rawData) {
            this.doAdapted();
        }
        return this.canBeModified;
    }

    public IStatus getClassNameStatus() {
        return this.classNameStatus;
    }

    public IStatus getPackageNameStatus() {
        return this.packageNameStatus;
    }
}

