/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.xpl;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeViewer;

public class XMLFormEditorPart
extends FormEditor {
    private StructuredTextEditor textEditor;
    private IDesignViewer designViewer;
    private PropertyListener propertyListener;
    private int designPageIndex;
    private int sourcePageIndex;

    protected void addPages() {
        try {
            this.createSourcePage();
            this.createAndAddDesignPage();
            this.addSourcePage();
            this.connectDesignPage();
        }
        catch (PartInitException e) {
            throw new RuntimeException(e);
        }
    }

    private void connectDesignPage() {
        if (this.designViewer != null) {
            this.designViewer.setDocument(this.getDocument());
        }
    }

    private void createAndAddDesignPage() {
        IDesignViewer tableTreeViewer;
        this.designViewer = tableTreeViewer = this.createDesignPage();
        this.designPageIndex = this.addPage(tableTreeViewer.getControl());
        this.setPageText(this.designPageIndex, tableTreeViewer.getTitle());
    }

    protected IDesignViewer createDesignPage() {
        XMLTableTreeViewer tableTreeViewer = new XMLTableTreeViewer(this.getContainer());
        XMLUIPlugin.getInstance().getWorkbench().getHelpSystem().setHelp(tableTreeViewer.getControl(), "org.eclipse.wst.xml.ui.xmlm3000");
        return tableTreeViewer;
    }

    protected void createSourcePage() throws PartInitException {
        this.textEditor = this.createTextEditor();
        this.textEditor.setEditorPart((IEditorPart)this);
        if (this.propertyListener == null) {
            this.propertyListener = new PropertyListener();
        }
        this.textEditor.addPropertyListener((IPropertyListener)this.propertyListener);
    }

    private StructuredTextEditor createTextEditor() {
        return new StructuredTextEditor();
    }

    StructuredTextEditor getTextEditor() {
        return this.textEditor;
    }

    private void addSourcePage() throws PartInitException {
        try {
            this.sourcePageIndex = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(this.sourcePageIndex, XMLEditorMessages.XMLMultiPageEditorPart_0);
            this.textEditor.update();
            this.firePropertyChange(1);
            this.textEditor.getTextViewer().addTextInputListener((ITextInputListener)new TextInputListener());
        }
        catch (PartInitException exception) {
            this.dispose();
            throw exception;
        }
    }

    private IStructuredModel getModel() {
        IStructuredModel model = null;
        if (this.textEditor != null) {
            model = this.textEditor.getModel();
        }
        return model;
    }

    public void doSave(IProgressMonitor monitor) {
        this.textEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.textEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.textEditor.isSaveAsAllowed();
    }

    void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    void postOnDisplayQue(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    void gotoMarker(IMarker marker) {
        this.setActivePage(this.sourcePageIndex);
        IDE.gotoMarker((IEditorPart)this.textEditor, (IMarker)marker);
    }

    public Object getAdapter(Class key) {
        Object result = null;
        if (key == IDesignViewer.class) {
            result = this.designViewer;
        } else if (key.equals(IGotoMarker.class)) {
            result = new IGotoMarker(){

                public void gotoMarker(IMarker marker) {
                    XMLFormEditorPart.this.gotoMarker(marker);
                }
            };
        } else if (this.textEditor != null) {
            result = this.textEditor.getAdapter(key);
        }
        if (result == null) {
            return super.getAdapter(key);
        }
        return result;
    }

    private IDocument getDocument() {
        IDocument document = null;
        if (this.textEditor != null) {
            document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        }
        return document;
    }

    class PropertyListener
    implements IPropertyListener {
        PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 257: 
                case 258: {
                    if (source != XMLFormEditorPart.this.getTextEditor() || XMLFormEditorPart.this.getTextEditor().getEditorInput() == XMLFormEditorPart.this.getEditorInput()) break;
                    XMLFormEditorPart.this.setInput(XMLFormEditorPart.this.getTextEditor().getEditorInput());
                    Runnable runnable = new Runnable(){

                        public void run() {
                            XMLFormEditorPart.this._firePropertyChange(1);
                        }
                    };
                    XMLFormEditorPart.this.postOnDisplayQue(runnable);
                    break;
                }
                case 1: {
                    if (source != XMLFormEditorPart.this.getTextEditor() || XMLFormEditorPart.this.getTextEditor().getEditorInput() == XMLFormEditorPart.this.getEditorInput()) break;
                    XMLFormEditorPart.this.setInput(XMLFormEditorPart.this.getTextEditor().getEditorInput());
                    break;
                }
                default: {
                    if (source != XMLFormEditorPart.this.getTextEditor()) break;
                    XMLFormEditorPart.this._firePropertyChange(propId);
                }
            }
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (XMLFormEditorPart.this.designViewer != null && newInput != null) {
                XMLFormEditorPart.this.designViewer.setDocument(newInput);
            }
        }
    }
}

