/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.plugin.eclipse.util.MutexSchedulingRule;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class FindBugsJob
extends Job {
    public FindBugsJob(String name, IProject project) {
        super(name);
        this.setRule(new MutexSchedulingRule(project));
    }

    public boolean belongsTo(Object family) {
        return FindbugsPlugin.class == family;
    }

    public void scheduleInteractive() {
        this.setUser(true);
        this.setPriority(10);
        this.schedule();
    }

    protected String createErrorMessage() {
        return this.getName() + " failed";
    }

    protected abstract void runWithProgress(IProgressMonitor var1) throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        try {
            this.runWithProgress(monitor);
        }
        catch (OperationCanceledException e) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (CoreException ex) {
            FindbugsPlugin.getDefault().logException(ex, this.createErrorMessage());
            IStatus iStatus = ex.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

