/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindBugsJob;
import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.builder.WorkItem;
import de.tobject.findbugs.reporter.MarkerUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsAction
implements IObjectActionDelegate {
    protected ISelection selection;
    protected boolean usedInEditor;
    protected IWorkbenchPart targetPart;
    private volatile int jobsRunning;
    private volatile boolean dialogAlreadyShown;

    public final void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public boolean isFindBugsPerspectiveActive() {
        IPerspectiveDescriptor perspective = this.getWindow().getActivePage().getPerspective();
        return perspective != null && "de.tobject.findbugs.FindBugsPerspective".equals(perspective.getId());
    }

    public final void selectionChanged(IAction action, ISelection newSelection) {
        if (!this.usedInEditor) {
            this.selection = newSelection;
        }
    }

    public void run(IAction action) {
        if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)this.selection;
            if (this.selection.isEmpty()) {
                return;
            }
            this.dialogAlreadyShown = false;
            Map<IProject, List<WorkItem>> projectMap = ResourceUtils.getResourcesPerProject(sSelection);
            this.jobsRunning = projectMap.size();
            for (Map.Entry<IProject, List<WorkItem>> e : projectMap.entrySet()) {
                this.work(e.getKey(), e.getValue());
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        String settingsId;
        IDialogSettings settings = FindbugsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(settingsId = this.getDialogSettingsId());
        if (section == null) {
            section = settings.addNewSection(settingsId);
        }
        return section;
    }

    protected final IProject getProject(IStructuredSelection structuredSelection) {
        Object element = structuredSelection.getFirstElement();
        IResource resource = ResourceUtils.getResource(element);
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        return project;
    }

    protected String getDialogSettingsId() {
        return "findBugsAction";
    }

    protected void work(IProject project, List<WorkItem> resources) {
        StartedFromViewJob runFindBugs = new StartedFromViewJob("Finding bugs in " + project.getName() + "...", project, resources);
        runFindBugs.scheduleInteractive();
    }

    protected void refreshViewer(final List<WorkItem> resources) {
        if (this.targetPart == null) {
            return;
        }
        ISelectionProvider selProvider = (ISelectionProvider)this.targetPart.getAdapter(ISelectionProvider.class);
        if (!(selProvider instanceof TreeViewer)) {
            return;
        }
        final TreeViewer viewer = (TreeViewer)selProvider;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                for (WorkItem workItem : resources) {
                    if (!(workItem.getMarkerTarget() instanceof IProject)) continue;
                    viewer.refresh((Object)workItem.getCorespondingJavaElement(), true);
                }
            }
        });
    }

    protected void askUserToSwitch(int warningsNumber) {
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        String message = "FindBugs analysis finished, " + warningsNumber + " warnings found.\n\nSwitch to the FindBugs perspective?";
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion(null, (String)"FindBugs analysis finished", (String)message, (String)"Remember the choice and do not ask me in the feature", (boolean)false, (IPreferenceStore)store, (String)"askAboutPerspectiveSwitch");
        boolean remember = dialog.getToggleState();
        int returnCode = dialog.getReturnCode();
        if (returnCode == 2) {
            if (remember) {
                store.setValue("switchPerspectiveAfterAnalysis", true);
            }
            this.switchPerspective();
        } else if (returnCode == 3 && remember) {
            store.setValue("switchPerspectiveAfterAnalysis", false);
        }
    }

    protected IWorkbenchWindow getWindow() {
        IWorkbenchPartSite currentSite = this.targetPart != null ? this.targetPart.getSite() : null;
        IWorkbenchWindow window = currentSite != null ? currentSite.getWorkbenchWindow() : FindbugsPlugin.getActiveWorkbenchWindow();
        return window;
    }

    protected void switchPerspective() {
        IWorkbenchWindow window = this.getWindow();
        IWorkbenchPage page = window.getActivePage();
        Object input = page != null ? page.getInput() : ResourcesPlugin.getWorkspace().getRoot();
        try {
            PlatformUI.getWorkbench().showPerspective("de.tobject.findbugs.FindBugsPerspective", window, input);
        }
        catch (WorkbenchException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to open FindBugs Perspective");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StartedFromViewJob
    extends FindBugsJob {
        private final List<WorkItem> resources;
        private final IProject project;

        private StartedFromViewJob(String name, IProject project, List<WorkItem> resources) {
            super(name, project);
            this.resources = resources;
            this.project = project;
        }

        @Override
        protected void runWithProgress(IProgressMonitor monitor) throws CoreException {
            FindBugsWorker worker = new FindBugsWorker(this.project, monitor);
            worker.work(this.resources);
            FindBugsAction.this.refreshViewer(this.resources);
            this.checkPerspective();
            FindBugsAction.this.jobsRunning--;
            if (FindBugsAction.this.jobsRunning == 0) {
                FindBugsAction.this.targetPart = null;
                FindBugsAction.this.selection = null;
            }
        }

        private void checkPerspective() {
            if (FindBugsAction.this.isFindBugsPerspectiveActive()) {
                return;
            }
            final IMarker[] allMarkers = MarkerUtil.getAllMarkers((IResource)this.project);
            if (allMarkers.length == 0) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (FindBugsAction.this.isFindBugsPerspectiveActive()) {
                        return;
                    }
                    IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
                    boolean ask = store.getBoolean("askAboutPerspectiveSwitch");
                    if (ask && !FindBugsAction.this.dialogAlreadyShown) {
                        FindBugsAction.this.dialogAlreadyShown = true;
                        FindBugsAction.this.askUserToSwitch(allMarkers.length);
                    } else if (store.getBoolean("switchPerspectiveAfterAnalysis")) {
                        FindBugsAction.this.switchPerspective();
                    }
                }
            });
        }
    }
}

