/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.view.BugExplorerView;
import de.tobject.findbugs.view.explorer.BugGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonViewer;

public class GoIntoAction
implements IViewActionDelegate {
    private BugExplorerView navigator;
    private Object selectedElement;

    public void init(IViewPart view) {
        if (view instanceof BugExplorerView) {
            this.navigator = (BugExplorerView)view;
        }
    }

    public void run(IAction action) {
        if (action.isEnabled() && this.navigator != null && this.selectedElement != null) {
            CommonViewer viewer = this.navigator.getCommonViewer();
            Object[] expandedElements = viewer.getVisibleExpandedElements();
            viewer.setInput(this.selectedElement);
            viewer.setExpandedElements(expandedElements);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() != 1) {
            action.setEnabled(false);
            return;
        }
        Object element = ssel.getFirstElement();
        if (!(element instanceof BugGroup)) {
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
        this.selectedElement = element;
    }
}

