/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.GroupSelectionDialog;
import de.tobject.findbugs.view.explorer.GroupType;
import de.tobject.findbugs.view.explorer.Grouping;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class OpenGroupDialogAction
implements IViewActionDelegate {
    private CommonNavigator navigator;

    public void init(IViewPart view) {
        if (view instanceof CommonNavigator) {
            this.navigator = (CommonNavigator)view;
        }
    }

    public void run(IAction action) {
        if (this.navigator == null) {
            return;
        }
        BugContentProvider provider = BugContentProvider.getProvider(this.navigator.getNavigatorContentService());
        List<GroupType> list = provider.getGrouping().asList();
        GroupSelectionDialog dialog = new GroupSelectionDialog(this.navigator.getSite().getShell(), list);
        dialog.setTitle("Bug Group Configuration");
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Grouping grouping = Grouping.createFrom(dialog.getGroups());
        if (grouping == null) {
            return;
        }
        provider.setGrouping(grouping);
        CommonViewer viewer = this.navigator.getCommonViewer();
        Object[] expandedElements = viewer.getExpandedElements();
        provider.reSetInput();
        viewer.setExpandedElements(expandedElements);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.navigator == null) {
            action.setEnabled(false);
            return;
        }
        BugContentProvider provider = BugContentProvider.getProvider(this.navigator.getNavigatorContentService());
        action.setEnabled(provider.getGrouping() != null);
    }
}

