/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.preferences;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.preferences.FindBugsConstants;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.Set;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public class FindBugsPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        store.setDefault("exportSortOrder", "byName");
        store.setDefault("dontRemindAboutFullBuild", false);
        store.setDefault("disabledCategories", "EXPERIMENTAL,I18N,MALICIOUS_CODE,SECURITY");
        store.setDefault("runAnalysisAutomatically", false);
        store.setDefault("runAnalysisOnFullBuild", false);
        store.setDefault("askAboutPerspectiveSwitch", true);
        store.setDefault("switchPerspectiveAfterAnalysis", true);
    }

    public static UserPreferences createDefaultUserPreferences() {
        UserPreferences prefs = UserPreferences.createDefaultUserPreferences();
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        String categoriesStr = store.getString("disabledCategories");
        Set<String> ids = FindBugsConstants.decodeIds(categoriesStr);
        for (String categoryId : ids) {
            prefs.getFilterSettings().removeCategory(categoryId);
        }
        prefs.setRunAtFullBuild(false);
        return prefs;
    }

    public static void restoreDefaults(IPreferenceStore store) {
        store.setToDefault("exportSortOrder");
        store.setToDefault("dontRemindAboutFullBuild");
        store.setToDefault("disabledCategories");
        store.setToDefault("runAnalysisAutomatically");
        store.setToDefault("runAnalysisOnFullBuild");
        store.setToDefault("askAboutPerspectiveSwitch");
        store.setToDefault("switchPerspectiveAfterAnalysis");
    }
}

