/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.util;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.util.Strings;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;

public class ConfigurableXmlOutputStream
implements XMLOutput {
    private static final String OPENING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private final Writer out;
    private int nestingLevel;
    private boolean newLine;
    private final boolean plainText;

    public ConfigurableXmlOutputStream(OutputStream os, boolean plainText) {
        this.plainText = plainText;
        this.out = new OutputStreamWriter(os, Charset.forName("UTF-8"));
        this.nestingLevel = 0;
        this.newLine = true;
    }

    public void beginDocument() throws IOException {
        if (!this.plainText) {
            this.out.write(OPENING);
        }
        this.out.write("\n");
        this.newLine = true;
    }

    public void openTag(String tagName) throws IOException {
        this.emitTag(tagName, false);
    }

    public void openTag(String tagName, XMLAttributeList attributeList) throws IOException {
        if (!this.plainText) {
            this.emitTag(tagName, attributeList.toString(), false);
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<XMLAttributeList.NameValuePair> iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                XMLAttributeList.NameValuePair nameValuePair = iterator.next();
                sb.append("\n");
                for (int i = 0; i < this.nestingLevel; ++i) {
                    sb.append("  ");
                }
                sb.append(nameValuePair.getName()).append(" = ").append(nameValuePair.getName());
            }
            this.emitTag(tagName, sb.toString(), false);
        }
    }

    public void openCloseTag(String tagName) throws IOException {
        this.emitTag(tagName, true);
    }

    public void openCloseTag(String tagName, XMLAttributeList attributeList) throws IOException {
        if (!this.plainText) {
            this.emitTag(tagName, attributeList.toString(), true);
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<XMLAttributeList.NameValuePair> iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                XMLAttributeList.NameValuePair nameValuePair = iterator.next();
                sb.append("\n");
                for (int i = 0; i < this.nestingLevel; ++i) {
                    sb.append("  ");
                }
                sb.append(nameValuePair.getName()).append(" = ").append(nameValuePair.getName());
            }
            this.emitTag(tagName, sb.toString(), true);
        }
    }

    public void startTag(String tagName) throws IOException {
        this.indent();
        ++this.nestingLevel;
        if (!this.plainText) {
            this.out.write("<");
        }
        this.out.write(tagName);
    }

    public void addAttribute(String name, String value) throws IOException {
        if (this.plainText) {
            this.out.write("\n");
            for (int i = 0; i < this.nestingLevel; ++i) {
                this.out.write("  ");
            }
        }
        this.out.write(32);
        this.out.write(name);
        this.out.write(61);
        this.out.write(34);
        this.out.write(XMLAttributeList.getQuotedAttributeValue(value));
        this.out.write(34);
    }

    public void stopTag(boolean close) throws IOException {
        if (close) {
            if (!this.plainText) {
                this.out.write("/>");
            }
            this.out.write("\n");
            --this.nestingLevel;
            this.newLine = true;
        } else {
            if (!this.plainText) {
                this.out.write(">");
            } else {
                this.out.write("\n");
            }
            this.newLine = false;
        }
    }

    private void emitTag(String tagName, boolean close) throws IOException {
        this.startTag(tagName);
        this.stopTag(close);
    }

    private void emitTag(String tagName, String attributes, boolean close) throws IOException {
        this.startTag(tagName);
        attributes = attributes.trim();
        if (attributes.length() > 0) {
            this.out.write(" ");
            this.out.write(attributes);
        }
        this.stopTag(close);
    }

    public void closeTag(String tagName) throws IOException {
        --this.nestingLevel;
        if (this.newLine) {
            this.indent();
        }
        if (!this.plainText) {
            this.out.write("</" + tagName + ">");
        }
        this.out.write("\n");
        this.newLine = true;
    }

    public void writeText(String text) throws IOException {
        this.out.write(Strings.escapeXml(text));
    }

    public void writeCDATA(String cdata) throws IOException {
        assert (cdata.indexOf("]]") == -1);
        if (!this.plainText) {
            this.out.write("<![CDATA[");
        } else {
            this.out.write("\n");
        }
        this.out.write(cdata);
        if (!this.plainText) {
            this.out.write("]]>");
        } else {
            this.out.write("\n");
        }
        this.newLine = false;
    }

    @DischargesObligation
    public void finish() throws IOException {
        this.out.flush();
        this.out.close();
    }

    private void indent() throws IOException {
        if (!this.newLine) {
            this.out.write("\n");
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.out.write("  ");
        }
    }
}

