/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.IGuiCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;

public class CommandLineUiCallback
implements IGuiCallback {
    public void showMessageDialog(String message) {
        System.out.println(message);
    }

    public int showConfirmDialog(String message, String title, int optionType) {
        int response;
        String confirmStr = "Yes (Y) or No (N)?";
        switch (optionType) {
            case 1: {
                confirmStr = "Yes (Y), No (N), or Cancel (C)?";
                break;
            }
            case 2: {
                confirmStr = "Ok (Y) or Cancel (C)?";
                break;
            }
            case -1: {
                confirmStr = "Press Y to continue.";
            }
        }
        System.out.println(String.format("Confirmation required: %s\n\t%s\n\t%s", title, message, confirmStr));
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String answer = null;
        while (true) {
            try {
                answer = br.readLine();
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("IO error trying to read System.in!");
            }
            response = this.parseAnswer(answer);
            if (response != 0) break;
            System.out.println(String.format("\t%s", confirmStr));
        }
        return response;
    }

    private int parseAnswer(String answer) {
        if (null == answer || answer.length() == 0) {
            return 0;
        }
        char option = answer.toLowerCase(Locale.ENGLISH).charAt(0);
        switch (option) {
            case 'o': {
                return 0;
            }
            case 'y': {
                return 0;
            }
            case 'n': {
                return 1;
            }
            case 'c': {
                return 2;
            }
        }
        return -1;
    }

    public InputStream getProgressMonitorInputStream(InputStream in, int length, String msg) {
        return in;
    }

    public void setErrorMessage(String errorMsg) {
        System.err.println(errorMsg);
    }

    public void displayNonmodelMessage(String title, String message) {
        System.out.println(String.format("Message: %s\n%s", title, message));
    }

    public String showQuestionDialog(String message, String title, String defaultValue) {
        throw new UnsupportedOperationException();
    }

    public boolean showDocument(URL u) {
        return false;
    }
}

