/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowValueChooser;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.SignatureParser;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.StackConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Frame<ValueType> {
    private int lastUpdateTimestamp;
    private int numLocals;
    private ArrayList<ValueType> slotList;
    private boolean isTop;
    private boolean isBottom;
    private static final int DEFAULT_STACK_CAPACITY = 4;
    private static final boolean STACK_ONLY = SystemProperties.getBoolean("dataflow.stackonly");

    public Frame(int numLocals) {
        this.numLocals = numLocals;
        this.slotList = new ArrayList(numLocals + 4);
        for (int i = 0; i < numLocals; ++i) {
            this.slotList.add(null);
        }
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setTop() {
        this.isTop = true;
        this.isBottom = false;
        this.lastUpdateTimestamp = 0;
    }

    public boolean isBottom() {
        return this.isBottom;
    }

    public void setBottom() {
        this.isBottom = true;
        this.isTop = false;
    }

    public void setValid() {
        this.isBottom = false;
        this.isTop = false;
    }

    public boolean isValid() {
        return !this.isTop() && !this.isBottom();
    }

    public void pushValue(ValueType value) {
        if (Debug.VERIFY_INTEGRITY && value == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValid()) {
            throw new IllegalStateException("accessing top or bottom frame");
        }
        this.slotList.add(value);
    }

    public ValueType popValue() throws DataflowAnalysisException {
        if (!this.isValid()) {
            throw new DataflowAnalysisException("accessing top or bottom frame");
        }
        if (this.slotList.size() == this.numLocals) {
            throw new DataflowAnalysisException("operand stack empty");
        }
        return this.slotList.remove(this.slotList.size() - 1);
    }

    public ValueType getTopValue() throws DataflowAnalysisException {
        if (!this.isValid()) {
            throw new DataflowAnalysisException("accessing top or bottom frame");
        }
        assert (this.slotList.size() >= this.numLocals);
        if (this.slotList.size() == this.numLocals) {
            throw new DataflowAnalysisException("operand stack is empty");
        }
        return this.slotList.get(this.slotList.size() - 1);
    }

    public void getTopStackWords(ValueType[] valueList) throws DataflowAnalysisException {
        int stackDepth = this.getStackDepth();
        if (valueList.length > stackDepth) {
            throw new DataflowAnalysisException("not enough values on stack");
        }
        int numSlots = this.slotList.size();
        int i = numSlots - valueList.length;
        int j = 0;
        while (i < numSlots) {
            valueList[j] = this.slotList.get(i);
            ++i;
            ++j;
        }
    }

    public ValueType getStackValue(int loc) throws DataflowAnalysisException {
        if (!this.isValid()) {
            throw new DataflowAnalysisException("Accessing TOP or BOTTOM frame!");
        }
        int stackDepth = this.getStackDepth();
        if (loc >= stackDepth) {
            throw new DataflowAnalysisException("not enough values on stack: access=" + loc + ", avail=" + stackDepth);
        }
        return this.slotList.get(this.slotList.size() - (loc + 1));
    }

    public int getStackLocation(int loc) throws DataflowAnalysisException {
        int stackDepth = this.getStackDepth();
        if (loc >= stackDepth) {
            throw new DataflowAnalysisException("not enough values on stack: access=" + loc + ", avail=" + stackDepth);
        }
        return this.slotList.size() - (loc + 1);
    }

    public ValueType getInstance(Instruction ins, ConstantPoolGen cpg) throws DataflowAnalysisException {
        return this.getStackValue(this.getInstanceStackLocation(ins, cpg));
    }

    public int getInstanceStackLocation(Instruction ins, ConstantPoolGen cpg) throws DataflowAnalysisException {
        int numConsumed = ins.consumeStack(cpg);
        if (numConsumed == -2) {
            throw new DataflowAnalysisException("Unpredictable stack consumption in " + ins);
        }
        return numConsumed - 1;
    }

    public int getInstanceSlot(Instruction ins, ConstantPoolGen cpg) throws DataflowAnalysisException {
        if (!this.isValid()) {
            throw new DataflowAnalysisException("Accessing invalid frame at " + ins);
        }
        int numConsumed = ins.consumeStack(cpg);
        if (numConsumed == -2) {
            throw new DataflowAnalysisException("Unpredictable stack consumption in " + ins);
        }
        if (numConsumed > this.getStackDepth()) {
            throw new DataflowAnalysisException("Stack underflow " + ins);
        }
        return this.getNumSlots() - numConsumed;
    }

    public int getNumArguments(InvokeInstruction ins, ConstantPoolGen cpg) throws DataflowAnalysisException {
        SignatureParser parser = new SignatureParser(ins.getSignature(cpg));
        return parser.getNumParameters();
    }

    public int getNumArgumentsIncludingObjectInstance(InvokeInstruction ins, ConstantPoolGen cpg) throws DataflowAnalysisException {
        int numConsumed = ins.consumeStack(cpg);
        if (numConsumed == -2) {
            throw new DataflowAnalysisException("Unpredictable stack consumption in " + ins);
        }
        return numConsumed;
    }

    @Deprecated
    public ValueType getArgument(InvokeInstruction ins, ConstantPoolGen cpg, int i, int numArguments) throws DataflowAnalysisException {
        SignatureParser sigParser = new SignatureParser(ins.getSignature(cpg));
        return this.getArgument(ins, cpg, i, sigParser);
    }

    public ValueType getArgument(InvokeInstruction ins, ConstantPoolGen cpg, int i, SignatureParser sigParser) throws DataflowAnalysisException {
        if (i >= sigParser.getNumParameters()) {
            throw new IllegalArgumentException("requesting parameter # " + i + " of " + sigParser);
        }
        return this.getStackValue(sigParser.getSlotsFromTopOfStackForParameter(i));
    }

    public int getArgumentSlot(int i, int numArguments) {
        if (i >= numArguments) {
            throw new IllegalArgumentException();
        }
        return this.slotList.size() - numArguments + i;
    }

    public ValueType getOperand(StackConsumer ins, ConstantPoolGen cpg, int i) throws DataflowAnalysisException {
        int numOperands = ins.consumeStack(cpg);
        if (numOperands == -2) {
            throw new DataflowAnalysisException("Unpredictable stack consumption in " + ins);
        }
        return this.getStackValue(numOperands - 1 - i);
    }

    public BitSet getArgumentSet(InvokeInstruction invokeInstruction, ConstantPoolGen cpg, DataflowValueChooser<ValueType> chooser) throws DataflowAnalysisException {
        BitSet chosenArgSet = new BitSet();
        SignatureParser sigParser = new SignatureParser(invokeInstruction.getSignature(cpg));
        for (int i = 0; i < sigParser.getNumParameters(); ++i) {
            ValueType value = this.getArgument(invokeInstruction, cpg, i, sigParser);
            if (!chooser.choose(value)) continue;
            chosenArgSet.set(i);
        }
        return chosenArgSet;
    }

    public void clearStack() {
        if (!this.isValid()) {
            throw new IllegalStateException("accessing top or bottom frame");
        }
        assert (this.slotList.size() >= this.numLocals);
        if (this.slotList.size() > this.numLocals) {
            this.slotList.subList(this.numLocals, this.slotList.size()).clear();
        }
    }

    public int getStackDepth() {
        return this.slotList.size() - this.numLocals;
    }

    public int getNumLocals() {
        return this.numLocals;
    }

    public int getNumSlots() {
        return this.slotList.size();
    }

    public boolean contains(ValueType value) {
        if (!this.isValid()) {
            throw new IllegalStateException("accessing top or bottom frame");
        }
        for (ValueType v : this.slotList) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public ValueType getValue(int n) {
        if (!this.isValid()) {
            throw new IllegalStateException("accessing top or bottom frame");
        }
        return this.slotList.get(n);
    }

    public void setValue(int n, ValueType value) {
        if (Debug.VERIFY_INTEGRITY && value == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValid()) {
            throw new IllegalStateException("accessing top or bottom frame");
        }
        this.slotList.set(n, value);
    }

    public boolean sameAs(Frame<ValueType> other) {
        if (this.isTop != other.isTop) {
            return false;
        }
        if (this.isTop && other.isTop) {
            return true;
        }
        if (this.isBottom != other.isBottom) {
            return false;
        }
        if (this.isBottom && other.isBottom) {
            return true;
        }
        if (this.getNumSlots() != other.getNumSlots()) {
            return false;
        }
        for (int i = 0; i < this.getNumSlots(); ++i) {
            if (this.getValue(i).equals(other.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public void copyFrom(Frame<ValueType> other) {
        this.lastUpdateTimestamp = other.lastUpdateTimestamp;
        this.slotList.clear();
        this.slotList.addAll(other.slotList);
        this.isTop = other.isTop;
        this.isBottom = other.isBottom;
    }

    public String toString() {
        int start;
        if (this.isTop()) {
            return "[TOP]";
        }
        if (this.isBottom()) {
            return "[BOTTOM]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int numSlots = this.getNumSlots();
        for (int i = start = STACK_ONLY ? this.getNumLocals() : 0; i < numSlots; ++i) {
            if (!STACK_ONLY && i == this.getNumLocals()) {
                int last = buf.length() - 1;
                if (last >= 0 && buf.charAt(last) == ',') {
                    buf.deleteCharAt(last);
                }
                buf.append('|');
            }
            String value = this.valueToString(this.getValue(i));
            if (i == numSlots - 1 && value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            buf.append(value);
        }
        buf.append(']');
        return buf.toString();
    }

    protected String valueToString(ValueType value) {
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public Collection<ValueType> allSlots() {
        if (this.slotList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.slotList);
    }

    public void setLastUpdateTimestamp(int lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public int getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }
}

