/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.workbench.IconNameValueVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.util.StringHelper;

public class HibernateWorkbenchHelper {
    public static ImageDescriptor getImageDescriptor(Property property) {
        if (property == null) {
            return null;
        }
        if (property.getPersistentClass() != null && property.getPersistentClass().getIdentifierProperty() == property) {
            return EclipseImages.getImageDescriptor("IDPROPERTY");
        }
        String iconNameForValue = HibernateWorkbenchHelper.getIconNameForValue(property.getValue());
        return EclipseImages.getImageDescriptor(iconNameForValue);
    }

    public static Image getImage(Property property) {
        if (property == null) {
            return null;
        }
        if (property.getPersistentClass() != null && property.getPersistentClass().getIdentifierProperty() == property) {
            return EclipseImages.getImage("IDPROPERTY");
        }
        String iconNameForValue = HibernateWorkbenchHelper.getIconNameForValue(property.getValue());
        return EclipseImages.getImage(iconNameForValue);
    }

    private static String getIconNameForValue(Value value) {
        String result = (String)value.accept((ValueVisitor)new IconNameValueVisitor());
        if (result == null) {
            result = "UNKNOWNPROPERTY";
        }
        return result;
    }

    public static String getLabelForClassName(String classOrEntityName) {
        if (classOrEntityName.indexOf(46) >= 0) {
            classOrEntityName = StringHelper.unqualify((String)classOrEntityName);
        }
        return classOrEntityName;
    }
}

