/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportersXMLAttributeDescription {
    public static final String ANT_TASKS_DESCRIPTION_PATH = "org/hibernate/eclipse/launch/ant-tasks-description.xml";
    private static Map<String, Map<String, AttributeDescription>> mapExporter2AttributeDescr = null;
    private static Map<String, Set<String>> mapExporter2SetSubTags = null;

    private static void initExportersDescriptionmap() {
        if (mapExporter2AttributeDescr != null) {
            return;
        }
        mapExporter2AttributeDescr = new TreeMap<String, Map<String, AttributeDescription>>();
        mapExporter2SetSubTags = new TreeMap<String, Set<String>>();
        Document doc = ExportersXMLAttributeDescription.getDocument();
        if (doc == null) {
            return;
        }
        Element root = doc.getRootElement();
        Iterator itTask = root.elementIterator("task");
        while (itTask.hasNext()) {
            Element elTask = (Element)itTask.next();
            TreeMap<String, AttributeDescription> attributes = new TreeMap<String, AttributeDescription>();
            Iterator itAttribute = elTask.elementIterator("attribute");
            while (itAttribute.hasNext()) {
                Element elAttribute = (Element)itAttribute.next();
                AttributeDescription ad = new AttributeDescription();
                ad.name = elAttribute.attributeValue("name");
                ad.guiName = elAttribute.attributeValue("gui-name");
                ad.defaultValue = elAttribute.attributeValue("default");
                attributes.put(ad.guiName, ad);
            }
            TreeSet<String> subtags = new TreeSet<String>();
            itAttribute = elTask.elementIterator("subtag");
            while (itAttribute.hasNext()) {
                Element elAttribute = (Element)itAttribute.next();
                AttributeDescription ad = new AttributeDescription();
                ad.name = elAttribute.attributeValue("name");
                ad.guiName = elAttribute.attributeValue("gui-name");
                ad.defaultValue = elAttribute.attributeValue("default");
                attributes.put(ad.guiName, ad);
                subtags.add(ad.guiName);
            }
            String taskName = elTask.attributeValue("name");
            mapExporter2AttributeDescr.put(taskName, attributes);
            mapExporter2SetSubTags.put(taskName, subtags);
        }
    }

    public static Map<String, Map<String, AttributeDescription>> getExportersDescription() {
        ExportersXMLAttributeDescription.initExportersDescriptionmap();
        TreeMap<String, Map<String, AttributeDescription>> res = new TreeMap<String, Map<String, AttributeDescription>>();
        res.putAll(mapExporter2AttributeDescr);
        return res;
    }

    public static Map<String, Set<String>> getExportersSetSubTags() {
        ExportersXMLAttributeDescription.initExportersDescriptionmap();
        TreeMap<String, Set<String>> res = new TreeMap<String, Set<String>>();
        res.putAll(mapExporter2SetSubTags);
        return res;
    }

    private static Document getDocument() {
        StringBuffer cbuf;
        block33: {
            InputStream input = ExportersXMLAttributeDescription.getResInputStream(ANT_TASKS_DESCRIPTION_PATH, ExportersXMLAttributeDescription.class);
            if (input == null) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Can't read resource: org/hibernate/eclipse/launch/ant-tasks-description.xml", (Throwable)null);
                return null;
            }
            cbuf = new StringBuffer();
            InputStreamReader isReader = null;
            BufferedReader in = null;
            try {
                try {
                    String str;
                    String ls = System.getProperties().getProperty("line.separator", "\n");
                    isReader = new InputStreamReader(input);
                    in = new BufferedReader(isReader);
                    while ((str = in.readLine()) != null) {
                        cbuf.append(String.valueOf(str) + ls);
                    }
                }
                catch (IOException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("IOException: ", e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (isReader != null) {
                        try {
                            isReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (isReader != null) {
                    try {
                        isReader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (isReader != null) {
                try {
                    isReader.close();
                }
                catch (IOException iOException) {}
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        Document res = null;
        try {
            res = DocumentHelper.parseText((String)cbuf.toString());
        }
        catch (DocumentException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("DocumentException: ", e);
        }
        return res;
    }

    public static InputStream getResInputStream(final String resName, final Class clazz) {
        InputStream input = null;
        input = System.getSecurityManager() == null ? ExportersXMLAttributeDescription.getResInputStreamInternal(resName, clazz) : (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ExportersXMLAttributeDescription.getResInputStreamInternal(resName, clazz);
            }
        });
        return input;
    }

    static InputStream getResInputStreamInternal(String resName, Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        InputStream input = loader == null ? ClassLoader.getSystemResourceAsStream(resName) : loader.getResourceAsStream(resName);
        return input;
    }

    public static class AttributeDescription {
        public String name;
        public String guiName;
        public String defaultValue;
    }
}

