/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileChange;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.hibernate.eclipse.console.HibernateConsoleMessages;

public class ConnectionProfileRenameChange
extends ConnectionProfileChange {
    private ILaunchConfiguration fLaunchConfiguration;
    private RenameArguments fRenameArguments;

    public ConnectionProfileRenameChange(ILaunchConfiguration config, IConnectionProfile source, RenameArguments renameArguments) {
        super(source, null);
        this.fLaunchConfiguration = config;
        this.fRenameArguments = renameArguments;
    }

    public String getName() {
        return HibernateConsoleMessages.ConnectionProfileRenameChange_update_connection_profile_name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.fLaunchConfiguration.exists()) {
            IPath location;
            IPath rootLoacation;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IFile[] files = root.findFilesForLocation((rootLoacation = root.getLocation()).append(location = this.fLaunchConfiguration.getLocation()));
            if (files.length > 0) {
                this.fLaunchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(files[0]);
            }
            ILaunchConfigurationWorkingCopy wc = this.fLaunchConfiguration.getWorkingCopy();
            String oldName = wc.getAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", "");
            wc.setAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", this.fRenameArguments.getNewName());
            ILaunchConfiguration newConfig = wc.isDirty() ? wc.doSave() : this.fLaunchConfiguration;
            RenameArguments args = new RenameArguments(oldName, true);
            return new ConnectionProfileRenameChange(newConfig, this.mSource, args);
        }
        return null;
    }
}

