/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.execution.ExecutionContextHolder;
import org.hibernate.console.node.NodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseNode
implements TreeNode,
ExecutionContextHolder {
    protected BaseNode parent;
    protected NodeFactory factory;
    protected List<BaseNode> children = new ArrayList<BaseNode>();
    protected String name = "!";
    String iconName = "UNKNOWNPROPERTY";

    protected abstract void checkChildren();

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.factory.getConsoleConfiguration();
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.factory.getConsoleConfiguration().getExecutionContext();
    }

    public String getIconName() {
        return this.iconName;
    }

    public BaseNode(NodeFactory f, BaseNode parent) {
        this.factory = f;
        this.parent = parent;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.checkChildren();
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.checkChildren();
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        this.checkChildren();
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        this.checkChildren();
        return this.getChildCount() == 0;
    }

    public Enumeration<BaseNode> children() {
        this.checkChildren();
        return Collections.enumeration(this.children);
    }

    public abstract String getHQL();

    public String getName() {
        return this.name;
    }

    public final String toString() {
        return this.renderLabel(true);
    }

    protected static String getLabel(String name, boolean fullyQualifiedName) {
        if (!fullyQualifiedName && name != null && name.length() > 1 && name.indexOf(46) >= 0) {
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    public String renderLabel(boolean fullyQualifiedNames) {
        return BaseNode.getLabel(this.getName(), fullyQualifiedNames);
    }

    public void clear() {
        for (BaseNode element : this.children) {
            element.clear();
        }
    }
}

