/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import java.util.ArrayList;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.ConfigurationEntitiesNode;
import org.hibernate.console.node.NodeFactory;
import org.hibernate.console.node.PersistentCollectionNode;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class ClassNode
extends BaseNode {
    ClassMetadata md;
    boolean objectGraph;
    Object baseObject;
    boolean childrenCreated = false;

    public ClassNode(NodeFactory factory, BaseNode parent, String name, ClassMetadata metadata, Object baseObject, boolean objectGraph) {
        super(factory, parent);
        this.name = name;
        this.baseObject = baseObject;
        this.objectGraph = objectGraph;
        this.md = metadata;
        this.iconName = this.md != null ? "MAPPEDCLASS" : "UNMAPPEDCLASS";
    }

    protected void checkChildren() {
        if (!this.childrenCreated) {
            this.createChildren();
            this.childrenCreated = true;
        }
    }

    protected void createChildren() {
        if (this.objectGraph && this.getValue() == null || this.md == null) {
            return;
        }
        if (this.md.getIdentifierPropertyName() != null) {
            this.children.add(0, this.factory.createIdentifierNode(this, this.md));
        }
        String[] names = this.md.getPropertyNames();
        int i = 0;
        while (i < names.length) {
            Type type = this.md.getPropertyTypes()[i];
            if (type.isCollectionType()) {
                PersistentCollectionNode tn = this.factory.createPersistentCollectionNode(this, names[i], this.md, (CollectionType)type, this.getValue(), this.objectGraph);
                this.children.add(tn);
            } else {
                this.children.add(this.factory.createPropertyNode(this, i, this.md, this.getValue(), this.objectGraph));
            }
            ++i;
        }
    }

    public String getHQL() {
        String cname;
        ArrayList<ClassNode> parents = new ArrayList<ClassNode>();
        BaseNode currentParent = this;
        while (currentParent != null && !(currentParent instanceof ConfigurationEntitiesNode)) {
            parents.add((ClassNode)currentParent);
            currentParent = currentParent.parent;
        }
        if (currentParent instanceof ConfigurationEntitiesNode) {
            currentParent = (BaseNode)parents.get(parents.size() - 1);
        }
        if ((cname = currentParent.md.getMappedClass(EntityMode.POJO).getName()).lastIndexOf(".") != -1) {
            cname = cname.substring(cname.lastIndexOf(".") + 1);
        }
        String alias = cname.toLowerCase();
        String path = "";
        int i = parents.size() - 2;
        while (i >= 0) {
            path = String.valueOf(path) + "." + ((BaseNode)parents.get(i)).getName();
            --i;
        }
        return "select " + alias + path + " from " + cname + " as " + alias;
    }

    public ClassMetadata getClassMetadata() {
        return this.md;
    }

    public String renderLabel(boolean fullyQualifiedNames) {
        if (this.objectGraph) {
            Object o = this.getValue();
            if (Hibernate.isInitialized((Object)o)) {
                return String.valueOf(super.renderLabel(fullyQualifiedNames)) + " = " + o;
            }
            return String.valueOf(super.renderLabel(fullyQualifiedNames)) + " = " + ConsoleMessages.ClassNode_uninitialized_proxy;
        }
        return super.renderLabel(fullyQualifiedNames);
    }

    public Object getValue() {
        if (this.objectGraph) {
            return this.baseObject;
        }
        return null;
    }
}

