/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.logging.xpl;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseLogger {
    public static final int ERROR = 4;
    public static final int ERROR_DEBUG = 204;
    public static final int INFO = 1;
    public static final int INFO_DEBUG = 201;
    public static final int OK = 0;
    public static final int OK_DEBUG = 200;
    private static final String TRACEFILTER_LOCATION = "/debug/tracefilter";
    public static final int WARNING = 2;
    public static final int WARNING_DEBUG = 202;
    private final String PLUGIN_ID;
    private Bundle bundle;

    public EclipseLogger(String pluginid) {
        this.PLUGIN_ID = pluginid;
        this.bundle = Platform.getBundle((String)this.PLUGIN_ID);
    }

    public EclipseLogger(Bundle bundle) {
        this.bundle = bundle;
        this.PLUGIN_ID = bundle.getSymbolicName();
    }

    protected void _log(int level, String message, Throwable exception) {
        if (!(level != 200 && level != 201 && level != 202 && level != 204 || this.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 201: {
                severity = 1;
                break;
            }
            case 2: 
            case 202: {
                severity = 2;
                break;
            }
            case 4: 
            case 204: {
                severity = 4;
            }
        }
        Status statusObj = new Status(severity, this.PLUGIN_ID, severity, message, exception);
        if (this.bundle != null) {
            Platform.getLog((Bundle)this.bundle).log((IStatus)statusObj);
        }
    }

    protected void _trace(String category, String message, Throwable exception) {
        if (!this.isDebugging()) {
            return;
        }
        String traceFilter = Platform.getDebugOption((String)(String.valueOf(this.PLUGIN_ID) + TRACEFILTER_LOCATION));
        if (traceFilter != null) {
            StringTokenizer tokenizer = new StringTokenizer(traceFilter, ",");
            while (tokenizer.hasMoreTokens()) {
                String cat = tokenizer.nextToken().trim();
                if (!category.equals(cat)) continue;
                Status statusObj = new Status(0, this.PLUGIN_ID, 0, message, exception);
                Bundle bundle = Platform.getBundle((String)this.PLUGIN_ID);
                if (bundle != null) {
                    Platform.getLog((Bundle)bundle).log((IStatus)statusObj);
                }
                return;
            }
        }
    }

    public boolean isDebugging() {
        return Platform.inDebugMode();
    }

    public void log(int level, String message) {
        this._log(level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this._log(level, message, exception);
    }

    public void logException(String message, Throwable exception) {
        this._log(4, message, exception);
    }

    public void logException(Throwable exception) {
        this._log(4, exception.getMessage(), exception);
    }

    public void trace(String category, String message) {
        this._trace(category, message, null);
    }

    public void traceException(String category, String message, Throwable exception) {
        this._trace(category, message, exception);
    }

    public void traceException(String category, Throwable exception) {
        this._trace(category, exception.getMessage(), exception);
    }

    public void log(IStatus status) {
        Platform.getLog((Bundle)this.bundle).log(status);
    }
}

